/*
 * Decompiled with CFR 0.152.
 */
package ba.minecraft.uniquemagic.common.event.enchantments.weapons;

import ba.minecraft.uniquemagic.common.core.UniqueMagicModConfig;
import ba.minecraft.uniquemagic.common.enchantments.WeaponEnchants;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="uniquemagic", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class DisarmEnchantmentEventHandler {
    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof Player)) {
            return;
        }
        Player target = (Player)entity;
        Player attacker = event.getEntity();
        Level level = attacker.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        ItemStack attackerItem = attacker.m_21120_(InteractionHand.MAIN_HAND);
        if (attackerItem == null) {
            return;
        }
        int enchantmentLevel = attackerItem.getEnchantmentLevel((Enchantment)WeaponEnchants.DISARM.get());
        if (enchantmentLevel < 1) {
            return;
        }
        RandomSource random = level.m_213780_();
        int hitChance = enchantmentLevel * UniqueMagicModConfig.DISARM_BASE_CHANCE;
        int roll = random.m_188503_(100);
        if (roll >= hitChance) {
            return;
        }
        ItemStack targetItem = target.m_21120_(InteractionHand.MAIN_HAND);
        if (targetItem == null) {
            return;
        }
        target.m_7197_(targetItem, true, true);
        Inventory targetInventory = target.m_150109_();
        targetInventory.m_36057_(targetItem);
    }
}

