/*
 * Decompiled with CFR 0.152.
 */
package ba.minecraft.uniquemagic.common.event.enchantments.tools;

import ba.minecraft.uniquemagic.common.enchantments.DiggerEnchants;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="uniquemagic", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class TimberEnchantmentEventHandler {
    @SubscribeEvent
    public static void onPlayerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ItemStack item = player.m_21205_();
        int enchantmentLevel = item.getEnchantmentLevel((Enchantment)DiggerEnchants.TIMBER.get());
        if (enchantmentLevel < 1) {
            return;
        }
        BlockPos blockPos = event.getPos();
        TimberEnchantmentEventHandler.chopLog(serverLevel, blockPos, item, true);
    }

    private static void chopLog(ServerLevel level, BlockPos blockPos, ItemStack item, boolean isStartingHit) {
        BlockState blockState = level.m_8055_(blockPos);
        if (!blockState.m_204336_(BlockTags.f_13106_) && !blockState.m_204336_(BlockTags.f_13035_)) {
            return;
        }
        BlockEntity blockEntity = blockState.m_155947_() ? level.m_7702_(blockPos) : null;
        Block.m_49881_((BlockState)blockState, (Level)level, (BlockPos)blockPos, (BlockEntity)blockEntity, null, (ItemStack)item);
        level.m_46961_(blockPos, false);
        if (!isStartingHit) {
            TimberEnchantmentEventHandler.chopLog(level, blockPos.m_7495_(), item, false);
        }
        TimberEnchantmentEventHandler.chopLog(level, blockPos.m_122012_(), item, false);
        TimberEnchantmentEventHandler.chopLog(level, blockPos.m_122019_(), item, false);
        TimberEnchantmentEventHandler.chopLog(level, blockPos.m_122029_(), item, false);
        TimberEnchantmentEventHandler.chopLog(level, blockPos.m_122024_(), item, false);
        TimberEnchantmentEventHandler.chopLog(level, blockPos.m_7494_(), item, false);
        TimberEnchantmentEventHandler.chopLog(level, blockPos.m_7494_().m_122012_(), item, false);
        TimberEnchantmentEventHandler.chopLog(level, blockPos.m_7494_().m_122019_(), item, false);
        TimberEnchantmentEventHandler.chopLog(level, blockPos.m_7494_().m_122029_(), item, false);
        TimberEnchantmentEventHandler.chopLog(level, blockPos.m_7494_().m_122024_(), item, false);
    }
}

