/*
 * Decompiled with CFR 0.152.
 */
package ba.minecraft.uniquemagic.common.core;

import ba.minecraft.uniquemagic.common.core.UniqueMagicModConfig;
import ba.minecraft.uniquemagic.common.enchantments.ArmorEnchants;
import ba.minecraft.uniquemagic.common.enchantments.DiggerEnchants;
import ba.minecraft.uniquemagic.common.enchantments.WeaponEnchants;
import ba.minecraft.uniquemagic.common.mobeffects.HarmfulMobEffects;
import com.mojang.logging.LogUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="uniquemagic")
public class UniqueMagicMod {
    public static final String MODID = "uniquemagic";
    private static final Logger LOGGER = LogUtils.getLogger();

    public UniqueMagicMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        WeaponEnchants.REGISTRY.register(modEventBus);
        DiggerEnchants.REGISTRY.register(modEventBus);
        ArmorEnchants.REGISTRY.register(modEventBus);
        HarmfulMobEffects.REGISTRY.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)UniqueMagicModConfig.SPEC, "uniquemagic-server.toml");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Unique Magic loading...");
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        LOGGER.info("Unique Magic loaded!");
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("Unique Magic unloading...");
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        LOGGER.info("Unique Magic unloaded!");
    }
}

