/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.particle.AirParticleData;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class BacktankBlockEntity
extends KineticBlockEntity
implements Nameable {
    public int airLevel;
    public int airLevelTimer;
    private Component defaultName;
    private Component customName;
    private int capacityEnchantLevel;
    private CompoundTag vanillaTag;
    private CompoundTag forgeCapsTag;

    public BacktankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.defaultName = BacktankBlockEntity.getDefaultName(state);
        this.vanillaTag = new CompoundTag();
        this.forgeCapsTag = null;
    }

    public static Component getDefaultName(BlockState state) {
        if (AllBlocks.NETHERITE_BACKTANK.has(state)) {
            ((BacktankItem)AllItems.NETHERITE_BACKTANK.get()).m_41466_();
        }
        return ((BacktankItem)AllItems.COPPER_BACKTANK.get()).m_41466_();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.BACKTANK);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (this.getSpeed() != 0.0f) {
            this.award(AllAdvancements.BACKTANK);
        }
    }

    @Override
    public void tick() {
        BooleanProperty waterProperty;
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)(waterProperty = BlockStateProperties.f_61362_)) && ((Boolean)state.m_61143_((Property)waterProperty)).booleanValue()) {
            return;
        }
        if (this.airLevelTimer > 0) {
            --this.airLevelTimer;
            return;
        }
        int max = BacktankUtil.maxAir(this.capacityEnchantLevel);
        if (this.f_58857_.f_46443_) {
            Vec3 centerOf = VecHelper.getCenterOf((Vec3i)this.f_58858_);
            Vec3 v = VecHelper.offsetRandomly(centerOf, this.f_58857_.f_46441_, 0.65f);
            Vec3 m = centerOf.m_82546_(v);
            if (this.airLevel != max) {
                this.f_58857_.m_7106_((ParticleOptions)new AirParticleData(1.0f, 0.05f), v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
            }
            return;
        }
        if (this.airLevel == max) {
            return;
        }
        int prevComparatorLevel = this.getComparatorOutput();
        float abs = Math.abs(this.getSpeed());
        int increment = Mth.m_14045_((int)(((int)abs - 100) / 20), (int)1, (int)5);
        this.airLevel = Math.min(max, this.airLevel + increment);
        if (this.getComparatorOutput() != prevComparatorLevel && !this.f_58857_.f_46443_) {
            this.f_58857_.m_46717_(this.f_58858_, state.m_60734_());
        }
        if (this.airLevel == max) {
            this.sendData();
        }
        this.airLevelTimer = Mth.m_14045_((int)((int)(128.0f - abs / 5.0f) - 108), (int)0, (int)20);
    }

    public int getComparatorOutput() {
        int max = BacktankUtil.maxAir(this.capacityEnchantLevel);
        return ComparatorUtil.fractionToRedstoneLevel((float)this.airLevel / (float)max);
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Air", this.airLevel);
        compound.m_128405_("Timer", this.airLevelTimer);
        compound.m_128405_("CapacityEnchantment", this.capacityEnchantLevel);
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("VanillaTag", (Tag)this.vanillaTag);
        if (this.forgeCapsTag != null) {
            compound.m_128365_("ForgeCapsTag", (Tag)this.forgeCapsTag);
        }
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        int prev = this.airLevel;
        this.airLevel = compound.m_128451_("Air");
        this.airLevelTimer = compound.m_128451_("Timer");
        this.capacityEnchantLevel = compound.m_128451_("CapacityEnchantment");
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        this.vanillaTag = compound.m_128469_("VanillaTag");
        CompoundTag compoundTag = this.forgeCapsTag = compound.m_128441_("ForgeCapsTag") ? compound.m_128469_("ForgeCapsTag") : null;
        if (prev != 0 && prev != this.airLevel && this.airLevel == BacktankUtil.maxAir(this.capacityEnchantLevel) && clientPacket) {
            this.playFilledEffect();
        }
    }

    protected void playFilledEffect() {
        AllSoundEvents.CONFIRM.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.4f, 1.0f, true);
        Vec3 baseMotion = new Vec3(0.25, 0.1, 0.0);
        Vec3 baseVec = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        for (int i = 0; i < 360; i += 10) {
            Vec3 m = VecHelper.rotate(baseMotion, i, Direction.Axis.Y);
            Vec3 v = baseVec.m_82549_(m.m_82541_().m_82490_(0.25));
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123764_, v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.defaultName;
    }

    public int getAirLevel() {
        return this.airLevel;
    }

    public void setAirLevel(int airLevel) {
        this.airLevel = airLevel;
        this.sendData();
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public void setCapacityEnchantLevel(int capacityEnchantLevel) {
        this.capacityEnchantLevel = capacityEnchantLevel;
    }

    public void setTags(CompoundTag vanillaTag, @Nullable CompoundTag forgeCapsTag) {
        this.vanillaTag = vanillaTag;
        this.forgeCapsTag = forgeCapsTag;
    }

    public CompoundTag getVanillaTag() {
        return this.vanillaTag;
    }

    public CompoundTag getForgeCapsTag() {
        return this.forgeCapsTag;
    }
}

