/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.message;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class UpdateBossBarMessage {
    private UUID bossBar;
    private int renderType;

    public UpdateBossBarMessage(UUID bossBar, int renderType) {
        this.bossBar = bossBar;
        this.renderType = renderType;
    }

    public static UpdateBossBarMessage read(FriendlyByteBuf buf) {
        return new UpdateBossBarMessage(buf.m_130259_(), buf.readInt());
    }

    public static void write(UpdateBossBarMessage message, FriendlyByteBuf buf) {
        buf.m_130077_(message.bossBar);
        buf.writeInt(message.renderType);
    }

    public static void handle(UpdateBossBarMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().setPacketHandled(true);
        ServerPlayer playerSided = context.get().getSender();
        if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            playerSided = AlexsCaves.PROXY.getClientSidePlayer();
        }
        if (message.renderType == -1) {
            AlexsCaves.PROXY.removeBossBarRender(message.bossBar);
        } else {
            AlexsCaves.PROXY.setBossBarRender(message.bossBar, message.renderType);
        }
    }
}

