/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.CakeCaveStructurePiece;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.GingerbreadHousePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class GingerbreadRoadPiece
extends StructurePiece {
    private final StructureTemplateManager structureTemplateManager;
    private final BlockPos origin;
    private final int length;
    private final int branchesLeft;
    private final Direction direction;
    public final List<StructurePiece> pendingChildren = Lists.newArrayList();

    public GingerbreadRoadPiece(StructureTemplateManager structureTemplateManager, BlockPos blockpos, int length, int branchesLeft, Direction direction) {
        super((StructurePieceType)ACStructurePieceRegistry.GINGERBREAD_ROAD.get(), 0, GingerbreadRoadPiece.createBoundingBox(blockpos, direction, length));
        this.structureTemplateManager = structureTemplateManager;
        this.origin = blockpos;
        this.length = length;
        this.branchesLeft = branchesLeft;
        this.direction = direction;
    }

    public GingerbreadRoadPiece(StructureTemplateManager manager, CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.GINGERBREAD_ROAD.get(), tag);
        this.structureTemplateManager = manager;
        this.origin = new BlockPos(tag.m_128451_("OX"), tag.m_128451_("OY"), tag.m_128451_("OZ"));
        this.length = tag.m_128451_("Length");
        this.branchesLeft = tag.m_128451_("BranchesLeft");
        this.direction = Direction.m_122407_((int)tag.m_128451_("Direction"));
    }

    public GingerbreadRoadPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        this(context.f_226956_(), tag);
    }

    private static BoundingBox createBoundingBox(BlockPos origin, Direction direction, int length) {
        BoundingBox bb1 = BoundingBox.m_162375_((Vec3i)origin, (Vec3i)origin.m_5484_(direction, length));
        return new BoundingBox(bb1.m_162395_(), -64, bb1.m_162398_(), bb1.m_162399_(), bb1.m_162400_() + 10, bb1.m_162401_());
    }

    private BoundingBox inflateRoadBox(int by) {
        BoundingBox bb1 = this.m_73547_();
        int absX = Math.abs(this.direction.m_122429_()) * by;
        int absZ = Math.abs(this.direction.m_122431_()) * by;
        return new BoundingBox(bb1.m_162395_() + absX, -64, bb1.m_162398_() + absZ, bb1.m_162399_() + absX, bb1.m_162400_() + 10, bb1.m_162401_() + absZ);
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.m_128405_("OX", this.origin.m_123341_());
        tag.m_128405_("OY", this.origin.m_123342_());
        tag.m_128405_("OZ", this.origin.m_123343_());
        tag.m_128405_("Length", this.length);
        tag.m_128405_("BranchesLeft", this.branchesLeft);
        tag.m_128405_("Direction", this.direction.m_122416_());
    }

    public void m_213694_(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        BlockPos building = this.origin;
        int prevYLevel = -1;
        for (int built = 0; built < this.length; ++built) {
            int y = (int)CakeCaveStructurePiece.calculatePlateauHeight(building.m_123341_(), building.m_123343_(), 7, true);
            BlockPos set = building.m_175288_(y - 1);
            if (worldGenLevel.m_8055_(set.m_7494_()).m_280296_() && set.m_123342_() < worldGenLevel.m_151558_()) {
                set = set.m_7494_();
            }
            if (boundingBox.m_71051_((Vec3i)set)) {
                BlockState replaceState = worldGenLevel.m_8055_(set);
                boolean placeFlag = false;
                if (replaceState.m_204336_(ACTagRegistry.GINGERBREAD_TOWN_GEN_REPLACEABLES)) {
                    placeFlag = true;
                } else if (replaceState.m_247087_()) {
                    placeFlag = true;
                    set = set.m_7495_();
                }
                if (placeFlag) {
                    worldGenLevel.m_7731_(set, ((Block)ACBlockRegistry.GINGERBREAD_BRICKS.get()).m_49966_(), 2);
                    if (prevYLevel > set.m_123342_() && built > 0) {
                        worldGenLevel.m_7731_(set.m_7494_(), ((Block)ACBlockRegistry.GINGERBREAD_BRICK_SLAB.get()).m_49966_(), 2);
                    }
                }
            }
            building = building.m_121945_(this.direction);
            prevYLevel = set.m_123342_();
        }
    }

    public void m_214092_(StructurePiece startPiece, StructurePieceAccessor piecesBuilder, RandomSource randomSource) {
        if (startPiece instanceof GingerbreadRoadPiece) {
            GingerbreadRoadPiece startRoadPiece = (GingerbreadRoadPiece)startPiece;
            if (this.branchesLeft > 0) {
                for (int childrenIndex = 0; childrenIndex < this.branchesLeft; ++childrenIndex) {
                    Object childPiece;
                    Direction childDir = this.selectAnyOther(randomSource, true);
                    int i = Math.max(this.length / 5, 2);
                    int j = i + randomSource.m_188503_(Math.max(this.length - i, 1));
                    BlockPos offsetPos = this.origin.m_5484_(this.direction, j).m_121945_(this.direction);
                    boolean isRoad = false;
                    if (randomSource.m_188501_() < 0.5f) {
                        ResourceLocation templateResLoc = (ResourceLocation)Util.m_214670_((Object[])GingerbreadHousePiece.HOUSE_TEMPLATES, (RandomSource)randomSource);
                        StructureTemplate houseTemplate = this.structureTemplateManager.m_230359_(templateResLoc);
                        Rotation rotation = GingerbreadRoadPiece.getRotationFromDirectionDefaultNorth(childDir);
                        Vec3i centerSize = houseTemplate.m_163808_(rotation);
                        BlockPos houseCenterPos1 = offsetPos.m_7918_(-centerSize.m_123341_() / 2, 0, -centerSize.m_123343_() / 2);
                        BlockPos houseCenterPos2 = houseTemplate.m_74583_(houseCenterPos1, Mirror.NONE, rotation);
                        BlockPos houseCenterPos3 = houseCenterPos2.m_7918_(childDir.m_122429_() * -(centerSize.m_123341_() / 2 + 1), 0, childDir.m_122431_() * -(centerSize.m_123343_() / 2 + 1));
                        childPiece = new GingerbreadHousePiece(this.structureTemplateManager, templateResLoc, houseCenterPos3, rotation);
                    } else {
                        childPiece = new GingerbreadRoadPiece(this.structureTemplateManager, offsetPos, Math.max(4, this.length / 2), this.branchesLeft - 1, childDir);
                        isRoad = true;
                    }
                    if (GingerbreadRoadPiece.intersectsWithAnyPendingChildren(startRoadPiece, childPiece, isRoad)) continue;
                    startRoadPiece.pendingChildren.add((StructurePiece)childPiece);
                    piecesBuilder.m_142679_((StructurePiece)childPiece);
                }
            }
        }
    }

    private static boolean intersectsWithAnyPendingChildren(StructurePiece startPiece, StructurePiece newPiece, boolean inflateRoads) {
        if (startPiece instanceof GingerbreadRoadPiece) {
            GingerbreadRoadPiece startRoadPiece = (GingerbreadRoadPiece)startPiece;
            for (StructurePiece pendingChild : startRoadPiece.pendingChildren) {
                BoundingBox box = pendingChild.m_73547_();
                if (inflateRoads && pendingChild instanceof GingerbreadRoadPiece) {
                    GingerbreadRoadPiece otherRoad = (GingerbreadRoadPiece)pendingChild;
                    if (newPiece instanceof GingerbreadRoadPiece) {
                        GingerbreadRoadPiece ourRoad = (GingerbreadRoadPiece)newPiece;
                        if (ourRoad.direction == otherRoad.direction) {
                            box = otherRoad.inflateRoadBox(2);
                        }
                    }
                }
                if (!box.m_71049_(newPiece.m_73547_())) continue;
                return true;
            }
        }
        return false;
    }

    private Direction selectAnyOther(RandomSource randomSource, boolean limitToAxis) {
        Direction direction1 = this.direction;
        for (int tries = 0; (limitToAxis ? direction1.m_122434_() == this.direction.m_122434_() : direction1 == this.direction) && tries < 256; ++tries) {
            direction1 = (Direction)Util.m_214670_((Object[])ACMath.HORIZONTAL_DIRECTIONS, (RandomSource)randomSource);
        }
        return direction1;
    }

    private static Rotation getRotationFromDirectionDefaultNorth(Direction direction) {
        switch (direction) {
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
        }
        return Rotation.NONE;
    }

    public BlockPos getRoadEndPos() {
        return this.origin.m_5484_(this.direction, this.length);
    }
}

