/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.CaramelCubeEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class MeltedCaramelEntity
extends Entity {
    private int despawnsIn = 40;
    private int prevDespawnsIn;
    private float yRenderOffset = this.f_19796_.m_188501_() * 0.05f;

    public MeltedCaramelEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public MeltedCaramelEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.MELTED_CARAMEL.get(), level);
    }

    protected void m_8097_() {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevDespawnsIn = this.despawnsIn;
        if (this.despawnsIn > 0) {
            --this.despawnsIn;
        } else if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
        BlockPos below = this.m_20183_().m_7495_();
        if (!this.m_9236_().f_46443_ && !this.m_9236_().m_8055_(below).m_60659_((BlockGetter)this.m_9236_(), below, Direction.UP, SupportType.CENTER)) {
            this.m_146870_();
        }
        this.slowEntities();
        Vec3 vec3 = this.m_20184_();
        this.m_6478_(MoverType.SELF, vec3);
        this.m_20256_(vec3.m_82542_((double)0.2f, (double)0.2f, (double)0.2f));
    }

    public void setDespawnsIn(int i) {
        this.despawnsIn = i;
    }

    public float getDespawnTime(float partialTicks) {
        return (float)this.prevDespawnsIn + (float)(this.despawnsIn - this.prevDespawnsIn) * partialTicks;
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("DespawnsIn")) {
            this.despawnsIn = compoundTag.m_128451_("DespawnsIn");
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128405_("DespawnsIn", this.despawnsIn);
    }

    private void slowEntities() {
        AABB bashBox = this.m_20191_();
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, bashBox)) {
            if (this.m_7307_((Entity)entity) || entity instanceof CaramelCubeEntity) continue;
            entity.m_7601_(Blocks.f_50493_.m_49966_(), new Vec3(0.25, (double)0.05f, 0.25));
        }
    }

    public float getYRenderOffset() {
        return this.yRenderOffset;
    }
}

