/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.GingerbreadManEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class GingerbreadManStealGoal
extends Goal {
    private final GingerbreadManEntity gingerbreadMan;
    private Entity target;
    private boolean hasStolen;
    private int executionCooldown = 0;
    private int recheckInventoryCooldown = 0;

    public GingerbreadManStealGoal(GingerbreadManEntity gingerbreadMan) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.gingerbreadMan = gingerbreadMan;
    }

    public boolean m_8036_() {
        if (this.gingerbreadMan.isOvenSpawned()) {
            return false;
        }
        if (this.executionCooldown > 0) {
            --this.executionCooldown;
            return false;
        }
        if (this.gingerbreadMan.m_21120_(InteractionHand.OFF_HAND).m_41619_() && this.gingerbreadMan.m_217043_().m_188503_(60) == 0) {
            this.executionCooldown = 120 + this.gingerbreadMan.m_217043_().m_188503_(120);
            Entity newTarget = this.findStealTarget();
            if (newTarget != null && newTarget.m_6084_() && GingerbreadManStealGoal.canStealFromEntityType(newTarget)) {
                this.target = newTarget;
                return true;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.hasStolen && this.target != null && this.target.m_6084_() && GingerbreadManStealGoal.canStealFromEntityType(this.target);
    }

    public void m_8056_() {
        this.hasStolen = false;
    }

    public void m_8037_() {
        if (this.recheckInventoryCooldown < 0) {
            this.recheckInventoryCooldown = 15;
            if (!GingerbreadManStealGoal.hasStealableInventory(this.target)) {
                this.target = null;
                return;
            }
        }
        if (this.target != null) {
            this.gingerbreadMan.m_7618_(EntityAnchorArgument.Anchor.EYES, this.target.m_146892_());
            double dist = this.gingerbreadMan.m_20270_(this.target);
            if (dist < (double)this.target.m_20205_() + 1.0 && this.gingerbreadMan.m_142582_(this.target)) {
                if (this.gingerbreadMan.getAnimation() == IAnimatedEntity.NO_ANIMATION || this.gingerbreadMan.getAnimation() == null) {
                    this.gingerbreadMan.setAnimation(this.gingerbreadMan.getAnimationForHand(false));
                }
                if (this.gingerbreadMan.getAnimation() == this.gingerbreadMan.getAnimationForHand(false) && this.gingerbreadMan.getAnimationTick() == 8) {
                    ItemStack stolenItem = this.stealOneFrom(this.target);
                    this.hasStolen = true;
                    this.gingerbreadMan.m_21008_(InteractionHand.OFF_HAND, stolenItem);
                    this.gingerbreadMan.setCarryingItem(true);
                    this.gingerbreadMan.fleeFromFor(this.target, 120 + this.gingerbreadMan.m_217043_().m_188503_(60));
                }
            } else {
                this.gingerbreadMan.m_21573_().m_5624_(this.target, 1.0);
            }
        }
    }

    @Nullable
    public Entity findStealTarget() {
        List list = this.gingerbreadMan.m_9236_().m_6249_((Entity)this.gingerbreadMan, this.gingerbreadMan.m_20191_().m_82400_(20.0), GingerbreadManStealGoal::hasStealableInventory);
        if (list.isEmpty()) {
            Player nearest = this.gingerbreadMan.m_9236_().m_45930_((Entity)this.gingerbreadMan, 20.0);
            if (nearest != null && GingerbreadManStealGoal.hasStealableInventory((Entity)nearest)) {
                return nearest;
            }
            return null;
        }
        return (Entity)Util.m_214621_((List)list, (RandomSource)this.gingerbreadMan.m_217043_());
    }

    public static boolean hasStealableInventory(Entity entity) {
        if (!GingerbreadManStealGoal.canStealFromEntityType(entity)) {
            return false;
        }
        LazyOptional lazyOptional = entity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
        if (lazyOptional.isPresent()) {
            IItemHandler handler = (IItemHandler)lazyOptional.orElse(null);
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!handler.getStackInSlot(i).m_204117_(ACTagRegistry.GINGERBREAD_MAN_STEALS)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean canStealFromEntityType(Entity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return false;
        }
        return !(entity instanceof GingerbreadManEntity);
    }

    public ItemStack stealOneFrom(Entity entity) {
        LazyOptional lazyOptional = entity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
        if (lazyOptional.isPresent()) {
            IItemHandler handler = (IItemHandler)lazyOptional.orElse(null);
            ArrayList<Integer> validSlots = new ArrayList<Integer>();
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!handler.getStackInSlot(i).m_204117_(ACTagRegistry.GINGERBREAD_MAN_STEALS)) continue;
                validSlots.add(i);
            }
            if (!validSlots.isEmpty()) {
                int slotId = (Integer)Util.m_214621_(validSlots, (RandomSource)this.gingerbreadMan.m_217043_());
                ItemStack stack = handler.getStackInSlot(slotId);
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(1);
                if (stack.m_204117_(ACTagRegistry.GINGERBREAD_MAN_STEALS)) {
                    stack.m_41774_(1);
                }
                return copy;
            }
        }
        return ItemStack.f_41583_;
    }
}

