/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.particle.RainbowParticle;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerRainbowParticle
extends RainbowParticle {
    private final int entityId;
    private int bakeRainbowIndex = 0;
    private boolean stopFlag = false;

    public PlayerRainbowParticle(ClientLevel world, double x, double y, double z, int entityId) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.entityId = entityId;
        this.target = this.calculatePlayerPos(1.0f);
        this.totalDistance = this.origin.m_82554_(this.target);
        this.rainbowVecCount = 30;
        this.fillSpeed = 30;
        this.fadeSpeed = 5;
        this.f_107225_ = this.rainbowVecCount;
        this.bakedRainbowVecs = new Vec3[this.rainbowVecCount];
        for (int i = 0; i < this.rainbowVecCount; ++i) {
            this.bakedRainbowVecs[i] = Vec3.f_82478_;
        }
    }

    public Vec3 calculatePlayerPos(float partialTicks) {
        Entity entity = this.f_107208_.m_6815_(this.entityId);
        if (this.entityId != -1 && entity != null) {
            if (entity.m_20096_() && this.f_107224_ > 1) {
                this.stopFlag = true;
            }
            return entity.m_20318_(partialTicks).m_82520_(0.0, 0.1, 0.0);
        }
        return this.getPos();
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        this.f_107230_ = Math.min(this.f_107230_, 0.75f);
        float ageClamp = Mth.m_14036_((float)((float)this.f_107224_ / ((float)this.f_107225_ - (float)this.fillSpeed)), (float)0.0f, (float)1.0f);
        this.alphaProgression = ageClamp * (float)Math.max(0, this.bakeRainbowIndex - 1);
        if (this.bakeRainbowIndex < this.rainbowVecCount && !this.stopFlag) {
            this.target = this.calculatePlayerPos(1.0f);
            this.totalDistance = this.origin.m_82554_(this.target);
            double y = this.target.f_82480_ - this.origin.f_82480_;
            double xz = this.target.m_82546_(this.origin).m_165924_();
            this.bakedRainbowVecs[this.bakeRainbowIndex] = new Vec3(xz, y, 0.0);
            ++this.bakeRainbowIndex;
        }
    }

    @Override
    protected float processAngle(float angle, float partialTick, PoseStack posestack) {
        if (!this.stopFlag) {
            Vec3 vec3 = this.calculatePlayerPos(partialTick);
            Vec3 vecForAngle = vec3.m_82546_(this.origin);
            this.angle = (float)Math.atan2(vecForAngle.f_82479_, vecForAngle.f_82481_);
        }
        return (float)this.angle;
    }

    @Override
    public void scaleRainbow(float partialTick, PoseStack posestack) {
    }

    @Override
    protected float getRainbowWidth() {
        return 0.3f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new PlayerRainbowParticle(worldIn, x, y, z, (int)xSpeed);
        }
    }
}

