/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.SauropodBaseEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.LuxtructosaurusLegSolver;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public abstract class SauropodBaseModel<T extends SauropodBaseEntity>
extends AdvancedEntityModel<T> {
    protected final AdvancedModelBox root;
    protected final AdvancedModelBox body;
    protected final AdvancedModelBox hips;
    protected final AdvancedModelBox tail;
    protected final AdvancedModelBox tail2;
    protected final AdvancedModelBox tail3;
    protected final AdvancedModelBox left_Leg;
    protected final AdvancedModelBox left_Foot;
    protected final AdvancedModelBox right_Leg;
    protected final AdvancedModelBox right_Foot;
    protected final AdvancedModelBox chest;
    protected final AdvancedModelBox right_Arm;
    protected final AdvancedModelBox right_Hand;
    protected final AdvancedModelBox left_Arm;
    protected final AdvancedModelBox left_Hand;
    protected final AdvancedModelBox neck;
    protected final AdvancedModelBox neck2;
    protected final AdvancedModelBox head;
    protected final AdvancedModelBox jaw;
    protected final AdvancedModelBox dewlap;
    protected final ModelAnimator animator;
    public boolean straighten = false;

    public SauropodBaseModel() {
        this.texWidth = 512;
        this.texHeight = 512;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this);
        this.root.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.body);
        this.hips = new AdvancedModelBox((AdvancedEntityModel)this);
        this.hips.setRotationPoint(0.0f, -65.0f, 0.5f);
        this.body.addChild((BasicModelPart)this.hips);
        this.hips.setTextureOffset(230, 149).addBox(-19.0f, -24.0f, -3.5f, 38.0f, 48.0f, 41.0f, 0.0f, false);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail.setRotationPoint(0.0f, 6.5f, 33.0f);
        this.hips.addChild((BasicModelPart)this.tail);
        this.tail.setTextureOffset(0, 246).addBox(-12.0f, -14.5f, 2.5f, 24.0f, 29.0f, 49.0f, 0.0f, false);
        this.tail2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail2.setRotationPoint(0.0f, 1.5f, 49.0f);
        this.tail.addChild((BasicModelPart)this.tail2);
        this.tail2.setTextureOffset(245, 238).addBox(-8.0f, -10.0f, -6.5f, 16.0f, 20.0f, 57.0f, 0.0f, false);
        this.tail3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail3.setRotationPoint(0.0f, 0.5f, 48.5f);
        this.tail2.addChild((BasicModelPart)this.tail3);
        this.tail3.setTextureOffset(138, 174).addBox(-5.0f, -6.5f, -14.0f, 10.0f, 13.0f, 72.0f, 0.0f, false);
        this.left_Leg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Leg.setRotationPoint(18.0f, 12.0f, 22.5f);
        this.hips.addChild((BasicModelPart)this.left_Leg);
        this.left_Leg.setTextureOffset(139, 0).addBox(-9.5f, -7.0f, -15.0f, 19.0f, 35.0f, 27.0f, 0.0f, false);
        this.left_Foot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Foot.setRotationPoint(0.0f, 23.0f, 5.0f);
        this.left_Leg.addChild((BasicModelPart)this.left_Foot);
        this.left_Foot.setTextureOffset(270, 315).addBox(-6.5f, -5.0f, -5.0f, 13.0f, 35.0f, 17.0f, 0.0f, false);
        this.left_Foot.setTextureOffset(153, 149).addBox(-6.5f, 26.0f, -9.0f, 13.0f, 4.0f, 4.0f, 0.25f, false);
        this.left_Foot.setTextureOffset(153, 157).addBox(-6.5f, 26.0f, -9.0f, 13.0f, 4.0f, 4.0f, 0.0f, false);
        this.right_Leg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Leg.setRotationPoint(-18.0f, 12.0f, 22.5f);
        this.hips.addChild((BasicModelPart)this.right_Leg);
        this.right_Leg.setTextureOffset(139, 0).addBox(-9.5f, -7.0f, -15.0f, 19.0f, 35.0f, 27.0f, 0.0f, true);
        this.right_Foot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Foot.setRotationPoint(0.0f, 23.0f, 5.0f);
        this.right_Leg.addChild((BasicModelPart)this.right_Foot);
        this.right_Foot.setTextureOffset(270, 315).addBox(-6.5f, -5.0f, -5.0f, 13.0f, 35.0f, 17.0f, 0.0f, true);
        this.right_Foot.setTextureOffset(153, 149).addBox(-6.5f, 26.0f, -9.0f, 13.0f, 4.0f, 4.0f, 0.25f, true);
        this.right_Foot.setTextureOffset(153, 157).addBox(-6.5f, 26.0f, -9.0f, 13.0f, 4.0f, 4.0f, 0.0f, true);
        this.chest = new AdvancedModelBox((AdvancedEntityModel)this);
        this.chest.setRotationPoint(0.0f, -9.0f, 0.0f);
        this.hips.addChild((BasicModelPart)this.chest);
        this.chest.setTextureOffset(0, 123).addBox(-24.0f, -33.0f, -56.5f, 48.0f, 66.0f, 57.0f, 0.01f, false);
        this.right_Arm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Arm.setRotationPoint(-23.0f, -3.0f, -37.5f);
        this.chest.addChild((BasicModelPart)this.right_Arm);
        this.right_Arm.setTextureOffset(0, 0).addBox(-13.0f, -10.0f, -11.0f, 14.0f, 44.0f, 21.0f, 0.0f, true);
        this.right_Hand = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Hand.setRotationPoint(-3.0f, 32.0f, -9.0f);
        this.right_Arm.addChild((BasicModelPart)this.right_Hand);
        this.right_Hand.setTextureOffset(264, 0).addBox(-15.0f, -2.0f, -2.75f, 24.0f, 47.0f, 29.0f, 0.0f, true);
        this.right_Hand.setTextureOffset(20, 238).addBox(-8.0f, -2.0f, -12.75f, 0.0f, 47.0f, 10.0f, 0.0f, true);
        this.right_Hand.setTextureOffset(20, 238).addBox(2.0f, -2.0f, -12.75f, 0.0f, 47.0f, 10.0f, 0.0f, true);
        this.right_Hand.setTextureOffset(49, 0).addBox(9.0f, 37.0f, 13.25f, 8.0f, 8.0f, 8.0f, 0.0f, true);
        this.left_Arm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Arm.setRotationPoint(23.0f, -3.0f, -37.5f);
        this.chest.addChild((BasicModelPart)this.left_Arm);
        this.left_Arm.setTextureOffset(0, 0).addBox(-1.0f, -10.0f, -11.0f, 14.0f, 44.0f, 21.0f, 0.0f, false);
        this.left_Hand = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Hand.setRotationPoint(3.0f, 32.0f, -9.0f);
        this.left_Arm.addChild((BasicModelPart)this.left_Hand);
        this.left_Hand.setTextureOffset(264, 0).addBox(-9.0f, -2.0f, -2.75f, 24.0f, 47.0f, 29.0f, 0.0f, false);
        this.left_Hand.setTextureOffset(20, 238).addBox(8.0f, -2.0f, -12.75f, 0.0f, 47.0f, 10.0f, 0.0f, false);
        this.left_Hand.setTextureOffset(20, 238).addBox(-2.0f, -2.0f, -12.75f, 0.0f, 47.0f, 10.0f, 0.0f, false);
        this.left_Hand.setTextureOffset(49, 0).addBox(-17.0f, 37.0f, 13.25f, 8.0f, 8.0f, 8.0f, 0.0f, false);
        this.neck = new AdvancedModelBox((AdvancedEntityModel)this);
        this.neck.setRotationPoint(0.5f, -31.0f, -33.0f);
        this.chest.addChild((BasicModelPart)this.neck);
        this.neck.setTextureOffset(0, 0).addBox(-13.5f, -14.0f, -76.5f, 26.0f, 36.0f, 87.0f, 0.0f, false);
        this.neck2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.neck2.setRotationPoint(-0.5f, -6.0f, -75.5f);
        this.neck.addChild((BasicModelPart)this.neck2);
        this.neck2.setTextureOffset(153, 44).addBox(-8.0f, -2.0f, -80.0f, 16.0f, 26.0f, 79.0f, 0.0f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.8f, 8.0f, -75.0f);
        this.neck2.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(198, 315).addBox(-9.8f, -4.0f, -15.0f, 18.0f, 22.0f, 18.0f, 0.0f, false);
        this.head.setTextureOffset(0, 324).addBox(-5.8f, -13.0f, -23.0f, 10.0f, 20.0f, 20.0f, 0.0f, false);
        this.head.setTextureOffset(264, 76).addBox(-11.8f, 6.0f, -28.0f, 22.0f, 7.0f, 21.0f, 0.0f, false);
        this.head.setTextureOffset(0, 65).addBox(-11.3f, 11.0f, -27.5f, 21.0f, 6.0f, 13.0f, 0.0f, false);
        this.jaw = new AdvancedModelBox((AdvancedEntityModel)this);
        this.jaw.setRotationPoint(-0.8f, 10.5f, -8.5f);
        this.head.addChild((BasicModelPart)this.jaw);
        this.jaw.setTextureOffset(331, 83).addBox(-11.0f, -1.5f, -19.5f, 22.0f, 9.0f, 21.0f, -0.01f, false);
        this.jaw.setTextureOffset(360, 0).addBox(-11.0f, 3.0f, -19.5f, 22.0f, 2.0f, 17.0f, -0.001f, false);
        this.dewlap = new AdvancedModelBox((AdvancedEntityModel)this);
        this.dewlap.setRotationPoint(0.0f, 24.0f, -57.5f);
        this.neck2.addChild((BasicModelPart)this.dewlap);
        this.dewlap.setTextureOffset(97, 194).addBox(0.0f, -4.0f, -32.5f, 0.0f, 26.0f, 65.0f, 0.0f, false);
        this.left_Foot.setShouldScaleChildren(true);
        this.right_Foot.setShouldScaleChildren(true);
        this.left_Hand.setShouldScaleChildren(true);
        this.right_Hand.setShouldScaleChildren(true);
        this.jaw.setScale(0.99f, 0.99f, 0.99f);
        this.animator = ModelAnimator.create();
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(SauropodBaseEntity.ANIMATION_SPEAK);
        this.animator.startKeyframe(3);
        this.animator.rotate(this.head, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(7);
        this.animator.rotate(this.head, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(SauropodBaseEntity.ANIMATION_ROAR);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, (float)Math.toRadians(-50.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(40);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(SauropodBaseEntity.ANIMATION_EPIC_DEATH);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, (float)Math.toRadians(-50.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck2, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(100);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(SauropodBaseEntity.ANIMATION_SUMMON);
        this.animator.startKeyframe(0);
        this.animator.move(this.body, 0.0f, 200.0f, 0.0f);
        this.animator.move(this.neck2, 0.0f, -5.0f, -5.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(-50.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck2, (float)Math.toRadians(120.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(50.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(120);
        this.animator.setAnimation(SauropodBaseEntity.ANIMATION_STOMP);
        this.animator.startKeyframe(20);
        this.animator.move(this.body, 0.0f, -25.0f, -23.0f);
        this.animator.move(this.chest, 0.0f, 2.0f, 4.0f);
        this.animator.move(this.head, 0.0f, 5.0f, -5.0f);
        this.animator.move(this.left_Leg, 0.0f, 0.0f, -5.0f);
        this.animator.move(this.right_Leg, 0.0f, 0.0f, -5.0f);
        this.animator.move(this.left_Arm, 0.0f, 10.0f, -5.0f);
        this.animator.move(this.right_Arm, 0.0f, 10.0f, -5.0f);
        this.animator.rotate(this.body, (float)Math.toRadians(-40.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(50.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck2, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.tail, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.tail3, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(30.0), 0.0f, 0.0f);
        this.animator.rotate(this.chest, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Leg, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Leg, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-20.0), (float)Math.toRadians(-20.0), (float)Math.toRadians(-20.0));
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-20.0), (float)Math.toRadians(20.0), (float)Math.toRadians(20.0));
        this.animator.rotate(this.left_Hand, (float)Math.toRadians(50.0), 0.0f, 0.0f);
        this.animator.rotate(this.right_Hand, (float)Math.toRadians(50.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.right_Leg, 0.0f, -10.0f, 0.0f);
        this.animator.move(this.left_Leg, 0.0f, -10.0f, 0.0f);
        this.animator.move(this.right_Arm, -2.0f, -10.0f, -7.0f);
        this.animator.move(this.left_Arm, 2.0f, -10.0f, -7.0f);
        this.animator.rotate(this.left_Arm, 0.0f, 0.0f, (float)Math.toRadians(-20.0));
        this.animator.rotate(this.right_Arm, 0.0f, 0.0f, (float)Math.toRadians(20.0));
        this.animator.rotate(this.left_Hand, 0.0f, 0.0f, (float)Math.toRadians(20.0));
        this.animator.rotate(this.right_Hand, 0.0f, 0.0f, (float)Math.toRadians(-20.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(10);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(SauropodBaseEntity.ANIMATION_SPEW_FLAMES);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.head, (float)Math.toRadians(-30.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(60.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(60);
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(SauropodBaseEntity.ANIMATION_JUMP);
        this.animator.startKeyframe(10);
        this.animator.move(this.body, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.right_Leg, 0.0f, -9.0f, 0.0f);
        this.animator.move(this.left_Leg, 0.0f, -9.0f, 0.0f);
        this.animator.move(this.right_Arm, -2.0f, -6.0f, -4.0f);
        this.animator.move(this.left_Arm, 2.0f, -6.0f, -4.0f);
        this.animator.rotate(this.left_Arm, 0.0f, 0.0f, (float)Math.toRadians(-20.0));
        this.animator.rotate(this.right_Arm, 0.0f, 0.0f, (float)Math.toRadians(20.0));
        this.animator.rotate(this.left_Hand, 0.0f, 0.0f, (float)Math.toRadians(20.0));
        this.animator.rotate(this.right_Hand, 0.0f, 0.0f, (float)Math.toRadians(-20.0));
        this.animator.rotate(this.left_Leg, 0.0f, 0.0f, (float)Math.toRadians(-10.0));
        this.animator.rotate(this.right_Leg, 0.0f, 0.0f, (float)Math.toRadians(10.0));
        this.animator.rotate(this.left_Foot, 0.0f, 0.0f, (float)Math.toRadians(10.0));
        this.animator.rotate(this.right_Foot, 0.0f, 0.0f, (float)Math.toRadians(-10.0));
        this.animator.rotate(this.neck, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.tail, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck2, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(10);
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, -10.0f, 0.0f);
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-30.0), 0.0f, (float)Math.toRadians(-10.0));
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-30.0), 0.0f, (float)Math.toRadians(10.0));
        this.animator.rotate(this.right_Leg, (float)Math.toRadians(30.0), 0.0f, (float)Math.toRadians(-10.0));
        this.animator.rotate(this.left_Leg, (float)Math.toRadians(30.0), 0.0f, (float)Math.toRadians(10.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, 10.0f, 0.0f);
        this.animator.move(this.right_Leg, 0.0f, -9.0f, 0.0f);
        this.animator.move(this.left_Leg, 0.0f, -9.0f, 0.0f);
        this.animator.move(this.right_Arm, -2.0f, -6.0f, -4.0f);
        this.animator.move(this.left_Arm, 2.0f, -6.0f, -4.0f);
        this.animator.rotate(this.left_Arm, 0.0f, 0.0f, (float)Math.toRadians(-20.0));
        this.animator.rotate(this.right_Arm, 0.0f, 0.0f, (float)Math.toRadians(20.0));
        this.animator.rotate(this.left_Hand, 0.0f, 0.0f, (float)Math.toRadians(20.0));
        this.animator.rotate(this.right_Hand, 0.0f, 0.0f, (float)Math.toRadians(-20.0));
        this.animator.rotate(this.left_Leg, 0.0f, 0.0f, (float)Math.toRadians(-10.0));
        this.animator.rotate(this.right_Leg, 0.0f, 0.0f, (float)Math.toRadians(10.0));
        this.animator.rotate(this.left_Foot, 0.0f, 0.0f, (float)Math.toRadians(10.0));
        this.animator.rotate(this.right_Foot, 0.0f, 0.0f, (float)Math.toRadians(-10.0));
        this.animator.rotate(this.neck, (float)Math.toRadians(-15.0), 0.0f, 0.0f);
        this.animator.rotate(this.tail, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck2, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(SauropodBaseEntity.ANIMATION_LEFT_KICK);
        this.animator.startKeyframe(4);
        this.animator.move(this.left_Arm, 3.0f, 3.0f, -3.0f);
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-30.0), (float)Math.toRadians(-40.0), 0.0f);
        this.animator.rotate(this.left_Hand, (float)Math.toRadians(40.0), 0.0f, (float)Math.toRadians(10.0));
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.tail, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.neck, 0.0f, (float)Math.toRadians(-5.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(6);
        this.animator.move(this.left_Arm, 0.0f, -5.0f, -3.0f);
        this.animator.rotate(this.left_Arm, (float)Math.toRadians(-80.0), (float)Math.toRadians(0.0), 0.0f);
        this.animator.rotate(this.left_Hand, (float)Math.toRadians(10.0), 0.0f, (float)Math.toRadians(10.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(10);
        this.animator.setAnimation(SauropodBaseEntity.ANIMATION_RIGHT_KICK);
        this.animator.startKeyframe(5);
        this.animator.move(this.right_Arm, -3.0f, 3.0f, -3.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-30.0), (float)Math.toRadians(40.0), 0.0f);
        this.animator.rotate(this.right_Hand, (float)Math.toRadians(40.0), 0.0f, (float)Math.toRadians(-10.0));
        this.animator.rotate(this.body, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.tail, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.neck, 0.0f, (float)Math.toRadians(5.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(4);
        this.animator.move(this.right_Arm, 0.0f, -5.0f, -3.0f);
        this.animator.rotate(this.right_Arm, (float)Math.toRadians(-80.0), (float)Math.toRadians(0.0), 0.0f);
        this.animator.rotate(this.right_Hand, (float)Math.toRadians(10.0), 0.0f, (float)Math.toRadians(-10.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(6);
        this.animator.setAnimation(SauropodBaseEntity.ANIMATION_EAT_LEAVES);
        this.animator.startKeyframe(15);
        this.animator.rotate(this.neck, (float)Math.toRadians(-20.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck2, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(40.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(10);
        this.animator.rotate(this.head, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.move(this.jaw, 0.0f, 0.0f, 1.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(10);
    }

    public void setupAnim(SauropodBaseEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float walkAmount;
        this.resetToDefaultPose();
        this.animate(entity);
        if (entity.getAnimation() != IAnimatedEntity.NO_ANIMATION) {
            this.setupAnimForAnimation(entity, entity.getAnimation(), limbSwing, limbSwingAmount, ageInTicks);
        }
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float idleSpeed = 0.05f;
        float walkSpeed = 0.05f;
        float walkDegree = 3.0f;
        float walk = entity.getWalkAnimPosition(partialTicks);
        float armsWalkAmount = walkAmount = Math.min(entity.getWalkAnimSpeed(partialTicks), 1.0f);
        float raiseArmsAmount = entity.getRaiseArmsAmount(partialTicks);
        float legBack = entity.getLegBackAmount(partialTicks);
        float danceAmount = entity.getDanceProgress(partialTicks);
        float buryEggsAmount = entity.getBuryEggsProgress(partialTicks);
        this.positionNeckAndTail(entity, netHeadYaw, headPitch, partialTicks);
        this.articulateLegs(entity.legSolver, raiseArmsAmount, partialTicks);
        if (buryEggsAmount > 0.0f) {
            limbSwing = ageInTicks;
            limbSwingAmount = buryEggsAmount * 0.5f;
        }
        this.walk(this.neck, idleSpeed, 0.03f, true, 0.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.neck2, idleSpeed, 0.02f, true, -1.0f, -0.03f, ageInTicks, 1.0f);
        this.walk(this.head, idleSpeed, 0.01f, true, -2.0f, 0.02f, ageInTicks, 1.0f);
        this.flap(this.dewlap, 0.14f, 0.1f, true, 0.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.dewlap, 0.14f, 0.05f, true, 1.0f, -0.1f, ageInTicks, 1.0f);
        this.walk(this.tail, idleSpeed, 0.03f, true, 3.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.tail2, idleSpeed, 0.03f, true, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.walk(this.tail3, idleSpeed, 0.03f, true, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.tail, idleSpeed, 0.03f, true, 4.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.tail2, idleSpeed, 0.03f, true, 3.0f, 0.0f, ageInTicks, 1.0f);
        this.swing(this.tail3, idleSpeed, 0.03f, true, 2.0f, 0.0f, ageInTicks, 1.0f);
        this.dewlap.rotationPointY += ACMath.walkValue(ageInTicks, 1.0f, 0.1f, -1.5f, 1.0f, false);
        float legAnimSeperation = 0.5f;
        this.animateLegWalking(this.right_Arm, this.right_Hand, legAnimSeperation * 3.0f, walkSpeed, walkDegree, walk, armsWalkAmount, true, false, legBack);
        this.animateLegWalking(this.right_Leg, this.right_Foot, legAnimSeperation * 2.0f, walkSpeed, walkDegree, walk, walkAmount, false, false, legBack);
        this.animateLegWalking(this.left_Arm, this.left_Hand, legAnimSeperation, walkSpeed, walkDegree, walk, armsWalkAmount, true, true, legBack);
        this.animateLegWalking(this.left_Leg, this.left_Foot, 0.0f, walkSpeed, walkDegree, walk, walkAmount, false, true, legBack);
        this.animateDancing(entity, danceAmount, ageInTicks);
    }

    private void setupAnimForAnimation(SauropodBaseEntity entity, Animation animation, float limbSwing, float limbSwingAmount, float ageInTicks) {
        float animationIntensity;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        if (entity.getAnimation() == SauropodBaseEntity.ANIMATION_ROAR) {
            animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 1.0f, animation, partialTick, 5, 50);
            this.head.swing(1.0f, 0.1f, false, -1.0f, 0.0f, ageInTicks, animationIntensity);
            this.jaw.walk(2.0f, 0.1f, false, 1.0f, 0.0f, ageInTicks, animationIntensity);
            this.dewlap.flap(2.0f, 0.1f, false, 2.0f, 0.0f, ageInTicks, animationIntensity);
            this.neck.flap(0.5f, 0.1f, false, -3.0f, 0.0f, ageInTicks, animationIntensity);
            this.neck2.flap(0.5f, 0.1f, false, -2.0f, 0.0f, ageInTicks, animationIntensity);
        }
        if (entity.getAnimation() == SauropodBaseEntity.ANIMATION_EPIC_DEATH) {
            animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 1.0f, animation, partialTick, 5, 110);
            this.head.swing(0.4f, 0.1f, false, -1.0f, 0.0f, ageInTicks, animationIntensity);
            this.jaw.walk(1.0f, 0.1f, false, 1.0f, 0.0f, ageInTicks, animationIntensity);
            this.dewlap.flap(1.0f, 0.1f, false, 2.0f, 0.0f, ageInTicks, animationIntensity);
            this.neck.swing(0.1f, 0.2f, false, -1.0f, 0.0f, ageInTicks, animationIntensity);
            this.neck.flap(0.25f, 0.1f, false, -3.0f, 0.0f, ageInTicks, animationIntensity);
            this.neck2.swing(0.1f, 0.2f, false, -1.0f, 0.0f, ageInTicks, animationIntensity);
            this.neck2.flap(0.25f, 0.1f, false, -2.0f, 0.0f, ageInTicks, animationIntensity);
        }
        if (entity.getAnimation() == SauropodBaseEntity.ANIMATION_SPEW_FLAMES) {
            animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 1.0f, animation, partialTick, 5, 70);
            this.head.walk(2.0f, 0.05f, false, 1.0f, 0.0f, ageInTicks, animationIntensity);
            this.head.swing(2.0f, 0.05f, false, 1.0f, 0.0f, ageInTicks, animationIntensity);
            this.dewlap.flap(2.0f, 0.1f, false, 2.0f, 0.0f, ageInTicks, animationIntensity);
            this.neck.flap(1.0f, 0.05f, false, -3.0f, 0.0f, ageInTicks, animationIntensity);
            this.neck2.flap(1.0f, 0.05f, false, -2.0f, 0.0f, ageInTicks, animationIntensity);
        }
        if (entity.getAnimation() == SauropodBaseEntity.ANIMATION_EAT_LEAVES) {
            animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 3.0f, animation, partialTick, 35);
            float jawDown = Math.min(0.0f, ACMath.walkValue(ageInTicks, animationIntensity, 0.4f, 2.0f, 1.0f, true));
            this.jaw.walk(0.5f, 0.1f, false, 1.0f, 0.1f, ageInTicks, animationIntensity);
            this.head.rotateAngleX += ACMath.walkValue(ageInTicks, animationIntensity, 0.4f, 2.0f, 0.05f, false);
            this.jaw.rotationPointZ += animationIntensity * 2.0f + ACMath.walkValue(ageInTicks, animationIntensity, 0.4f, 0.5f, 1.0f, false);
        }
    }

    private void positionNeckAndTail(SauropodBaseEntity entity, float netHeadYaw, float headPitch, float partialTicks) {
        if (!this.straighten && !entity.isFakeEntity()) {
            float neckPart1Pitch = (float)Math.toRadians(entity.neckPart1.calculateAnimationAngle(partialTicks, true)) * 0.5f;
            float neckPart2Pitch = (float)Math.toRadians(entity.neckPart2.calculateAnimationAngle(partialTicks, true)) * 0.5f;
            float neckPart3Pitch = (float)Math.toRadians(entity.neckPart3.calculateAnimationAngle(partialTicks, true)) * 0.5f;
            float tailPart1Pitch = (float)Math.toRadians(entity.tailPart1.calculateAnimationAngle(partialTicks, true)) + 0.141f;
            float tailPart2Pitch = (float)Math.toRadians(entity.tailPart2.calculateAnimationAngle(partialTicks, true)) + 0.076f;
            float tailPart3Pitch = (float)Math.toRadians(entity.tailPart3.calculateAnimationAngle(partialTicks, true)) * 0.5f;
            float neckPart2Yaw = entity.neckPart2.calculateAnimationAngle(partialTicks, false);
            float pitchAmount = entity.getAnimation() == SauropodBaseEntity.ANIMATION_SPEW_FLAMES ? 0.0f : Mth.m_14036_((float)headPitch, (float)-30.0f, (float)30.0f) / 57.295776f;
            float headApproach = Mth.m_14148_((float)neckPart2Yaw, (float)entity.headPart.calculateAnimationAngle(partialTicks, false), (float)45.0f) - neckPart2Yaw;
            this.neck.rotateAngleX -= neckPart1Pitch + neckPart2Pitch;
            this.neck.rotateAngleY = (float)((double)this.neck.rotateAngleY + (Math.toRadians(180.0f + entity.neckPart1.calculateAnimationAngle(partialTicks, false)) - (double)this.chest.rotateAngleY - (double)this.body.rotateAngleY - (double)this.root.rotateAngleY));
            this.neck2.rotateAngleX -= neckPart2Pitch;
            this.neck2.rotateAngleY = (float)((double)this.neck2.rotateAngleY + Math.toRadians(180.0f + neckPart2Yaw));
            this.head.rotateAngleX += pitchAmount + neckPart1Pitch + neckPart2Pitch + neckPart3Pitch - (float)Math.toRadians(entity.headPart.calculateAnimationAngle(partialTicks, true)) * 0.2f;
            this.head.rotateAngleY = (float)((double)this.head.rotateAngleY + Math.toRadians(headApproach));
            if (neckPart2Pitch > 0.0f) {
                this.neck2.rotationPointZ += Math.min(neckPart2Pitch * 50.0f, 50.0f);
            }
            this.tail.rotateAngleY = (float)((double)this.tail.rotateAngleY + Math.toRadians(entity.tailPart1.calculateAnimationAngle(partialTicks, false)));
            this.tail2.rotateAngleY = (float)((double)this.tail2.rotateAngleY + Math.toRadians(entity.tailPart2.calculateAnimationAngle(partialTicks, false)));
            this.tail3.rotateAngleY = (float)((double)this.tail3.rotateAngleY + Math.toRadians(entity.tailPart3.calculateAnimationAngle(partialTicks, false) - entity.tailPart2.calculateAnimationAngle(partialTicks, false)));
            this.tail.rotateAngleX += tailPart1Pitch;
            this.tail2.rotateAngleX += tailPart2Pitch;
            this.tail3.rotateAngleX += tailPart3Pitch;
        }
    }

    private void animateLegWalking(AdvancedModelBox leg, AdvancedModelBox foot, float offset, float speed, float degree, float limbSwing, float limbSwingAmount, boolean front, boolean left, float legBack) {
        float leg1 = Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, speed, (float)Math.PI * (offset + 0.3333f), 1.0f, true) + 0.75f) * 4.0f;
        float leg1Delayed = Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, speed, (float)Math.PI * offset, 1.0f, true) + 0.75f) * 4.0f;
        float leg1Prev = Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, speed, (float)Math.PI * (offset + 0.6666f), 1.0f, true) + 0.75f) * 4.0f;
        float leg1Squish = 1.0f - 0.15f * (float)Math.pow(Math.min(leg1Delayed - leg1, 0.0f), 3.0);
        float legInactivityAmount = 1.0f - Math.abs(leg1);
        this.walk(leg, speed, degree * 0.3f, false, (float)Math.PI * offset + 1.0f, 0.0f, limbSwing, leg1);
        this.walk(foot, speed, degree * 0.2f, false, (float)Math.PI * offset - 2.0f, -0.25f, limbSwing, leg1);
        if (front) {
            this.swing(leg, speed, degree * -0.2f, left, (float)Math.PI * offset + 1.0f, 0.0f, limbSwing, leg1Prev);
            leg.rotationPointZ += leg1Prev * 8.0f;
        }
        leg.rotationPointY += leg1 * 10.0f;
        leg.rotationPointZ += leg1Delayed * 16.0f;
        leg.rotationPointZ += legBack * legInactivityAmount * 16.0f;
        float raisedBody = leg1 * 8.0f;
        this.body.rotationPointY += raisedBody;
        this.left_Leg.rotationPointY -= raisedBody;
        this.right_Leg.rotationPointY -= raisedBody;
        this.left_Arm.rotationPointY -= raisedBody;
        this.right_Arm.rotationPointY -= raisedBody;
        this.tail.rotationPointY -= raisedBody * 0.5f;
        this.neck.rotationPointY -= raisedBody * 0.5f;
        float squish2 = 2.0f - leg1Squish;
        foot.setScale(leg1Squish * leg1Squish, squish2, leg1Squish);
        leg.rotationPointY -= (squish2 - 1.0f) * 30.0f;
    }

    private float articulateLegs(LuxtructosaurusLegSolver legs, float raiseArmsAmount, float partialTick) {
        float armsArticulateAmount = 1.0f - raiseArmsAmount;
        float heightBackLeft = legs.backLeft.getHeight(partialTick);
        float heightBackRight = legs.backRight.getHeight(partialTick);
        float heightFrontLeft = legs.frontLeft.getHeight(partialTick);
        float heightFrontRight = legs.frontRight.getHeight(partialTick);
        float max = Math.max(Math.max(heightBackLeft, heightBackRight), armsArticulateAmount * Math.max(heightFrontLeft, heightFrontRight)) * 0.75f;
        this.body.rotationPointY += max * 16.0f;
        this.right_Arm.rotationPointY += (heightFrontRight - max) * armsArticulateAmount * 16.0f;
        this.left_Arm.rotationPointY += (heightFrontLeft - max) * armsArticulateAmount * 16.0f;
        this.right_Leg.rotationPointY += (heightBackRight - max) * 16.0f;
        this.left_Leg.rotationPointY += (heightBackLeft - max) * 16.0f;
        return max * 16.0f;
    }

    private void animateDancing(SauropodBaseEntity entity, float danceAmount, float ageInTicks) {
        float ageSine = Mth.m_14036_((float)((float)Math.sin(ageInTicks * 0.08f) * 2.0f), (float)0.0f, (float)1.0f);
        float gangnam1 = danceAmount * ageSine;
        float gangnam2 = danceAmount * (1.0f - ageSine);
        float gangnamSpeed = 0.65f;
        this.progressPositionPrev(this.body, danceAmount, 0.0f, -37.0f, -23.0f, 1.0f);
        this.progressRotationPrev(this.body, danceAmount, (float)Math.toRadians(-50.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.left_Leg, danceAmount, (float)Math.toRadians(50.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.right_Leg, danceAmount, (float)Math.toRadians(50.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.tail, danceAmount, (float)Math.toRadians(50.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.neck, danceAmount, (float)Math.toRadians(30.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.neck2, danceAmount, (float)Math.toRadians(30.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.left_Arm, gangnam1, 2.0f, 0.0f, -5.0f, 1.0f);
        this.progressPositionPrev(this.right_Arm, gangnam1, -2.0f, 0.0f, -5.0f, 1.0f);
        this.progressRotationPrev(this.left_Arm, gangnam1, (float)Math.toRadians(-5.0), 0.0f, (float)Math.toRadians(10.0), 1.0f);
        this.progressRotationPrev(this.right_Arm, gangnam1, (float)Math.toRadians(-20.0), 0.0f, (float)Math.toRadians(-10.0), 1.0f);
        this.progressRotationPrev(this.left_Hand, gangnam1, (float)Math.toRadians(10.0), 0.0f, (float)Math.toRadians(30.0), 1.0f);
        this.progressRotationPrev(this.right_Hand, gangnam1, (float)Math.toRadians(-20.0), 0.0f, (float)Math.toRadians(-30.0), 1.0f);
        this.body.swing(gangnamSpeed, 0.05f, false, 0.0f, 0.0f, ageInTicks, danceAmount);
        this.tail.flap(gangnamSpeed, 0.1f, true, 1.0f, 0.0f, ageInTicks, danceAmount);
        this.tail2.swing(gangnamSpeed, 0.1f, true, 1.0f, 0.0f, ageInTicks, danceAmount);
        this.tail3.swing(gangnamSpeed, 0.1f, true, 1.0f, 0.0f, ageInTicks, danceAmount);
        this.left_Arm.walk(gangnamSpeed, 0.2f, false, 2.0f, -0.3f, ageInTicks, danceAmount);
        this.right_Arm.walk(gangnamSpeed, 0.2f, false, 2.0f, -0.3f, ageInTicks, gangnam1);
        this.left_Hand.walk(gangnamSpeed, 0.1f, false, 1.0f, -0.1f, ageInTicks, danceAmount);
        this.right_Hand.walk(gangnamSpeed, 0.1f, false, 1.0f, -0.1f, ageInTicks, gangnam1);
        this.left_Leg.walk(gangnamSpeed, 0.3f, false, 1.0f, -0.1f, ageInTicks, danceAmount);
        this.right_Leg.walk(gangnamSpeed, 0.3f, true, 1.0f, -0.1f, ageInTicks, danceAmount);
        this.body.bob(gangnamSpeed, 10.0f, false, ageInTicks, danceAmount);
        this.progressPositionPrev(this.left_Arm, gangnam2, 2.0f, 20.0f, -5.0f, 1.0f);
        this.progressPositionPrev(this.left_Hand, gangnam2, 0.0f, -4.0f, -4.0f, 1.0f);
        this.progressPositionPrev(this.right_Arm, gangnam2, 2.0f, 0.0f, -10.0f, 1.0f);
        this.progressPositionPrev(this.right_Hand, gangnam2, 3.0f, -3.0f, 3.0f, 1.0f);
        this.progressRotationPrev(this.left_Arm, gangnam2, (float)Math.toRadians(-10.0), 0.0f, (float)Math.toRadians(-30.0), 1.0f);
        this.progressRotationPrev(this.left_Hand, gangnam2, (float)Math.toRadians(-10.0), 0.0f, (float)Math.toRadians(90.0), 1.0f);
        this.progressRotationPrev(this.right_Arm, gangnam2, (float)Math.toRadians(-80.0), (float)Math.toRadians(40.0), (float)Math.toRadians(-20.0), 1.0f);
        this.progressRotationPrev(this.right_Hand, gangnam2, (float)Math.toRadians(-40.0), (float)Math.toRadians(-40.0), (float)Math.toRadians(20.0), 1.0f);
        this.right_Arm.flap(gangnamSpeed, 0.5f, false, 1.0f, 0.0f, ageInTicks, gangnam2);
        this.right_Arm.swing(gangnamSpeed, 0.5f, false, 0.0f, 0.0f, ageInTicks, gangnam2);
        this.right_Hand.flap(gangnamSpeed, 0.2f, false, 3.0f, -0.1f, ageInTicks, gangnam2);
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public Vec3 getMouthPosition(Vec3 offsetIn) {
        PoseStack translationStack = new PoseStack();
        translationStack.m_85836_();
        this.root.translateAndRotate(translationStack);
        this.body.translateAndRotate(translationStack);
        this.chest.translateAndRotate(translationStack);
        this.neck.translateAndRotate(translationStack);
        this.neck2.translateAndRotate(translationStack);
        this.head.translateAndRotate(translationStack);
        this.jaw.translateAndRotate(translationStack);
        Vector4f armOffsetVec = new Vector4f((float)offsetIn.f_82479_, (float)offsetIn.f_82480_, (float)offsetIn.f_82481_, 1.0f);
        armOffsetVec.mul((Matrix4fc)translationStack.m_85850_().m_252922_());
        Vec3 vec3 = new Vec3((double)(-armOffsetVec.x()), (double)(-armOffsetVec.y()), (double)armOffsetVec.z());
        translationStack.m_85849_();
        return vec3.m_82520_(0.0, 5.0, -1.0);
    }
}

