/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import xerca.xercapaint.client.BasePalette;
import xerca.xercapaint.client.BrushSound;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.SoundEvents;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.EntityEasel;
import xerca.xercapaint.common.packets.CanvasMiniUpdatePacket;
import xerca.xercapaint.common.packets.CanvasUpdatePacket;
import xerca.xercapaint.common.packets.EaselLeftPacket;
import xerca.xercapaint.common.packets.PaletteUpdatePacket;

@OnlyIn(value=Dist.CLIENT)
public class GuiCanvasEdit
extends BasePalette {
    private double canvasX;
    private double canvasY;
    private static final double[] canvasXs = new double[]{-1000.0, -1000.0, -1000.0, -1000.0};
    private static final double[] canvasYs = new double[]{-1000.0, -1000.0, -1000.0, -1000.0};
    private final int canvasWidth;
    private final int canvasHeight;
    private int brushMeterX;
    private int brushMeterY;
    private int brushOpacityMeterX;
    private int brushOpacityMeterY;
    private final int canvasPixelScale;
    private final int canvasPixelWidth;
    private final int canvasPixelHeight;
    private int brushSize = 0;
    private boolean touchedCanvas = false;
    private boolean undoStarted = false;
    private boolean gettingSigned;
    private boolean isCarryingCanvas;
    private Button buttonSign;
    private Button buttonCancel;
    private Button buttonFinalize;
    private int updateCount = 0;
    private BrushSound brushSound = null;
    private final int canvasHolderHeight = 10;
    private static int brushOpacitySetting = 0;
    private static final float[] brushOpacities = new float[]{1.0f, 0.75f, 0.5f, 0.25f};
    private static boolean showHelp = false;
    private final Set<Integer> draggedPoints = new HashSet<Integer>();
    private final Player editingPlayer;
    private final CanvasType canvasType;
    private boolean isSigned = false;
    private int[] pixels;
    private String canvasTitle = "";
    private String name = "";
    private int version = 0;
    private final EntityEasel easel;
    private int timeSinceLastUpdate = 0;
    private boolean skippedUpdate = false;
    private static final Vec2[] outlinePoss1 = new Vec2[]{new Vec2(0.0f, 199.0f), new Vec2(12.0f, 199.0f), new Vec2(34.0f, 199.0f), new Vec2(76.0f, 199.0f)};
    private static final Vec2[] outlinePoss2 = new Vec2[]{new Vec2(128.0f, 199.0f), new Vec2(135.0f, 199.0f), new Vec2(147.0f, 199.0f), new Vec2(169.0f, 199.0f)};
    private static final int maxUndoLength = 16;
    private final Deque<int[]> undoStack = new ArrayDeque<int[]>(16);

    protected GuiCanvasEdit(Player player, CompoundTag canvasTag, CompoundTag paletteTag, Component title, CanvasType canvasType, EntityEasel easel) {
        super(title, paletteTag);
        this.canvasType = canvasType;
        this.canvasPixelScale = canvasType == CanvasType.SMALL ? 10 : 5;
        this.canvasPixelWidth = CanvasType.getWidth(canvasType);
        this.canvasPixelHeight = CanvasType.getHeight(canvasType);
        int canvasPixelArea = this.canvasPixelHeight * this.canvasPixelWidth;
        this.canvasWidth = this.canvasPixelWidth * this.canvasPixelScale;
        this.canvasHeight = this.canvasPixelHeight * this.canvasPixelScale;
        this.easel = easel;
        this.editingPlayer = player;
        if (canvasTag != null && !canvasTag.m_128456_()) {
            int[] nbtPixels = canvasTag.m_128465_("pixels");
            this.canvasTitle = canvasTag.m_128461_("title");
            this.name = canvasTag.m_128461_("name");
            this.version = canvasTag.m_128451_("v");
            this.pixels = Arrays.copyOfRange(nbtPixels, 0, canvasPixelArea);
        } else {
            this.isSigned = false;
        }
        if (this.pixels == null) {
            this.pixels = new int[canvasPixelArea];
            Arrays.fill(this.pixels, basicColors[15].rgbVal());
            long secs = System.currentTimeMillis() / 1000L;
            this.name = player.m_20148_() + "_" + secs;
        }
        if (this.paletteComplete) {
            XercaPaint.LOGGER.warn("Is complete");
        }
    }

    public void m_7856_() {
        this.canvasX = canvasXs[this.canvasType.ordinal()];
        this.canvasY = canvasYs[this.canvasType.ordinal()];
        this.paletteX = paletteXs[this.canvasType.ordinal()];
        this.paletteY = paletteYs[this.canvasType.ordinal()];
        if (this.canvasX == -1000.0 || this.canvasY == -1000.0 || this.paletteX == -1000.0 || this.paletteY == -1000.0) {
            this.resetPositions();
        }
        this.updateCanvasPos(0.0, 0.0);
        this.updatePalettePos(0.0, 0.0);
        Window window = this.f_96541_.m_91268_();
        GLFW.glfwSetInputMode((long)window.m_85439_(), (int)208897, (int)212994);
        int x = window.m_85445_() - 120;
        int y = window.m_85446_() - 30;
        this.buttonSign = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"canvas.signButton"), button -> {
            if (!this.isSigned) {
                this.gettingSigned = true;
                this.resetPositions();
                this.updateButtons();
                GLFW.glfwSetInputMode((long)window.m_85439_(), (int)208897, (int)212993);
            }
        }).m_252987_(x, y, 98, 20).m_253136_());
        this.buttonFinalize = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"canvas.finalizeButton"), button -> {
            if (!this.isSigned) {
                this.canvasDirty = true;
                this.isSigned = true;
                if (this.f_96541_ != null) {
                    this.f_96541_.m_91152_(null);
                }
            }
        }).m_252987_((int)this.canvasX - 100, 100, 98, 20).m_253136_());
        this.buttonCancel = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), button -> {
            if (!this.isSigned) {
                this.gettingSigned = false;
                this.updateButtons();
                GLFW.glfwSetInputMode((long)window.m_85439_(), (int)208897, (int)212994);
            }
        }).m_252987_((int)this.canvasX - 100, 130, 98, 20).m_253136_());
        x = (int)((double)window.m_85445_() * 0.95) - 21;
        y = (int)((double)window.m_85446_() * 0.05);
        this.m_142416_((GuiEventListener)new ToggleHelpButton(x, y, 21, 21, 197, 0, 21, paletteTextures, 256, 256, button -> {
            showHelp = !showHelp;
        }, Tooltip.m_257550_((Component)Component.m_237113_((String)"Toggle help tooltips"))));
        this.updateButtons();
    }

    private void updateButtons() {
        if (!this.isSigned) {
            this.buttonSign.f_93624_ = !this.gettingSigned;
            this.buttonCancel.f_93624_ = this.gettingSigned;
            this.buttonFinalize.f_93624_ = this.gettingSigned;
            this.buttonFinalize.f_93623_ = !this.canvasTitle.trim().isEmpty();
            this.buttonFinalize.m_252865_((int)this.canvasX - 100);
            this.buttonCancel.m_252865_((int)this.canvasX - 100);
        }
    }

    private int getPixelAt(int x, int y) {
        return this.pixels[y * this.canvasPixelWidth + x];
    }

    private void setPixelAt(int x, int y, PaletteUtil.Color color, float opacity) {
        if (x >= 0 && y >= 0 && x < this.canvasPixelWidth && y < this.canvasPixelHeight && !this.draggedPoints.contains(y * this.canvasPixelWidth + x)) {
            this.draggedPoints.add(y * this.canvasPixelWidth + x);
            this.pixels[y * this.canvasPixelWidth + x] = PaletteUtil.Color.mix(color, new PaletteUtil.Color(this.pixels[y * this.canvasPixelWidth + x]), opacity).rgbVal();
        }
    }

    private void setPixelsAt(int mouseX, int mouseY, PaletteUtil.Color color, int brushSize, float opacity) {
        int pixelHalf = this.canvasPixelScale / 2;
        switch (brushSize) {
            case 0: {
                int x = (mouseX - (int)this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY) / this.canvasPixelScale;
                this.setPixelAt(x, y, color, opacity);
                break;
            }
            case 1: {
                int x = (mouseX - (int)this.canvasX + pixelHalf) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY + pixelHalf) / this.canvasPixelScale;
                this.setPixelAt(x, y, color, opacity);
                this.setPixelAt(x - 1, y, color, opacity);
                this.setPixelAt(x, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 1, color, opacity);
                break;
            }
            case 2: {
                int x = (mouseX - (int)this.canvasX + pixelHalf) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY + pixelHalf) / this.canvasPixelScale;
                this.setPixelAt(x - 1, y + 1, color, opacity);
                this.setPixelAt(x, y + 1, color, opacity);
                this.setPixelAt(x - 2, y, color, opacity);
                this.setPixelAt(x - 1, y, color, opacity);
                this.setPixelAt(x, y, color, opacity);
                this.setPixelAt(x + 1, y, color, opacity);
                this.setPixelAt(x - 2, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 1, color, opacity);
                this.setPixelAt(x, y - 1, color, opacity);
                this.setPixelAt(x + 1, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 2, color, opacity);
                this.setPixelAt(x, y - 2, color, opacity);
                break;
            }
            case 3: {
                int x = (mouseX - (int)this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY) / this.canvasPixelScale;
                this.setPixelAt(x - 1, y + 2, color, opacity);
                this.setPixelAt(x + 0, y + 2, color, opacity);
                this.setPixelAt(x + 1, y + 2, color, opacity);
                this.setPixelAt(x - 2, y + 1, color, opacity);
                this.setPixelAt(x - 1, y + 1, color, opacity);
                this.setPixelAt(x + 0, y + 1, color, opacity);
                this.setPixelAt(x + 1, y + 1, color, opacity);
                this.setPixelAt(x + 2, y + 1, color, opacity);
                this.setPixelAt(x - 2, y, color, opacity);
                this.setPixelAt(x - 1, y, color, opacity);
                this.setPixelAt(x + 0, y, color, opacity);
                this.setPixelAt(x + 1, y, color, opacity);
                this.setPixelAt(x + 2, y, color, opacity);
                this.setPixelAt(x - 2, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 1, color, opacity);
                this.setPixelAt(x + 0, y - 1, color, opacity);
                this.setPixelAt(x + 1, y - 1, color, opacity);
                this.setPixelAt(x + 2, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 2, color, opacity);
                this.setPixelAt(x + 0, y - 2, color, opacity);
                this.setPixelAt(x + 1, y - 2, color, opacity);
            }
        }
    }

    private void resetPositions() {
        int padding = 40;
        int paletteCanvasX = (this.f_96543_ - (157 + this.canvasWidth + 40)) / 2;
        this.canvasX = paletteCanvasX + 157 + 40;
        this.canvasY = this.canvasType.equals((Object)CanvasType.LONG) ? 80.0 : 40.0;
        this.paletteX = paletteCanvasX;
        this.paletteY = 40.0;
    }

    public void m_86600_() {
        ++this.updateCount;
        ++this.timeSinceLastUpdate;
        if (this.easel != null) {
            if (this.easel.getItem().m_41619_() || this.easel.m_213877_() || this.easel.m_20280_((Entity)this.editingPlayer) > 64.0) {
                this.m_7379_();
            }
            if (this.skippedUpdate && this.timeSinceLastUpdate > 20 && this.canvasDirty) {
                this.updateCanvas(false);
                this.skippedUpdate = false;
            }
        }
        super.m_86600_();
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
        int i;
        if (!this.gettingSigned) {
            super.m_88315_(guiGraphics, mouseX, mouseY, f);
        } else {
            super.superRender(guiGraphics, mouseX, mouseY, f);
        }
        guiGraphics.m_280509_((int)(this.canvasX + (double)this.canvasWidth * 0.25), (int)this.canvasY - 10, (int)(this.canvasX + (double)this.canvasWidth * 0.75), (int)this.canvasY, -1973791);
        for (i = 0; i < this.canvasPixelHeight; ++i) {
            for (int j = 0; j < this.canvasPixelWidth; ++j) {
                int y = (int)this.canvasY + i * this.canvasPixelScale;
                int x = (int)this.canvasX + j * this.canvasPixelScale;
                guiGraphics.m_280509_(x, y, x + this.canvasPixelScale, y + this.canvasPixelScale, this.getPixelAt(j, i));
            }
        }
        if (!this.gettingSigned) {
            for (i = 0; i < 4; ++i) {
                int y = this.brushMeterY + i * 9;
                guiGraphics.m_280509_(this.brushMeterX, y, this.brushMeterX + 3, y + 3, currentColor.rgbVal());
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280218_(paletteTextures, this.brushMeterX, this.brushMeterY + (3 - this.brushSize) * 9, 15, 246, 10, 10);
            guiGraphics.m_280218_(paletteTextures, this.brushMeterX, this.brushMeterY, 0, 220, 9, 36);
            guiGraphics.m_280218_(paletteTextures, this.brushOpacityMeterX, this.brushOpacityMeterY, 196, 197, 14, 59);
            guiGraphics.m_280218_(paletteTextures, this.brushOpacityMeterX - 1, this.brushOpacityMeterY - 1 + brushOpacitySetting * 15, 212, 240, 16, 16);
            this.renderCursor(guiGraphics, mouseX, mouseY);
            if (showHelp) {
                if (this.inBrushMeter(mouseX, mouseY)) {
                    int selectedSize = 3 - (mouseY - this.brushMeterY) / 9;
                    if (selectedSize <= 3 && selectedSize >= 0) {
                        guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)("Brush size (" + (selectedSize + 1) + ")")), mouseX, mouseY);
                    }
                } else if (this.inBrushOpacityMeter(mouseX, mouseY)) {
                    int relativeY = mouseY - this.brushOpacityMeterY;
                    int selectedOpacity = relativeY / 15;
                    if (selectedOpacity >= 0 && selectedOpacity <= 3) {
                        int percentage = 100 - 25 * selectedOpacity;
                        guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)("Brush opacity (" + percentage + "%)")), mouseX, mouseY);
                    }
                } else if (this.inColorPicker(mouseX - (int)this.paletteX, mouseY - (int)this.paletteY)) {
                    guiGraphics.m_280666_(this.f_96547_, Arrays.asList(Component.m_237113_((String)"Color picker"), Component.m_237113_((String)"Select the tool, then pick up a color from the canvas and drag-and-drop it to a custom color slot.").m_130940_(ChatFormatting.GRAY)), mouseX, mouseY);
                } else if (this.inWater(mouseX - (int)this.paletteX, mouseY - (int)this.paletteY)) {
                    guiGraphics.m_280666_(this.f_96547_, Arrays.asList(Component.m_237113_((String)"Color remover"), Component.m_237113_((String)"Pick up some water and drag-and-drop it to a custom color slot to clear it.").m_130940_(ChatFormatting.GRAY)), mouseX, mouseY);
                } else if (this.inCanvasHolder(mouseX, mouseY)) {
                    guiGraphics.m_280666_(this.f_96547_, Arrays.asList(Component.m_237113_((String)"Canvas holder"), Component.m_237113_((String)"Pick up the canvas and move it wherever you want. You can move the palette in the same way.").m_130940_(ChatFormatting.GRAY)), mouseX, mouseY);
                }
            }
        } else {
            this.drawSigning(guiGraphics);
        }
    }

    private void renderCursor(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isCarryingColor) {
            this.carriedColor.setGLColor();
            guiGraphics.m_280218_(paletteTextures, mouseX - 4, mouseY - 4, 9, 247, 6, 9);
        } else if (this.isCarryingWater) {
            waterColor.setGLColor();
            guiGraphics.m_280218_(paletteTextures, mouseX - 4, mouseY - 4, 9, 247, 6, 9);
        } else if (this.isPickingColor) {
            this.drawOutline(guiGraphics, mouseX, mouseY, 0);
            PaletteUtil.Color.WHITE.setGLColor();
            guiGraphics.m_280218_(paletteTextures, mouseX, mouseY - 14, 25, 242, 14, 14);
        } else {
            this.drawOutline(guiGraphics, mouseX, mouseY, this.brushSize);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280509_(mouseX, mouseY, mouseX + 3, mouseY + 3, currentColor.rgbVal());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int trueBrushY = 247 - 9 * this.brushSize;
            guiGraphics.m_280218_(paletteTextures, mouseX, mouseY, 0, trueBrushY, 9, 9);
        }
    }

    private void drawOutline(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, int brushSize) {
        if (this.inCanvas(mouseX, mouseY)) {
            int x = 0;
            int y = 0;
            int outlineSize = 0;
            int pixelHalf = this.canvasPixelScale / 2;
            if (brushSize == 0) {
                x = (mouseX - (int)this.canvasX) / this.canvasPixelScale * this.canvasPixelScale + (int)this.canvasX - 1;
                y = (mouseY - (int)this.canvasY) / this.canvasPixelScale * this.canvasPixelScale + (int)this.canvasY - 1;
                outlineSize = this.canvasPixelScale + 2;
            }
            if (brushSize == 1) {
                x = ((mouseX - (int)this.canvasX + pixelHalf) / this.canvasPixelScale - 1) * this.canvasPixelScale + (int)this.canvasX - 1;
                y = ((mouseY - (int)this.canvasY + pixelHalf) / this.canvasPixelScale - 1) * this.canvasPixelScale + (int)this.canvasY - 1;
                outlineSize = this.canvasPixelScale * 2 + 2;
            }
            if (brushSize == 2) {
                x = ((mouseX - (int)this.canvasX + pixelHalf) / this.canvasPixelScale - 2) * this.canvasPixelScale + (int)this.canvasX - 1;
                y = ((mouseY - (int)this.canvasY + pixelHalf) / this.canvasPixelScale - 2) * this.canvasPixelScale + (int)this.canvasY - 1;
                outlineSize = this.canvasPixelScale * 4 + 2;
            }
            if (brushSize == 3) {
                x = ((mouseX - (int)this.canvasX) / this.canvasPixelScale - 2) * this.canvasPixelScale + (int)this.canvasX - 1;
                y = ((mouseY - (int)this.canvasY) / this.canvasPixelScale - 2) * this.canvasPixelScale + (int)this.canvasY - 1;
                outlineSize = this.canvasPixelScale * 5 + 2;
            }
            Vec2 textureVec = this.canvasPixelScale == 10 ? outlinePoss1[brushSize] : outlinePoss2[brushSize];
            RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
            guiGraphics.m_280218_(paletteTextures, x, y, (int)textureVec.f_82470_, (int)textureVec.f_82471_, outlineSize, outlineSize);
        }
    }

    private void drawSigning(@NotNull GuiGraphics guiGraphics) {
        int i = (int)this.canvasX;
        int j = (int)this.canvasY;
        guiGraphics.m_280509_(i + 10, j + 10, i + 150, j + 150, -1118482);
        Object s = this.canvasTitle;
        if (!this.isSigned) {
            s = this.updateCount / 6 % 2 == 0 ? (String)s + ChatFormatting.BLACK + "_" : (String)s + ChatFormatting.GRAY + "_";
        }
        String s1 = I18n.m_118938_((String)"canvas.editTitle", (Object[])new Object[0]);
        int k = this.f_96547_.m_92895_(s1);
        guiGraphics.m_280056_(this.f_96547_, s1, (int)((float)(i + 26) + (float)(116 - k) / 2.0f), j + 16 + 16, 0, false);
        int l = this.f_96547_.m_92895_((String)s);
        guiGraphics.m_280056_(this.f_96547_, (String)s, (int)((float)(i + 26) + (float)(116 - l) / 2.0f), j + 48, 0, false);
        String s2 = I18n.m_118938_((String)"canvas.byAuthor", (Object[])new Object[]{this.editingPlayer.m_7755_().getString()});
        int i1 = this.f_96547_.m_92895_(s2);
        guiGraphics.m_280056_(this.f_96547_, ChatFormatting.DARK_GRAY + s2, (int)((float)(i + 26) + (float)(116 - i1) / 2.0f), j + 48 + 10, 0, false);
        guiGraphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"canvas.finalizeWarning"), i + 26, j + 80, 116, 0);
    }

    private void playBrushSound() {
        this.brushSound = new BrushSound();
        this.playSound((SoundInstance)this.brushSound);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.gettingSigned) {
            switch (keyCode) {
                case 259: {
                    if (this.canvasTitle.isEmpty()) break;
                    this.canvasTitle = this.canvasTitle.substring(0, this.canvasTitle.length() - 1);
                    this.updateButtons();
                    break;
                }
                case 257: {
                    if (this.canvasTitle.isEmpty()) break;
                    this.canvasDirty = true;
                    this.isSigned = true;
                    if (this.f_96541_ == null) break;
                    this.f_96541_.m_91152_(null);
                    break;
                }
            }
            return true;
        }
        if (keyCode == 90 && (modifiers & 2) == 2) {
            if (!this.undoStack.isEmpty()) {
                this.pixels = this.undoStack.pop();
                this.canvasDirty = true;
                if (this.easel != null) {
                    this.updateCanvas(false);
                }
            }
            return true;
        }
        if (keyCode == 79 && ++brushOpacitySetting >= 4) {
            brushOpacitySetting = 0;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char typedChar, int something) {
        super.m_5534_(typedChar, something);
        if (!this.isSigned) {
            if (this.gettingSigned && this.canvasTitle.length() < 16 && SharedConstants.m_136188_((char)typedChar)) {
                this.canvasTitle = this.canvasTitle + typedChar;
                this.updateButtons();
            }
            return true;
        }
        return false;
    }

    public boolean m_6050_(double posX, double posY, double scroll) {
        int mouseX = (int)Math.floor(posX);
        int mouseY = (int)Math.floor(posY);
        if (!this.gettingSigned && scroll != 0.0) {
            if (this.inBrushOpacityMeter(mouseX, mouseY)) {
                int maxBrushOpacity = 3;
                if ((brushOpacitySetting += scroll < 0.0 ? 1 : -1) > 3) {
                    brushOpacitySetting = 0;
                } else if (brushOpacitySetting < 0) {
                    brushOpacitySetting = 3;
                }
                return true;
            }
            int maxBrushSize = 3;
            this.brushSize += scroll > 0.0 ? 1 : -1;
            if (this.brushSize > 3) {
                this.brushSize = 0;
            } else if (this.brushSize < 0) {
                this.brushSize = 3;
            }
            return true;
        }
        return super.m_6050_(posX, posY, scroll);
    }

    @Override
    public boolean m_6375_(double posX, double posY, int mouseButton) {
        if (this.gettingSigned) {
            return super.superMouseClicked(posX, posY, mouseButton);
        }
        int mouseX = (int)Math.floor(posX);
        int mouseY = (int)Math.floor(posY);
        this.undoStarted = true;
        this.touchedCanvas = false;
        if (this.undoStack.size() >= 16) {
            this.undoStack.removeLast();
        }
        this.undoStack.push((int[])this.pixels.clone());
        if (this.inCanvas(mouseX, mouseY)) {
            if (this.isPickingColor) {
                int x = (mouseX - (int)this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY) / this.canvasPixelScale;
                if (x >= 0 && y >= 0 && x < this.canvasPixelWidth && y < this.canvasPixelHeight) {
                    int color = this.getPixelAt(x, y);
                    this.carriedColor = new PaletteUtil.Color(color);
                    this.setCarryingColor();
                    this.playSound((SoundEvent)SoundEvents.COLOR_PICKER_SUCK.get());
                }
            } else {
                this.clickedCanvas(mouseX, mouseY, mouseButton);
                this.playBrushSound();
            }
            return super.superMouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.inBrushMeter(mouseX, mouseY)) {
            int selectedSize = 3 - (mouseY - this.brushMeterY) / 9;
            if (selectedSize <= 3 && selectedSize >= 0) {
                this.brushSize = selectedSize;
            }
            return super.superMouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.inBrushOpacityMeter(mouseX, mouseY)) {
            int relativeY = mouseY - this.brushOpacityMeterY;
            int selectedOpacity = relativeY / 15;
            if (selectedOpacity >= 0 && selectedOpacity <= 3) {
                brushOpacitySetting = selectedOpacity;
            }
            return super.superMouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.inCanvasHolder(mouseX, mouseY)) {
            this.isCarryingCanvas = true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    private void clickedCanvas(int mouseX, int mouseY, int mouseButton) {
        this.touchedCanvas = true;
        if (mouseButton == 0) {
            this.setPixelsAt(mouseX, mouseY, currentColor, this.brushSize, brushOpacities[brushOpacitySetting]);
        } else if (mouseButton == 1) {
            this.setPixelsAt(mouseX, mouseY, PaletteUtil.Color.WHITE, this.brushSize, 1.0f);
        }
        this.canvasDirty = true;
    }

    @Override
    public boolean m_6348_(double posX, double posY, int mouseButton) {
        this.isCarryingCanvas = false;
        if (this.gettingSigned) {
            return super.superMouseReleased(posX, posY, mouseButton);
        }
        this.draggedPoints.clear();
        if (this.undoStarted && !this.touchedCanvas) {
            this.undoStarted = false;
            this.undoStack.removeFirst();
        }
        if (this.brushSound != null) {
            this.brushSound.stopSound();
        }
        if (this.easel != null) {
            this.updateCanvas(false);
        }
        return super.m_6348_(posX, posY, mouseButton);
    }

    @Override
    public boolean m_7979_(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        if (this.gettingSigned) {
            return super.superMouseDragged(posX, posY, mouseButton, deltaX, deltaY);
        }
        if (!(this.isCarryingColor || this.isCarryingWater || this.isPickingColor || this.isCarryingPalette || this.isCarryingCanvas)) {
            int mouseY;
            int mouseX = (int)Math.floor(posX);
            if (this.inCanvas(mouseX, mouseY = (int)Math.floor(posY))) {
                this.clickedCanvas(mouseX, mouseY, mouseButton);
            }
            if (this.brushSound != null) {
                this.brushSound.refreshFade();
            }
        } else {
            if (this.isCarryingCanvas) {
                this.updateCanvasPos(deltaX, deltaY);
                return super.superMouseDragged(posX, posY, mouseButton, deltaX, deltaY);
            }
            if (this.isCarryingPalette) {
                boolean ret = super.m_7979_(posX, posY, mouseButton, deltaX, deltaY);
                this.updatePalettePos(deltaX, deltaY);
                return ret;
            }
        }
        return super.m_7979_(posX, posY, mouseButton, deltaX, deltaY);
    }

    private void updateCanvasPos(double deltaX, double deltaY) {
        this.canvasX += deltaX;
        this.canvasY += deltaY;
        this.brushMeterX = (int)this.canvasX + this.canvasWidth + 2;
        this.brushMeterY = (int)this.canvasY + this.canvasHeight / 2 + 30;
        this.brushOpacityMeterX = (int)this.canvasX + this.canvasWidth + 2;
        this.brushOpacityMeterY = (int)this.canvasY;
        GuiCanvasEdit.canvasXs[this.canvasType.ordinal()] = this.canvasX;
        GuiCanvasEdit.canvasYs[this.canvasType.ordinal()] = this.canvasY;
    }

    private void updatePalettePos(double deltaX, double deltaY) {
        this.paletteX += deltaX;
        this.paletteY += deltaY;
        GuiCanvasEdit.paletteXs[this.canvasType.ordinal()] = this.paletteX;
        GuiCanvasEdit.paletteYs[this.canvasType.ordinal()] = this.paletteY;
    }

    private boolean inCanvas(int x, int y) {
        return (double)x < this.canvasX + (double)this.canvasWidth && (double)x >= this.canvasX && (double)y < this.canvasY + (double)this.canvasHeight && (double)y >= this.canvasY;
    }

    private boolean inCanvasHolder(int x, int y) {
        return (double)x < this.canvasX + (double)this.canvasWidth * 0.75 && (double)x >= this.canvasX + (double)this.canvasWidth * 0.25 && (double)y < this.canvasY && (double)y >= this.canvasY - 10.0;
    }

    private boolean inBrushMeter(int x, int y) {
        return x < this.brushMeterX + 9 && x >= this.brushMeterX && y < this.brushMeterY + 36 && y >= this.brushMeterY;
    }

    private boolean inBrushOpacityMeter(int x, int y) {
        return x < this.brushOpacityMeterX + 14 && x >= this.brushOpacityMeterX && y < this.brushOpacityMeterY + 56 + 3 && y >= this.brushOpacityMeterY;
    }

    public void m_7861_() {
        this.updateCanvas(true);
    }

    private void updateCanvas(boolean closing) {
        if (closing) {
            if (this.canvasDirty) {
                ++this.version;
                CanvasUpdatePacket pack = new CanvasUpdatePacket(this.pixels, this.isSigned, this.canvasTitle, this.name, this.version, this.easel, this.customColors, this.canvasType);
                XercaPaint.NETWORK_HANDLER.sendToServer((Object)pack);
            } else {
                Object pack;
                if (this.easel != null) {
                    pack = new EaselLeftPacket(this.easel);
                    XercaPaint.NETWORK_HANDLER.sendToServer(pack);
                }
                if (this.paletteDirty) {
                    pack = new PaletteUpdatePacket(this.customColors);
                    XercaPaint.NETWORK_HANDLER.sendToServer(pack);
                }
            }
        } else if (this.canvasDirty) {
            if (this.timeSinceLastUpdate < 10) {
                this.skippedUpdate = true;
            } else {
                ++this.version;
                CanvasMiniUpdatePacket pack = new CanvasMiniUpdatePacket(this.pixels, this.name, this.version, this.easel, this.canvasType);
                XercaPaint.NETWORK_HANDLER.sendToServer((Object)pack);
                this.canvasDirty = false;
                this.timeSinceLastUpdate = 0;
            }
        }
    }

    public static class ToggleHelpButton
    extends Button {
        protected final ResourceLocation resourceLocation;
        protected final int xTexStart;
        protected final int yTexStart;
        protected final int yDiffText;
        protected final int texWidth;
        protected final int texHeight;

        public ToggleHelpButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, int texWidth, int texHeight, Button.OnPress onClick, Tooltip tooltip) {
            super(x, y, width, height, (Component)Component.m_237119_(), onClick, Button.f_252438_);
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.xTexStart = xTexStart;
            this.yTexStart = yTexStart;
            this.yDiffText = yDiffText;
            this.resourceLocation = texture;
            this.m_257544_(tooltip);
        }

        protected void postRender() {
            GlStateManager._enableDepthTest();
        }

        public void m_87963_(@NotNull GuiGraphics guiGraphics, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.resourceLocation);
            GlStateManager._disableDepthTest();
            int yTexStartNew = this.yTexStart;
            if (this.f_93622_) {
                yTexStartNew += this.yDiffText;
            }
            int xTexStartNew = this.xTexStart + (showHelp ? 0 : this.f_93618_);
            guiGraphics.m_280163_(this.resourceLocation, this.m_252754_(), this.m_252907_(), (float)xTexStartNew, (float)yTexStartNew, this.f_93618_, this.f_93619_, this.texWidth, this.texHeight);
            this.postRender();
        }
    }
}

