/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.GalenaSpireBlock;
import com.github.alexmodguy.alexscaves.server.block.TeslaBulbBlock;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class TeslaBulbFeature
extends Feature<NoneFeatureConfiguration> {
    public TeslaBulbFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        boolean ceiling = randomsource.m_188499_();
        BlockPos.MutableBlockPos generateAt = new BlockPos.MutableBlockPos();
        generateAt.m_122190_((Vec3i)context.m_159777_());
        if (!level.m_8055_((BlockPos)generateAt).m_60819_().m_192917_((Fluid)Fluids.f_76193_) && !level.m_46859_((BlockPos)generateAt)) {
            return false;
        }
        if (ceiling) {
            while ((level.m_8055_((BlockPos)generateAt).m_60819_().m_192917_((Fluid)Fluids.f_76193_) || !level.m_8055_((BlockPos)generateAt).m_60783_((BlockGetter)level, (BlockPos)generateAt, Direction.DOWN)) && generateAt.m_123342_() < level.m_151558_()) {
                generateAt.m_122184_(0, 1, 0);
            }
        } else {
            while ((level.m_8055_((BlockPos)generateAt).m_60819_().m_192917_((Fluid)Fluids.f_76193_) || !level.m_8055_((BlockPos)generateAt).m_60783_((BlockGetter)level, (BlockPos)generateAt, Direction.UP)) && generateAt.m_123342_() > level.m_141937_()) {
                generateAt.m_122184_(0, -1, 0);
            }
        }
        if (!level.m_8055_((BlockPos)generateAt).m_204336_(ACTagRegistry.TESLA_BULB_BASE_BLOCKS)) {
            return false;
        }
        BlockPos below = generateAt.m_7949_();
        int centerHeight = 3 + randomsource.m_188503_(3);
        TeslaBulbFeature.generatePillar(level, below, randomsource, centerHeight, ceiling, randomsource.m_188501_() < 0.25f);
        for (int i = 0; i < 4 + randomsource.m_188503_(4); ++i) {
            BlockPos offset = below.m_7918_(randomsource.m_188503_(8) - 4, ceiling ? -3 : 3, randomsource.m_188503_(8) - 4);
            if (ceiling) {
                while (!level.m_8055_(offset).m_60783_((BlockGetter)level, offset, Direction.DOWN) && offset.m_123342_() < level.m_151558_()) {
                    offset = offset.m_7494_();
                }
            } else {
                while (!level.m_8055_(offset).m_60783_((BlockGetter)level, offset, Direction.UP) && offset.m_123342_() > level.m_141937_()) {
                    offset = offset.m_7495_();
                }
            }
            if (!level.m_8055_(offset.m_121945_(ceiling ? Direction.UP : Direction.DOWN)).m_204336_(ACTagRegistry.TESLA_BULB_BASE_BLOCKS) || offset.m_123341_() == below.m_123341_() && offset.m_123343_() == below.m_123343_()) continue;
            int dist = (int)Math.ceil((float)offset.m_123333_((Vec3i)below) * 0.2f);
            TeslaBulbFeature.generatePillar(level, offset, randomsource, Math.min(centerHeight - dist, 1) + randomsource.m_188503_(2), ceiling, false);
        }
        return true;
    }

    private static boolean canReplace(BlockState state) {
        return (state.m_60795_() || state.m_247087_()) && !state.m_204336_(ACTagRegistry.UNMOVEABLE);
    }

    private static void generatePillar(WorldGenLevel level, BlockPos pos, RandomSource randomSource, int height, boolean ceiling, boolean tesla) {
        BlockPos begin = pos.m_5484_(ceiling ? Direction.UP : Direction.DOWN, 3);
        BlockState spireState = (BlockState)((Block)ACBlockRegistry.GALENA_SPIRE.get()).m_49966_().m_61124_((Property)GalenaSpireBlock.DOWN, (Comparable)Boolean.valueOf(ceiling));
        int spireCount = 0;
        int j = 0;
        while (spireCount <= height && j < 25) {
            ++j;
            int shape = 0;
            if (spireCount > height - 1) {
                shape = 3;
            } else if (spireCount > height - 2) {
                shape = 2;
            } else if (spireCount >= 1) {
                shape = 1;
            }
            begin = ceiling ? begin.m_7495_() : begin.m_7494_();
            BlockState prevState = level.m_8055_(begin);
            if (prevState.m_60713_((Block)ACBlockRegistry.GALENA_SPIRE.get()) || !prevState.m_60819_().m_76178_() && !prevState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) break;
            if (!TeslaBulbFeature.canReplace(prevState)) continue;
            if (shape == 3 && tesla) {
                level.m_7731_(begin, (BlockState)((BlockState)((Block)ACBlockRegistry.TESLA_BULB.get()).m_49966_().m_61124_((Property)TeslaBulbBlock.DOWN, (Comparable)Boolean.valueOf(ceiling))).m_61124_((Property)TeslaBulbBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(begin).m_192917_((Fluid)Fluids.f_76193_))), 3);
                break;
            }
            level.m_7731_(begin, (BlockState)((BlockState)spireState.m_61124_((Property)GalenaSpireBlock.SHAPE, (Comparable)Integer.valueOf(shape))).m_61124_((Property)GalenaSpireBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(begin).m_192917_((Fluid)Fluids.f_76193_))), 3);
            ++spireCount;
        }
    }
}

