/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.enchantment.ACEnchantmentRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.SpinningPeppermintEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.SugarStaffHexEntity;
import com.github.alexmodguy.alexscaves.server.item.SeaStaffItem;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.function.Consumer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class SugarStaffItem
extends Item {
    public SugarStaffItem(Item.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsCaves.PROXY.getISTERProperties());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!level.f_46443_) {
            boolean hex = player.m_6144_();
            player.m_6674_(hand);
            Entity lookingAtEntity = SeaStaffItem.getClosestLookingAtEntityFor(level, player, 32.0);
            if (hex) {
                Vec3 ground = ACMath.getGroundBelowPosition((BlockGetter)player.m_9236_(), player.m_146892_());
                SugarStaffHexEntity sugarStaffHexEntity = (SugarStaffHexEntity)((EntityType)ACEntityRegistry.SUGAR_STAFF_HEX.get()).m_20615_(player.m_9236_());
                sugarStaffHexEntity.setOwner((LivingEntity)player);
                sugarStaffHexEntity.m_6034_(ground.f_82479_, ground.f_82480_, ground.f_82481_);
                sugarStaffHexEntity.setHexScale(1.0f + 0.25f * (float)itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.HUMUNGOUS_HEX.get()));
                level.m_7967_((Entity)sugarStaffHexEntity);
                level.m_5594_((Player)null, player.m_20183_(), (SoundEvent)ACSoundRegistry.SUGAR_STAFF_CAST_HEX.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                sugarStaffHexEntity.setLifespan(100 + 60 * itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.SPELL_LASTING.get()));
                player.m_36335_().m_41524_((Item)this, 100);
            } else {
                int spawnIn = 3 + itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.MULTIPLE_MINT.get());
                boolean flag = false;
                int despawnTime = 80;
                for (int i = 0; i < spawnIn; ++i) {
                    SpinningPeppermintEntity spinningPeppermintEntity = (SpinningPeppermintEntity)((EntityType)ACEntityRegistry.SPINNING_PEPPERMINT.get()).m_20615_(player.m_9236_());
                    spinningPeppermintEntity.m_146884_(player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() * 0.45f), 0.0));
                    if (itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.PEPPERMINT_PUNTING.get()) > 0) {
                        spinningPeppermintEntity.setStraight(true);
                        spinningPeppermintEntity.m_146922_(180.0f + player.m_6080_() + (float)((i - 1) * 15));
                        spinningPeppermintEntity.setSpinSpeed(8.0f);
                        despawnTime = 20;
                    } else {
                        spinningPeppermintEntity.setStraight(false);
                        spinningPeppermintEntity.m_146922_(180 + (i - 1) * 30);
                        spinningPeppermintEntity.setSpinSpeed(12.0f);
                    }
                    if (lookingAtEntity != null && itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.SEEKCANDY.get()) > 0) {
                        spinningPeppermintEntity.setSeekingEntityId(lookingAtEntity.m_19879_());
                        spinningPeppermintEntity.setSpinSpeed(50.0f);
                        despawnTime = 50;
                    }
                    spinningPeppermintEntity.setSpinRadius(3.5f);
                    spinningPeppermintEntity.setOwner((LivingEntity)player);
                    spinningPeppermintEntity.setStartAngle((float)(i * 360) / (float)spawnIn);
                    spinningPeppermintEntity.setLifespan(80);
                    level.m_7967_((Entity)spinningPeppermintEntity);
                }
                level.m_5594_((Player)null, player.m_20183_(), (SoundEvent)ACSoundRegistry.SUGAR_STAFF_CAST_PEPPERMINT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_36335_().m_41524_((Item)this, despawnTime);
            }
            itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(player1.m_7655_()));
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_8120_(ItemStack stack) {
        return stack.m_41613_() == 1;
    }
}

