/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.NotLavaSwimNodeEvaluator;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;

public class RadgillEntity
extends WaterAnimal
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(RadgillEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float landProgress;
    private float prevLandProgress;
    private float fishPitch = 0.0f;
    private float prevFishPitch = 0.0f;
    private boolean wasJustInAcid = false;

    public RadgillEntity(EntityType<? extends WaterAnimal> type, Level level) {
        super(type, level);
        this.f_21342_ = new AcidMoveControl();
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new WanderGoal());
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 8.0);
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level){

            protected PathFinder m_5532_(int p_26598_) {
                this.f_26508_ = new NotLavaSwimNodeEvaluator(true);
                return new PathFinder(this.f_26508_, p_26598_);
            }

            public boolean m_26574_() {
                return RadgillEntity.this.isInLiquid();
            }
        };
    }

    public int m_5792_() {
        return 2;
    }

    public boolean m_7296_(int i) {
        return false;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double dist) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean sit) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)sit);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    protected int m_5639_(float f, float f1) {
        return super.m_5639_(f, f1) - 5;
    }

    public static boolean checkRadgillSpawnRules(EntityType<? extends LivingEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return spawnType == MobSpawnType.SPAWNER || !level.m_6425_(pos).m_76178_() && level.m_6425_(pos).getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get();
    }

    public void m_8119_() {
        boolean grounded;
        super.m_8119_();
        this.prevLandProgress = this.landProgress;
        this.prevFishPitch = this.fishPitch;
        boolean bl = grounded = this.m_20096_() && !this.isInLiquid();
        if (grounded && this.landProgress < 5.0f) {
            this.landProgress += 1.0f;
        }
        if (!grounded && this.landProgress > 0.0f) {
            this.landProgress -= 1.0f;
        }
        this.fishPitch = Mth.m_14036_((float)((float)this.m_20184_().f_82480_ * 1.8f), (float)-1.0f, (float)1.0f) * -57.295776f;
        boolean inAcid = this.isInAcid();
        if (inAcid != this.wasJustInAcid) {
            for (int i = 0; i < 5 + this.f_19796_.m_188503_(5); ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.RADGILL_SPLASH.get(), this.m_20208_(0.8f), this.m_20191_().f_82289_ + (double)0.1f, this.m_20262_(0.8f), (this.f_19796_.m_188500_() - 0.5) * (double)0.3f, (double)(0.1f + this.f_19796_.m_188501_() * 0.3f), (this.f_19796_.m_188500_() - 0.5) * (double)0.3f);
            }
            this.wasJustInAcid = inAcid;
        }
        if (!this.isInLiquid() && this.m_6084_() && this.m_20096_() && this.f_19796_.m_188501_() < 0.1f) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f)));
            this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
            this.m_5496_((SoundEvent)ACSoundRegistry.RADGILL_FLOP.get(), this.m_6121_(), this.m_6100_());
        }
    }

    public float getFishPitch(float partialTick) {
        return this.prevFishPitch + (this.fishPitch - this.prevFishPitch) * partialTick;
    }

    private boolean isInLiquid() {
        return this.m_20072_() || this.isInAcid();
    }

    protected void m_6229_(int prevAir) {
        if (this.m_6084_() && !this.isInLiquid()) {
            this.m_20301_(prevAir - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269483_(), 2.0f);
            }
        } else {
            this.m_20301_(500);
        }
    }

    private boolean isInAcid() {
        return this.getFluidTypeHeight((FluidType)ACFluidRegistry.ACID_FLUID_TYPE.get()) > 0.0;
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 10.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public float getLandProgress(float partialTicks) {
        return (this.prevLandProgress + (this.landProgress - this.prevLandProgress) * partialTicks) * 0.2f;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResult type = super.m_6071_(player, hand);
        if (!type.m_19077_() && itemstack.m_41720_() == ACItemRegistry.ACID_BUCKET.get() && this.m_6084_()) {
            this.m_5496_(this.m_142623_(), 1.0f, 1.0f);
            ItemStack itemstack1 = this.m_28282_();
            this.m_6872_(itemstack1);
            ItemStack itemstack2 = ItemUtils.m_41817_((ItemStack)itemstack, (Player)player, (ItemStack)itemstack1, (boolean)false);
            player.m_21008_(hand, itemstack2);
            if (!this.m_9236_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, itemstack1);
            }
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return type;
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        CompoundTag platTag = new CompoundTag();
        this.m_7380_(platTag);
        CompoundTag compound = bucket.m_41784_();
        compound.m_128365_("FishBucketTag", (Tag)platTag);
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        if (compound.m_128441_("FishBucketTag")) {
            this.m_7378_(compound.m_128469_("FishBucketTag"));
        }
        this.m_20301_(2000);
    }

    public ItemStack m_28282_() {
        ItemStack stack = new ItemStack((ItemLike)ACItemRegistry.RADGILL_BUCKET.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.RADGILL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.RADGILL_HURT.get();
    }

    class AcidMoveControl
    extends MoveControl {
        public AcidMoveControl() {
            super((Mob)RadgillEntity.this);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && RadgillEntity.this.isInLiquid()) {
                Vec3 vector3d = new Vec3(this.f_24975_ - RadgillEntity.this.m_20185_(), this.f_24976_ - RadgillEntity.this.m_20186_(), this.f_24977_ - RadgillEntity.this.m_20189_());
                double d5 = vector3d.m_82553_();
                if (d5 < RadgillEntity.this.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    RadgillEntity.this.m_20256_(RadgillEntity.this.m_20184_().m_82490_(0.5));
                } else {
                    RadgillEntity.this.m_20256_(RadgillEntity.this.m_20184_().m_82549_(vector3d.m_82490_(this.f_24978_ * 0.06 / d5)));
                    Vec3 vector3d1 = RadgillEntity.this.m_20184_();
                    float f = -((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 180.0f / (float)Math.PI;
                    RadgillEntity.this.m_146922_(Mth.m_14148_((float)RadgillEntity.this.m_146908_(), (float)f, (float)20.0f));
                    RadgillEntity.this.f_20883_ = RadgillEntity.this.m_146908_();
                }
            }
        }
    }

    private class WanderGoal
    extends Goal {
        private BlockPos target;
        private boolean isJump;
        private boolean hasJumped;
        private int timeout = 0;

        private WanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private boolean isLiquidAt(BlockPos pos) {
            FluidState state = RadgillEntity.this.m_9236_().m_6425_(pos);
            return state.m_205070_(FluidTags.f_13131_) || state.getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get();
        }

        private BlockPos findMoveToPos(boolean jump) {
            BlockPos fishPos = RadgillEntity.this.m_20183_();
            for (int i = 0; i < 15; ++i) {
                BlockPos offset = fishPos.m_7918_(RadgillEntity.this.f_19796_.m_188503_(16) - 8, 0, RadgillEntity.this.f_19796_.m_188503_(16) - 8);
                while (this.isLiquidAt(offset) && offset.m_123342_() < RadgillEntity.this.m_9236_().m_151558_()) {
                    offset = offset.m_7494_();
                }
                if (this.isLiquidAt(offset) || !this.isLiquidAt(offset.m_7495_())) continue;
                BlockPos surface = offset.m_7495_();
                if (jump) {
                    surface = surface.m_6630_(2 + RadgillEntity.this.f_19796_.m_188503_(2));
                    return surface;
                }
                return this.isLiquidAt(surface = surface.m_6625_(1 + RadgillEntity.this.f_19796_.m_188503_(4))) ? surface : null;
            }
            return null;
        }

        public boolean m_8036_() {
            boolean jump;
            BlockPos found;
            if (!RadgillEntity.this.isInLiquid()) {
                return false;
            }
            if (RadgillEntity.this.m_217043_().m_188503_(10) == 0 && (found = this.findMoveToPos(jump = RadgillEntity.this.f_19796_.m_188501_() <= 0.4f)) != null) {
                this.isJump = jump;
                this.target = found;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return (RadgillEntity.this.isInLiquid() && !this.hasJumped || this.isJump) && RadgillEntity.this.m_20238_(Vec3.m_82512_((Vec3i)this.target)) < 3.0 && this.timeout < 200;
        }

        public void m_8041_() {
            this.hasJumped = false;
            this.timeout = 0;
        }

        public void m_8037_() {
            ++this.timeout;
            RadgillEntity.this.m_21573_().m_26519_((double)((float)this.target.m_123341_() + 0.5f), (double)((float)this.target.m_123342_() + 0.25f), (double)((float)this.target.m_123343_() + 0.5f), 1.0);
            double horizDistance = RadgillEntity.this.m_20275_((float)this.target.m_123341_() + 0.5f, RadgillEntity.this.m_20186_(), (float)this.target.m_123343_() + 0.5f);
            if (horizDistance < 16.0 && this.isJump && !this.hasJumped) {
                Vec3 targetVec = Vec3.m_82512_((Vec3i)this.target);
                Vec3 vec3 = targetVec.m_82546_(RadgillEntity.this.m_20182_());
                vec3 = vec3.m_82553_() < 1.0 ? Vec3.f_82478_ : vec3.m_82541_();
                Vec3 vec31 = new Vec3(vec3.f_82479_ * (double)0.8f, (double)(0.75f + RadgillEntity.this.f_19796_.m_188501_() * 0.3f), vec3.f_82480_ * (double)0.8f);
                RadgillEntity.this.m_20256_(vec31);
                if (RadgillEntity.this.m_20186_() > (double)this.target.m_123342_()) {
                    this.hasJumped = true;
                } else {
                    RadgillEntity.this.m_7618_(EntityAnchorArgument.Anchor.EYES, targetVec);
                }
            }
        }
    }
}

