/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.GumWormEntity;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class GumWormAttackGoal
extends Goal {
    private final GumWormEntity entity;
    private boolean leapingAttack;
    private int leapTicks;
    private int maxLeapTicks;
    private float leapHeight;

    public GumWormAttackGoal(GumWormEntity worm) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = worm;
    }

    public boolean m_8036_() {
        LivingEntity target = this.entity.m_5448_();
        return target != null && target.m_6084_() && this.entity.timeBetweenAttacks <= 0 && !this.entity.isRidingMode();
    }

    public void m_8041_() {
        this.entity.setBiting(false);
        this.entity.setLeaping(false);
        this.leapTicks = 0;
    }

    public void m_8056_() {
        this.leapTicks = 0;
        this.leapHeight = 0.2f + this.entity.m_217043_().m_188501_() * 0.2f;
    }

    public void m_8037_() {
        LivingEntity target = this.entity.m_5448_();
        if (target != null) {
            double dist = this.entity.m_20270_((Entity)target);
            if (dist > 13.0 && !this.leapingAttack && this.entity.leapAttackCooldown >= 0 && (this.entity.m_5830_() || this.entity.m_20096_()) && this.leapTicks == 0) {
                this.leapingAttack = true;
                this.maxLeapTicks = 15 + this.entity.m_217043_().m_188503_(8);
                this.leapTicks = 0;
            }
            if (this.leapingAttack) {
                this.entity.m_21573_().m_26573_();
                if (this.entity.m_5830_() && !this.entity.isLeaping()) {
                    this.entity.setLeaping(true);
                    this.entity.leapAttackCooldown = 330;
                }
                if (this.entity.isLeaping()) {
                    Vec3 leapOnPos = target.m_20182_().m_82546_(this.entity.m_20182_());
                    float f = -((float)Mth.m_14136_((double)leapOnPos.f_82479_, (double)leapOnPos.f_82481_)) * 180.0f / (float)Math.PI;
                    this.entity.m_146922_(f);
                    float f1 = (float)(-(Mth.m_14136_((double)leapOnPos.f_82480_, (double)leapOnPos.m_165924_()) * 57.2957763671875));
                    this.entity.setTargetDigPitch(f1);
                    if (this.leapTicks <= this.maxLeapTicks) {
                        ++this.leapTicks;
                        float leapUp = (1.0f - (float)this.leapTicks / (float)this.maxLeapTicks) * 8.0f * this.leapHeight;
                        Vec3 delta = leapOnPos.m_82490_((double)0.1f);
                        this.entity.m_20256_(this.entity.m_20184_().m_82490_((double)0.1f).m_82549_(delta.m_82520_(0.0, (double)leapUp, 0.0)));
                    } else {
                        this.leapingAttack = false;
                        this.leapTicks = 0;
                        this.entity.leapAttackCooldown = 300;
                    }
                }
            } else {
                this.entity.m_21573_().m_5624_((Entity)target, 1.0);
                this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                if (this.entity.isLeaping()) {
                    this.entity.setLeaping(false);
                }
            }
            if (this.entity.isMouthOpen() && this.entity.attackAllAroundMouth((float)this.entity.m_21051_(Attributes.f_22281_).m_22135_(), 2.0f)) {
                this.entity.timeBetweenAttacks = this.leapingAttack ? 100 : 20;
                this.entity.leapAttackCooldown = 300;
                this.leapingAttack = false;
                this.entity.attemptPlayAttackNoise();
            }
            this.entity.setBiting(dist < (double)(15.0f + target.m_20205_()));
        }
    }
}

