/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.fluid;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class PurpleSodaFluidType
extends FluidType {
    public static final ResourceLocation FLUID_STILL = new ResourceLocation("alexscaves:block/purple_soda_still");
    public static final ResourceLocation FLUID_FLOWING = new ResourceLocation("alexscaves:block/purple_soda_flowing");
    public static final ResourceLocation OVERLAY = new ResourceLocation("alexscaves:textures/misc/under_purple_soda.png");

    public PurpleSodaFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return FLUID_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLUID_FLOWING;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return OVERLAY;
            }
        });
    }

    public boolean isVaporizedOnPlacement(Level level, BlockPos pos, FluidStack stack) {
        return level.m_6042_().f_63857_();
    }

    public void onVaporize(@Nullable Player player, Level level, BlockPos pos, FluidStack stack) {
        SoundEvent sound = this.getSound(player, (BlockGetter)level, pos, SoundActions.FLUID_VAPORIZE);
        level.m_5594_(player, pos, sound != null ? sound : SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            level.m_7107_((ParticleOptions)ACParticleRegistry.PURPLE_SODA_FIZZ.get(), (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), (Math.random() - 0.5) * 0.25, Math.random() * 0.25, (Math.random() - 0.5) * 0.25);
        }
        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }
}

