/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.loaders;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.function.Supplier;
import me.srrapero720.watermedia.WaterMedia;
import me.srrapero720.watermedia.core.exceptions.IllegalEnvironmentException;
import me.srrapero720.watermedia.core.exceptions.IllegalTLauncherException;
import me.srrapero720.watermedia.core.exceptions.IncompatibleModException;
import me.srrapero720.watermedia.core.tools.Tool;
import me.srrapero720.watermedia.loaders.ILoader;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod(value="watermedia")
public class ForgeLoader
implements ILoader {
    private static final Marker IT = MarkerManager.getMarker((String)"ForgeLoader");
    private static final Path tmpPath = new File(System.getProperty("java.io.tmpdir")).toPath().toAbsolutePath().resolve("watermedia");
    private static final Path processPath = new File("").toPath().toAbsolutePath();

    public ForgeLoader() {
        try {
            String pairClassName = this.concatPackage("org", "apache", "commons", "lang3", "tuple", "Pair");
            Method pairOf = Class.forName(pairClassName).getMethod("of", Object.class, Object.class);
            Supplier<String> stringSupplier = () -> "";
            Supplier<Boolean> booleanSupplier = () -> true;
            Object o = pairOf.invoke(null, stringSupplier, booleanSupplier);
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> o);
            WaterMedia.LOGGER.info(IT, "DISPLAYTEST correctly updated");
        }
        catch (Throwable pairClassName) {
            // empty catch block
        }
        try {
            if (this.tlcheck()) {
                throw new IllegalTLauncherException();
            }
            if (this.modInstalled("xenon")) {
                throw new IncompatibleModException("xenon", "Xenon");
            }
            if (this.clientSide()) {
                WaterMedia.prepare(this).start();
            } else if (!this.developerMode()) {
                throw new IllegalEnvironmentException();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed starting WATERMeDIA for " + this.name() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public String name() {
        return "Forge";
    }

    @Override
    public Path tempDir() {
        return tmpPath;
    }

    @Override
    public Path processDir() {
        return processPath;
    }

    @Override
    public boolean tlcheck() {
        boolean tllike = false;
        try {
            tllike = this.modInstalled("tlskincape") || this.modInstalled("tlauncher_custom_cape_skin");
        }
        catch (Throwable t2) {
            WaterMedia.LOGGER.error(IT, "Cannot check if TL was installed");
        }
        if (!tllike && !(tllike = Tool.t())) {
            try {
                ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
                Class<?> launcher = Class.forName("cpw.mods.modlauncher.Launcher");
                Thread.currentThread().setContextClassLoader(launcher.getClassLoader());
                tllike = Tool.t();
                Thread.currentThread().setContextClassLoader(currentCL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tllike;
    }

    public boolean modInstalled(String id) {
        return FMLLoader.getLoadingModList().getModFileById(id) != null;
    }

    @Override
    public boolean clientSide() {
        try {
            return FMLLoader.getDist().isClient();
        }
        catch (Throwable t2) {
            WaterMedia.LOGGER.error(IT, "Cannot check if was client, assuming it was");
            return true;
        }
    }

    @Override
    public boolean developerMode() {
        try {
            return !FMLLoader.isProduction();
        }
        catch (Throwable t) {
            WaterMedia.LOGGER.error(IT, "Cannot check if was developer env, assuming it wasn't");
            return false;
        }
    }

    private String concatPackage(String ... pgk) {
        StringBuilder r = new StringBuilder();
        for (String s : pgk) {
            r.append(s).append(".");
        }
        if (r.length() > 0) {
            r.setLength(r.length() - 1);
        }
        return r.toString();
    }
}

