/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.fixers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.lib720.kiulian.downloader.YoutubeDownloader;
import me.lib720.kiulian.downloader.downloader.request.RequestVideoInfo;
import me.lib720.kiulian.downloader.model.videos.VideoDetails;
import me.lib720.kiulian.downloader.model.videos.VideoInfo;
import me.lib720.kiulian.downloader.model.videos.formats.AudioFormat;
import me.lib720.kiulian.downloader.model.videos.formats.VideoFormat;
import me.srrapero720.watermedia.api.network.twitch.StreamQuality;
import me.srrapero720.watermedia.api.url.fixers.URLFixer;

public class YoutubeFixer
extends URLFixer {
    private static final YoutubeDownloader DOWNLOADER = new YoutubeDownloader();
    private static final Pattern PATTERN = Pattern.compile("(?:youtu\\.be/|youtube\\.com/(?:embed/|v/|shorts/|feeds/api/videos/|watch\\?v=|watch\\?.+&v=))([^/?&#]+)");

    @Override
    public String platform() {
        return "Youtube";
    }

    @Override
    public boolean isValid(URL url) {
        return url.getHost().endsWith("youtube.com") || url.getHost().endsWith("youtu.be");
    }

    @Override
    public URLFixer.Result patch(URL url, URLFixer.Quality preferQuality) throws URLFixer.FixingURLException {
        super.patch(url, preferQuality);
        Matcher matcher = PATTERN.matcher(url.toString());
        if (matcher.find()) {
            try {
                String videoId = matcher.group(1);
                VideoInfo videoInfo = DOWNLOADER.getVideoInfo(new RequestVideoInfo(videoId)).data();
                VideoDetails videoDetails = videoInfo.details();
                if (videoDetails.isLive()) {
                    String ytLivePlaylist = this.fetchLivePlaylist(videoDetails.liveUrl());
                    if (ytLivePlaylist != null) {
                        return new URLFixer.Result(new URL(StreamQuality.parse(ytLivePlaylist).get(0).getUrl()), true, true);
                    }
                } else {
                    VideoFormat bestAll = videoInfo.bestVideoWithAudioFormat();
                    if (bestAll != null) {
                        return new URLFixer.Result(new URL(bestAll.url()), true, false);
                    }
                    VideoFormat bestWithoutAudio = videoInfo.bestVideoFormat();
                    if (bestWithoutAudio != null) {
                        return new URLFixer.Result(new URL(bestWithoutAudio.url()), true, false);
                    }
                    AudioFormat bestWithoutVideo = videoInfo.bestAudioFormat();
                    if (bestWithoutVideo != null) {
                        return new URLFixer.Result(new URL(bestWithoutVideo.url()), true, false);
                    }
                    if (bestAll != null) {
                        return new URLFixer.Result(new URL(bestAll.url()), true, false);
                    }
                }
                return null;
            }
            catch (Exception e) {
                throw new URLFixer.FixingURLException(url.toString(), (Throwable)e);
            }
        }
        return null;
    }

    private String fetchLivePlaylist(String url) throws IOException {
        int length;
        URL apiUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)apiUrl.openConnection();
        conn.setRequestMethod("GET");
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            return null;
        }
        InputStream inputStream = conn.getInputStream();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }
}

