/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.fixers;

import java.net.URL;

public abstract class URLFixer {
    public String name() {
        return this.getClass().getSimpleName();
    }

    public abstract String platform();

    public abstract boolean isValid(URL var1);

    public Result patch(URL url, Quality prefQuality) throws FixingURLException {
        if (!this.isValid(url)) {
            throw new FixingURLException(url, (Throwable)new IllegalArgumentException("Attempt to build a invalid URL in a invalid Compat"));
        }
        return null;
    }

    public String toString() {
        return this.name();
    }

    public static final class FixingURLException
    extends Exception {
        public FixingURLException(String url, Throwable t) {
            super("Failed to fix URL " + url, t);
        }

        public FixingURLException(URL url, Throwable t) {
            super("Failed to fix URL " + url.toString(), t);
        }
    }

    public static enum Quality {
        LOWEST,
        LOW,
        MIDDLE,
        HIGH,
        HIGHEST;

    }

    public static class Result {
        public final URL url;
        public URL audioUrl;
        public final Quality quality;
        public final boolean assumeStream;
        public final boolean assumeVideo;

        public Result(URL url, boolean assumeVideo, boolean assumeStream) {
            this.url = url;
            this.quality = null;
            this.assumeVideo = assumeVideo;
            this.assumeStream = assumeStream;
        }

        public Result setAudioTrack(URL url) {
            this.audioUrl = url;
            return this;
        }

        public String toString() {
            return "Result{url=" + this.url + ", audioUrl=" + this.audioUrl + ", quality=" + (Object)((Object)this.quality) + ", assumeStream=" + this.assumeStream + ", assumeVideo=" + this.assumeVideo + '}';
        }
    }
}

