/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.fixers;

import java.net.URL;
import java.util.regex.Pattern;
import me.srrapero720.watermedia.api.network.onedrive.OneDriveUtil;
import me.srrapero720.watermedia.api.url.fixers.URLFixer;

public class OnedriveFixer
extends URLFixer {
    private static final Pattern ONE_DRIVE_URL_PATTERN = Pattern.compile("^https://1drv.ms/[a-z]/[a-zA-Z0-9!_-]+$");

    @Override
    public String platform() {
        return "OneDrive";
    }

    @Override
    public boolean isValid(URL url) {
        return ONE_DRIVE_URL_PATTERN.matcher(url.toString()).matches();
    }

    @Override
    public URLFixer.Result patch(URL url, URLFixer.Quality preferQuality) throws URLFixer.FixingURLException {
        super.patch(url, preferQuality);
        try {
            return new URLFixer.Result(new URL(OneDriveUtil.getDownloableItem(url.toString()).getUrl()), false, false);
        }
        catch (Exception e) {
            throw new URLFixer.FixingURLException(url.toString(), (Throwable)e);
        }
    }
}

