/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.fixers;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.srrapero720.watermedia.api.url.fixers.URLFixer;
import me.srrapero720.watermedia.core.tools.DataTool;
import me.srrapero720.watermedia.core.tools.NetTool;

public class LightshotFixer
extends URLFixer {
    private static final Pattern HTML_PATTERN = Pattern.compile("<img[^>]*class=\"no-click screenshot-image\"[^>]*src=\"(https://[^\"]+)\"");

    @Override
    public String platform() {
        return "Lightshot";
    }

    @Override
    public boolean isValid(URL url) {
        return url.getHost().equals("prnt.sc");
    }

    @Override
    public URLFixer.Result patch(URL url, URLFixer.Quality prefQuality) throws URLFixer.FixingURLException {
        super.patch(url, prefQuality);
        try {
            String html = this.connectToLightshot(url);
            Matcher matcher = HTML_PATTERN.matcher(html);
            if (matcher.find()) {
                return new URLFixer.Result(new URL(matcher.group(1)), false, false);
            }
            throw new NullPointerException("No match was found");
        }
        catch (Exception e) {
            throw new URLFixer.FixingURLException(url, (Throwable)e);
        }
    }

    public String connectToLightshot(URL url) throws IOException {
        HttpURLConnection conn = NetTool.connect(url, "GET");
        int code = conn.getResponseCode();
        switch (code) {
            case 404: {
                throw new NullPointerException("Image was not found");
            }
            case 401: 
            case 403: {
                throw new UnsupportedOperationException("Access denied by Lightshot");
            }
        }
        if (code != 200) {
            throw new UnsupportedOperationException("Lightshot responses with a unexpected status code: " + code);
        }
        try {
            String string;
            block14: {
                InputStream in = conn.getInputStream();
                try {
                    string = new String(DataTool.readAllBytes(in), StandardCharsets.UTF_8);
                    if (in == null) break block14;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return string;
        }
        finally {
            conn.disconnect();
        }
    }
}

