/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.url.fixers;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import me.srrapero720.watermedia.api.network.kick.KickChannel;
import me.srrapero720.watermedia.api.network.kick.KickVideo;
import me.srrapero720.watermedia.api.url.fixers.URLFixer;
import me.srrapero720.watermedia.core.tools.DataTool;
import me.srrapero720.watermedia.core.tools.NetTool;

public class KickFixer
extends URLFixer {
    private static final String API_URL = "https://kick.com/api/v1/";
    private static final Gson GSON = new Gson();

    @Override
    public String platform() {
        return "Kick";
    }

    @Override
    public boolean isValid(URL url) {
        return url.getHost().endsWith(".kick.com") || url.getHost().equals("kick.com");
    }

    @Override
    public URLFixer.Result patch(URL url, URLFixer.Quality prefQuality) throws URLFixer.FixingURLException {
        super.patch(url, prefQuality);
        try {
            if (url.getPath().contains("/video/")) {
                String videoID = url.getPath().replace("/video/", "");
                KickVideo video = this.getVideoInfo(videoID);
                return new URLFixer.Result(new URL(video.url), true, false);
            }
            String streamerName = url.getPath().replace("/", "");
            KickChannel channel = this.getChannelInfo(streamerName);
            if (channel.livestream == null || !channel.livestream.isStreaming) {
                throw new ConnectException("Streamer is not online");
            }
            return new URLFixer.Result(new URL(channel.url), true, true);
        }
        catch (Exception e) {
            throw new URLFixer.FixingURLException(url.toString(), (Throwable)e);
        }
    }

    public KickChannel getChannelInfo(String channel) throws IOException {
        try (InputStreamReader in = new InputStreamReader(this.getInputStream(new URL("https://kick.com/api/v1/channels/" + channel)));){
            KickChannel kickChannel = (KickChannel)GSON.fromJson((Reader)in, KickChannel.class);
            return kickChannel;
        }
    }

    public KickVideo getVideoInfo(String videoId) throws IOException {
        try (InputStreamReader in = new InputStreamReader(this.getInputStream(new URL("https://kick.com/api/v1/video/" + videoId)));){
            KickVideo kickVideo = (KickVideo)GSON.fromJson((Reader)in, KickVideo.class);
            return kickVideo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(URL url) throws IOException {
        HttpURLConnection connection = NetTool.connect(url, "GET");
        try {
            if (connection.getResponseCode() != 200) {
                throw new ConnectException(String.format("Server url %s response with status code (%s): %s", url, connection.getResponseCode(), connection.getResponseMessage()));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(DataTool.readAllBytes(connection.getInputStream()));
            return byteArrayInputStream;
        }
        finally {
            connection.disconnect();
        }
    }
}

