/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.watermedia.api.rendering;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import me.srrapero720.watermedia.api.WaterMediaAPI;
import me.srrapero720.watermedia.api.rendering.memory.MemoryAlloc;
import me.srrapero720.watermedia.loaders.ILoader;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.opengl.GL11;

public class RenderAPI
extends WaterMediaAPI {
    public static final Marker IT = MarkerManager.getMarker((String)RenderAPI.class.getSimpleName());

    public static ByteBuffer createByteBuffer(int size) {
        return MemoryAlloc.create(size);
    }

    public static ByteBuffer resizeByteBuffer(ByteBuffer buffer, int newSize) {
        return MemoryAlloc.resize(buffer, newSize);
    }

    public static void freeByteBuffer(ByteBuffer buffer) {
        MemoryAlloc.free(buffer);
    }

    public static BufferedImage convertImageFormat(BufferedImage originalImage) {
        if (originalImage.getType() == 2) {
            return originalImage;
        }
        BufferedImage newImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 2);
        Graphics g = newImage.getGraphics();
        g.drawImage(originalImage, 0, 0, null);
        g.dispose();
        return newImage;
    }

    public static ByteBuffer[] getRawImageBuffer(BufferedImage[] images) {
        ByteBuffer[] buffers = new ByteBuffer[images.length];
        for (int i = 0; i < images.length; ++i) {
            buffers[i] = RenderAPI.getRawImageBuffer(images[i]);
        }
        return buffers;
    }

    public static ByteBuffer getRawImageBuffer(BufferedImage image) {
        image = RenderAPI.convertImageFormat(image);
        int[] pixels = ((DataBufferInt)RenderAPI.convertImageFormat(image).getRaster().getDataBuffer()).getData();
        ByteBuffer buffer = RenderAPI.createByteBuffer(image.getWidth() * image.getHeight() * 4);
        buffer.asIntBuffer().put(pixels);
        ((Buffer)buffer).flip();
        return buffer;
    }

    public static int uploadBufferTexture(ByteBuffer image, int width, int height) {
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)32993, (int)33639, (ByteBuffer)image);
        return textureID;
    }

    public static int uploadBufferTexture(IntBuffer image, int width, int height) {
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)image);
        return textureID;
    }

    @Deprecated(forRemoval=true)
    public static int applyBuffer(BufferedImage image, int width, int height) {
        image = RenderAPI.convertImageFormat(image);
        int[] pixels = ((DataBufferInt)RenderAPI.convertImageFormat(image).getRaster().getDataBuffer()).getData();
        ByteBuffer buffer = RenderAPI.createByteBuffer(width * height * 4);
        buffer.asIntBuffer().put(pixels);
        ((Buffer)buffer).flip();
        int textureID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)32993, (int)33639, (ByteBuffer)buffer);
        return textureID;
    }

    @Deprecated(forRemoval=true)
    public static void applyBuffer(IntBuffer videoBuffer, int glTexture, int videoWidth, int videoHeight, boolean firstFrame) {
        GL11.glBindTexture((int)3553, (int)glTexture);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        if (firstFrame) {
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)videoWidth, (int)videoHeight, (int)0, (int)6408, (int)5121, (IntBuffer)videoBuffer);
        } else {
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)videoWidth, (int)videoHeight, (int)6408, (int)5121, (IntBuffer)videoBuffer);
        }
    }

    public static void applyBuffer(ByteBuffer videoBuffer, int glTexture, int videoWidth, int videoHeight, boolean firstFrame) {
        GL11.glBindTexture((int)3553, (int)glTexture);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glPixelStorei((int)3314, (int)0);
        GL11.glPixelStorei((int)3316, (int)0);
        GL11.glPixelStorei((int)3315, (int)0);
        if (firstFrame) {
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)videoWidth, (int)videoHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)videoBuffer);
        } else {
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)videoWidth, (int)videoHeight, (int)6408, (int)5121, (ByteBuffer)videoBuffer);
        }
    }

    public static ByteBuffer getTextureBuffer(int textureId, int width, int height) {
        ByteBuffer buffer = RenderAPI.createByteBuffer(width * height * 4);
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glGetTexImage((int)textureId, (int)0, (int)32993, (int)33639, (ByteBuffer)buffer);
        return buffer;
    }

    public static void deleteTexture(int texture) {
        GL11.glDeleteTextures((int)texture);
    }

    public static void deleteTexture(int[] textures) {
        GL11.glDeleteTextures((int[])textures);
    }

    @Override
    public WaterMediaAPI.Priority priority() {
        return WaterMediaAPI.Priority.LOW;
    }

    @Override
    public boolean prepare(ILoader bootCore) throws Exception {
        return true;
    }

    @Override
    public void start(ILoader bootCore) throws Exception {
    }

    @Override
    public void release() {
    }
}

