/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.tukaani.xz;

import java.io.InputStream;
import me.lib720.tukaani.xz.ArrayCache;
import me.lib720.tukaani.xz.DeltaEncoder;
import me.lib720.tukaani.xz.DeltaInputStream;
import me.lib720.tukaani.xz.DeltaOutputStream;
import me.lib720.tukaani.xz.FilterEncoder;
import me.lib720.tukaani.xz.FilterOptions;
import me.lib720.tukaani.xz.FinishableOutputStream;
import me.lib720.tukaani.xz.UnsupportedOptionsException;

public class DeltaOptions
extends FilterOptions {
    public static final int DISTANCE_MIN = 1;
    public static final int DISTANCE_MAX = 256;
    private int distance = 1;

    public DeltaOptions() {
    }

    public DeltaOptions(int n) throws UnsupportedOptionsException {
        this.setDistance(n);
    }

    public void setDistance(int n) throws UnsupportedOptionsException {
        if (n < 1 || n > 256) {
            throw new UnsupportedOptionsException("Delta distance must be in the range [1, 256]: " + n);
        }
        this.distance = n;
    }

    public int getDistance() {
        return this.distance;
    }

    @Override
    public int getEncoderMemoryUsage() {
        return DeltaOutputStream.getMemoryUsage();
    }

    @Override
    public FinishableOutputStream getOutputStream(FinishableOutputStream finishableOutputStream, ArrayCache arrayCache) {
        return new DeltaOutputStream(finishableOutputStream, this);
    }

    @Override
    public int getDecoderMemoryUsage() {
        return 1;
    }

    @Override
    public InputStream getInputStream(InputStream inputStream, ArrayCache arrayCache) {
        return new DeltaInputStream(inputStream, this.distance);
    }

    @Override
    FilterEncoder getFilterEncoder() {
        return new DeltaEncoder(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            throw new RuntimeException();
        }
    }
}

