/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.discovery.strategy;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.lib720.caprica.vlcj.discovery.NativeDiscovery;
import me.lib720.caprica.vlcj.discovery.strategy.NativeDiscoveryStrategy;

public abstract class BaseNativeDiscoveryStrategy
implements NativeDiscoveryStrategy {
    protected static final String PLUGIN_ENV_NAME = "VLC_PLUGIN_PATH";
    private final Pattern[] patternsToMatch;
    private final String[] pluginPathFormats;

    public BaseNativeDiscoveryStrategy(String[] filenamePatterns, String[] pluginPathFormats) {
        this.patternsToMatch = new Pattern[filenamePatterns.length];
        for (int i = 0; i < filenamePatterns.length; ++i) {
            this.patternsToMatch[i] = Pattern.compile(filenamePatterns[i]);
        }
        this.pluginPathFormats = pluginPathFormats;
    }

    @Override
    public final String discover() {
        for (String discoveryDirectory : this.discoveryDirectories()) {
            String discoveredDirectory = this.find(discoveryDirectory);
            if (discoveredDirectory == null) continue;
            return discoveredDirectory;
        }
        return null;
    }

    protected abstract List<String> discoveryDirectories();

    private static File getSymLinkPathOrSelf(Path path) {
        if (!Files.isSymbolicLink(path)) {
            return path.toFile();
        }
        try {
            File symLink = Files.readSymbolicLink(path).toFile();
            if (symLink.isDirectory()) {
                NativeDiscovery.LOGGER.warn(NativeDiscovery.IT, "Path '{}' is a directory symlink to '{}'", (Object)path.toString(), (Object)symLink.toPath());
            } else {
                NativeDiscovery.LOGGER.warn(NativeDiscovery.IT, "Path '{}' is a file symlink to '{}'", (Object)path.toString(), (Object)symLink.toPath());
            }
            return symLink;
        }
        catch (Exception exception) {
            return path.toFile();
        }
    }

    private String find(String directoryName) {
        File rootFile = new File(directoryName);
        File[] rootFolder = BaseNativeDiscoveryStrategy.getSymLinkPathOrSelf(rootFile.toPath()).listFiles();
        if (rootFolder == null) {
            NativeDiscovery.LOGGER.debug(NativeDiscovery.IT, "Cannot search on '{}', exists: {} - isDirectory: {} - canRead: {} - canExecute: {} ", (Object)directoryName, (Object)rootFile.exists(), (Object)rootFile.isDirectory(), (Object)rootFile.canRead(), (Object)rootFile.canExecute());
            return null;
        }
        NativeDiscovery.LOGGER.info(NativeDiscovery.IT, "Searching on '{}'", (Object)directoryName);
        HashSet<String> matches = new HashSet<String>(this.patternsToMatch.length);
        for (File mainFile : rootFolder) {
            if (mainFile.isDirectory()) continue;
            for (Pattern pattern : this.patternsToMatch) {
                Matcher matcher = pattern.matcher(mainFile.getName());
                if (!matcher.matches()) continue;
                matches.add(pattern.pattern());
                if (matches.size() != this.patternsToMatch.length) continue;
                return directoryName;
            }
        }
        for (File mainFile : rootFolder) {
            File[] subFolders = (mainFile = BaseNativeDiscoveryStrategy.getSymLinkPathOrSelf(mainFile.toPath())).listFiles();
            if (subFolders == null) {
                return null;
            }
            if (subFolders.length > 16) {
                NativeDiscovery.LOGGER.debug(NativeDiscovery.IT, "Skipped subdirectory '{}', contains more than 16 entries", (Object)mainFile.toString());
                continue;
            }
            NativeDiscovery.LOGGER.info(NativeDiscovery.IT, "Searching on subdirectory '{}'", (Object)mainFile.toString());
            HashSet<String> subMatches = new HashSet<String>(this.patternsToMatch.length);
            for (File subFile : subFolders) {
                for (Pattern pattern : this.patternsToMatch) {
                    Matcher matcher = pattern.matcher(subFile.getName());
                    if (!matcher.matches()) continue;
                    subMatches.add(pattern.pattern());
                    if (subMatches.size() != this.patternsToMatch.length) continue;
                    return mainFile.toPath().toAbsolutePath().toString();
                }
            }
        }
        return null;
    }

    @Override
    public boolean onFound(String path) {
        return true;
    }

    @Override
    public final boolean onSetPluginPath(String path) {
        for (String pathFormat : this.pluginPathFormats) {
            String pluginPath;
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (!new File(pluginPath = String.format(pathFormat, path)).exists()) continue;
            return this.setPluginPath(pluginPath);
        }
        return false;
    }

    protected abstract boolean setPluginPath(String var1);
}

