/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import java.io.File;
import java.net.URL;
import me.lib720.caprica.vlcj.binding.internal.libvlc_instance_t;
import me.lib720.caprica.vlcj.binding.internal.libvlc_media_t;
import me.lib720.caprica.vlcj.binding.lib.LibC;
import me.lib720.caprica.vlcj.binding.lib.LibVlc;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VideoLan4J {
    public static final Logger LOGGER = LogManager.getLogger((String)"VideoLan4J");
    public static final String LIBVLC_NAME = Platform.isWindows() ? "libvlc" : "vlc";
    public static final String LIBVLCCORE_NAME = Platform.isWindows() ? "libvlccore" : "vlccore";
    public static final int PID = Platform.isWindows() ? Kernel32.INSTANCE.GetCurrentProcessId() : LibC.INSTANCE.getpid();

    public static libvlc_media_t getMediaInstance(libvlc_instance_t vlc, URL url) {
        String mrl = url.toString();
        if (mrl.startsWith("file:/") && !mrl.startsWith("file:///")) {
            mrl = mrl.replace("file:/", "file:///");
        }
        return LibVlc.libvlc_media_new_location(vlc, mrl);
    }

    public static libvlc_media_t getMediaInstance(libvlc_instance_t vlc, File url) {
        return LibVlc.libvlc_media_new_location(vlc, url.toString());
    }

    public static void checkClassLoader(ClassLoader classLoader) {
        Thread t = Thread.currentThread();
        if (t.getContextClassLoader() == null) {
            t.setContextClassLoader(classLoader);
        }
    }

    public static String copyAndFreeNativeString(Pointer pointer) {
        try {
            String string = VideoLan4J.copyNativeString(pointer);
            return string;
        }
        finally {
            VideoLan4J.freeNativeString(pointer);
        }
    }

    public static void freeNativeString(Pointer pointer) {
        if (pointer != null) {
            LibVlc.libvlc_free(pointer);
        }
    }

    public static String copyNativeString(Pointer pointer) {
        return pointer != null ? pointer.getString(0L) : null;
    }
}

