/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world.gen.feature;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.common.Tags;
import untamedwilds.config.ConfigFeatureControl;
import untamedwilds.init.ModBlock;

public class FeatureUnderwaterAlgae
extends Feature<NoneFeatureConfiguration> {
    public FeatureUnderwaterAlgae(Codec<NoneFeatureConfiguration> p_i231988_1_) {
        super(p_i231988_1_);
    }

    public boolean m_142674_(FeaturePlaceContext context) {
        BlockState blockstate;
        RandomSource rand = context.m_159774_().m_213780_();
        BlockPos pos = context.m_159777_();
        WorldGenLevel world = context.m_159774_();
        if (((List)ConfigFeatureControl.dimensionFeatureBlacklist.get()).contains(world.m_6018_().m_46472_().m_135782_().toString())) {
            return false;
        }
        boolean flag = false;
        int i = rand.m_188503_(8) - rand.m_188503_(8);
        int j = rand.m_188503_(8) - rand.m_188503_(8);
        int k = world.m_6924_(Heightmap.Types.OCEAN_FLOOR, pos.m_123341_() + i, pos.m_123343_() + j);
        BlockPos blockpos = new BlockPos(pos.m_123341_() + i, k, pos.m_123343_() + j);
        Pair<Block, Integer> algae = AlgaeTypes.getAlgaeForPos(world, blockpos);
        if (world.m_8055_(blockpos).m_60713_(Blocks.f_49990_) && algae != null && (blockstate = ((Block)algae.getFirst()).m_49966_()).m_60710_((LevelReader)world, blockpos)) {
            world.m_7731_(blockpos, blockstate, 2);
            flag = true;
        }
        return flag;
    }

    public static enum AlgaeTypes {
        AMAZON_SWORD((Block)ModBlock.AMAZON_SWORD.get(), 4, (Boolean)ConfigFeatureControl.addAlgae.get(), 6, new TagKey[]{Tags.Biomes.IS_SWAMP, BiomeTags.f_207610_}),
        EELGRASS((Block)ModBlock.EELGRASS.get(), 4, (Boolean)ConfigFeatureControl.addAlgae.get(), 6, new TagKey[]{BiomeTags.f_207603_});

        public Block type;
        public int rarity;
        public boolean enabled;
        public int size;
        public TagKey<Biome>[] spawnBiomes;

        private AlgaeTypes(Block type, int rolls, boolean add, int size, TagKey<Biome>[] biomes) {
            this.type = type;
            this.rarity = rolls;
            this.enabled = add;
            this.spawnBiomes = biomes;
            this.size = size;
        }

        public static Pair<Block, Integer> getAlgaeForPos(WorldGenLevel world, BlockPos pos) {
            Optional optional = world.m_204166_(pos).m_203543_();
            if (Objects.equals(optional, Optional.of(Biomes.f_48211_)) || Objects.equals(optional, Optional.of(Biomes.f_48172_))) {
                return null;
            }
            Holder biome = world.m_204166_(pos);
            ArrayList<AlgaeTypes> types = new ArrayList<AlgaeTypes>();
            for (AlgaeTypes type : AlgaeTypes.values()) {
                if (!type.enabled) continue;
                for (TagKey<Biome> biomeTypes : type.spawnBiomes) {
                    if (!biome.m_203656_(biomeTypes)) continue;
                    for (int i = 0; i < type.rarity; ++i) {
                        types.add(type);
                    }
                }
            }
            if (!types.isEmpty()) {
                int i = new Random().nextInt(types.size());
                return new Pair((Object)((AlgaeTypes)((Object)types.get((int)i))).type, (Object)((AlgaeTypes)((Object)types.get((int)i))).size);
            }
            return null;
        }
    }
}

