/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.reptile;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import oshi.util.tuples.Pair;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAmphibious;
import untamedwilds.entity.INestingMob;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.AmphibiousRandomSwimGoal;
import untamedwilds.entity.ai.AmphibiousTransition;
import untamedwilds.entity.ai.LayEggsOnNestGoal;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.control.look.SmartSwimmerLookControl;
import untamedwilds.entity.ai.control.movement.SmartSwimmingMoveControl;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModItems;
import untamedwilds.init.ModTags;
import untamedwilds.util.EntityUtils;

public class EntitySoftshellTurtle
extends ComplexMobAmphibious
implements ISpecies,
INewSkins,
INestingMob {
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(EntitySoftshellTurtle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean hasExtendedNeck;
    public int extendNeckProgress;
    public Pair<Float, Float> head_movement;
    private float neck_val = 0.0f;
    private float head_val = 0.0f;

    public EntitySoftshellTurtle(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new SmartSwimmingMoveControl((Mob)this, 60, 10, 0.6f, 0.25f, true);
        this.f_21365_ = new SmartSwimmerLookControl(this, 20);
        this.head_movement = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22279_, 0.7).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new SmartMateGoal(this, 0.7));
        this.f_21345_.m_25352_(2, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.0, 1.1, input -> EntitySoftshellTurtle.getEcoLevel(input) > EntitySoftshellTurtle.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(3, (Goal)new LayEggsOnNestGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AmphibiousTransition(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new AmphibiousRandomSwimGoal(this, 0.7, 40));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, 30, false, input -> EntitySoftshellTurtle.getEcoLevel(input) < EntitySoftshellTurtle.getEcoLevel((LivingEntity)this)));
    }

    @Override
    public boolean wantsToBeOnLand() {
        return this.m_9236_().m_46468_() > 4500L && this.m_9236_().m_46468_() < 7500L;
    }

    @Override
    public boolean wantsToBeInWater() {
        return this.m_9236_().m_46468_() <= 4500L || this.m_9236_().m_46468_() >= 7500L;
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public void m_6667_(DamageSource cause) {
        ItemEntity entityitem;
        if (cause.m_269533_(DamageTypeTags.f_268467_) && !this.m_6162_() && (entityitem = this.m_5552_(new ItemStack((ItemLike)ModItems.FOOD_TURTLE_SOUP.get()), 0.2f)) != null) {
            entityitem.m_32055_().m_41764_(1);
        }
        super.m_6667_(cause);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.m_20069_() && this.m_20184_().m_82556_() > 0.03) {
            Vec3 vec3 = this.m_20252_(0.0f);
            float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
            float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
            float f2 = 1.2f - this.f_19796_.m_188501_() * 0.7f;
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vec3.f_82479_ * (double)f2 + (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vec3.f_82479_ * (double)f2 - (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            }
        }
        if (this.f_19797_ % 1000 == 0) {
            this.hasExtendedNeck = this.f_19796_.m_188499_();
        }
        if (this.f_19797_ % 120 < 11) {
            if (this.f_19797_ % 120 == 1) {
                this.neck_val = (float)((double)0.8f - this.f_19796_.m_188500_() * (double)1.6f);
                this.head_val = (float)((double)0.4f - this.f_19796_.m_188500_() * (double)0.8f);
            }
            this.head_movement = new Pair((Object)Float.valueOf(Mth.m_14179_((float)0.1f, (float)((Float)this.head_movement.getA()).floatValue(), (float)this.neck_val)), (Object)Float.valueOf(Mth.m_14179_((float)0.1f, (float)((Float)this.head_movement.getB()).floatValue(), (float)this.head_val)));
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.m_9236_().m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
            if (this.m_20069_() && this.m_21573_().m_26571_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.003, 0.0));
            }
        } else if ((!this.m_20069_() || this.hasExtendedNeck) && this.extendNeckProgress < 100) {
            ++this.extendNeckProgress;
        } else if ((this.m_20069_() || !this.hasExtendedNeck) && this.extendNeckProgress > 0) {
            --this.extendNeckProgress;
        }
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.m_5803_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.m_9236_().m_45976_(EntitySoftshellTurtle.class, this.m_20191_().m_82377_(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            return list.size() >= 1;
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityUtils.dropEggs(this, "egg_softshell_turtle", this.getOffspring());
        return null;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_41619_() && this.m_6084_()) {
            EntityUtils.turnEntityIntoItem((LivingEntity)this, "spawn_softshell_turtle");
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        SoundEvent soundevent = this.m_6162_() ? SoundEvents.f_12488_ : SoundEvents.f_12487_;
        this.m_5496_(soundevent, 0.15f, 1.0f);
    }

    @Override
    public boolean wantsToLayEggs() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    @Override
    public void setEggStatus(boolean status) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)status);
    }

    @Override
    public Block getNestType() {
        return (Block)ModBlock.NEST_REPTILE.get();
    }

    @Override
    public boolean isValidNestBlock(BlockPos pos) {
        return this.m_9236_().m_46859_(pos) && this.m_9236_().m_8055_(pos.m_7495_()).m_204336_(ModTags.ModBlockTags.VALID_REPTILE_NEST) && this.getNestType().m_49966_().m_60710_((LevelReader)this.m_9236_(), pos);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("has_egg", this.wantsToLayEggs());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setEggStatus(compound.m_128471_("has_egg"));
    }
}

