/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.unique.BaleenWhaleFeedGoal;
import untamedwilds.entity.ai.unique.WhaleBreachGoal;
import untamedwilds.entity.ai.unique.WhaleSwimmingGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.util.EntityUtils;

public class EntityBaleenWhale
extends ComplexMobAquatic
implements ISpecies,
INewSkins,
INeedsPostUpdate {
    private static final EntityDataAccessor<Boolean> IS_EATING = SynchedEntityData.m_135353_(EntityBaleenWhale.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LONG_FINS = SynchedEntityData.m_135353_(EntityBaleenWhale.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int length;
    public EntityWhalePart[] whale_parts;
    public int ringBufferIndex = -1;
    public final double[][] ringBuffer = new double[64][3];
    public int gulpProgress;

    public EntityBaleenWhale(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_19804_.m_135372_(LONG_FINS, (Object)false);
        this.length = this.getMultiparts();
        this.whale_parts = new EntityWhalePart[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.whale_parts[i] = new EntityWhalePart(this, this.m_20205_(), this.m_20206_());
        }
        this.turn_speed = 0.03f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_EATING, (Object)false);
    }

    private void setPartPosition(EntityWhalePart part, double offsetX, double offsetY, double offsetZ) {
        part.m_6034_(this.m_20185_() + offsetX * (double)part.scale, this.m_20186_() + offsetY * (double)part.scale, this.m_20189_() + offsetZ * (double)part.scale);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.whale_parts;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 1.6).m_22268_(Attributes.f_22279_, 0.8).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 6.0);
    }

    @Override
    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.3, false));
        this.f_21345_.m_25352_(2, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WhaleSwimmingGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WhaleBreachGoal(this, 10));
        this.f_21345_.m_25352_(5, (Goal)new BaleenWhaleFeedGoal(this, 400));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46467_() % 4000L == 0L) {
            this.m_5634_(1.0f);
        }
        if (!this.m_21525_() && !this.m_6162_()) {
            if (this.ringBufferIndex < 0) {
                for (int i = 0; i < this.ringBuffer.length; ++i) {
                    this.ringBuffer[i][0] = this.m_146908_();
                    this.ringBuffer[i][1] = this.m_20186_();
                }
            }
            ++this.ringBufferIndex;
            if (this.ringBufferIndex == this.ringBuffer.length) {
                this.ringBufferIndex = 0;
            }
            this.ringBuffer[this.ringBufferIndex][0] = this.f_19859_ + 0.5f * Mth.m_14177_((float)(this.m_146908_() - this.f_19859_));
            this.ringBuffer[this.ringBufferIndex][1] = this.m_20186_();
            Vec3[] avector3d = new Vec3[this.whale_parts.length];
            for (int j = 0; j < this.whale_parts.length; ++j) {
                this.whale_parts[j].collideWithNearbyEntities();
                avector3d[j] = new Vec3(this.whale_parts[j].m_20185_(), this.whale_parts[j].m_20186_(), this.whale_parts[j].m_20189_());
            }
            float f15 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
            float f16 = Mth.m_14089_((float)f15);
            float yaw = this.m_146908_() * ((float)Math.PI / 180);
            float pitch = this.m_146909_() * ((float)Math.PI / 180);
            float f3 = Mth.m_14031_((float)yaw) * (1.0f - Math.abs(this.m_146909_() / 90.0f));
            float f18 = Mth.m_14089_((float)yaw) * (1.0f - Math.abs(this.m_146909_() / 90.0f));
            double[] adouble = this.getMovementOffsets(5, 1.0f);
            float var = 1.0f;
            for (int k = 0; k < this.getMultiparts(); ++k) {
                float offset;
                EntityWhalePart whale_part = this.whale_parts[k];
                double[] adouble1 = this.getMovementOffsets(5 + k * 2, 1.0f);
                float f7 = yaw + (float)Mth.m_14175_((double)(adouble1[0] - adouble[0])) * ((float)Math.PI / 180);
                float f20 = Mth.m_14031_((float)f7) * (1.0f - Math.abs(this.m_146909_() / 90.0f));
                float f21 = Mth.m_14089_((float)f7) * (1.0f - Math.abs(this.m_146909_() / 90.0f));
                float f = offset = k % 2 == 0 ? -1.0f : 1.0f;
                if (k % 2 == 0) {
                    var += 1.0f;
                }
                float f23 = var * 1.5f * offset;
                float value = Mth.m_14036_((float)(pitch * (float)k), (float)((float)Math.toRadians(-40.0)), (float)((float)Math.toRadians(40.0)));
                this.setPartPosition(whale_part, -((double)f3 * 0.5 + (double)(f20 * f23)) * (double)f16, value * -offset, ((double)f18 * 0.5 + (double)(f21 * f23)) * (double)f16);
                this.whale_parts[k].f_19854_ = avector3d[k].f_82479_;
                this.whale_parts[k].f_19855_ = avector3d[k].f_82480_;
                this.whale_parts[k].f_19856_ = avector3d[k].f_82481_;
                this.whale_parts[k].f_19790_ = avector3d[k].f_82479_;
                this.whale_parts[k].f_19791_ = avector3d[k].f_82480_;
                this.whale_parts[k].f_19792_ = avector3d[k].f_82481_;
            }
        }
        if (this.m_9236_().f_46443_ && this.isFeeding() && this.gulpProgress < 50) {
            ++this.gulpProgress;
        } else if (this.m_9236_().f_46443_ && !this.isFeeding() && this.gulpProgress > 0) {
            --this.gulpProgress;
        }
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12004_;
    }

    public double[] getMovementOffsets(int offset, float partialTicks) {
        if (this.m_21224_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - offset & 0x3F;
        int j = this.ringBufferIndex - offset - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = this.ringBuffer[j][0] - d0;
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = Mth.m_14139_((double)0.5, (double)this.ringBuffer[i][2], (double)this.ringBuffer[j][2]);
        return adouble;
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.m_5803_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.m_9236_().m_45976_(EntityBaleenWhale.class, this.m_20191_().m_82377_(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.m_146762_(this.getPregnancyTime());
                ((EntityBaleenWhale)list.get(0)).m_146762_(this.getPregnancyTime());
                return true;
            }
        }
        return false;
    }

    public boolean hasLongFins() {
        return (Boolean)this.f_19804_.m_135370_(LONG_FINS);
    }

    private void setLongFins(boolean long_fins) {
        this.f_19804_.m_135381_(LONG_FINS, (Object)long_fins);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasLongFins", this.hasLongFins());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setLongFins(compound.m_128471_("hasLongFins"));
    }

    @Override
    public void updateAttributes() {
        this.m_21153_(this.m_21233_());
        this.length = this.getMultiparts();
        this.whale_parts = new EntityWhalePart[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.whale_parts[i] = new EntityWhalePart(this, this.m_20205_(), this.m_20206_());
        }
        this.setLongFins(EntityBaleenWhale.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "hasLongFins") == 1);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return this.create_offspring(new EntityBaleenWhale((EntityType<? extends ComplexMob>)((EntityType)ModEntity.BALEEN_WHALE.get()), this.m_9236_()));
    }

    public boolean attackEntityPartFrom(EntityWhalePart whale_part, DamageSource source, float amount) {
        return this.m_6469_(source, amount);
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && !this.m_9236_().m_5776_() && itemstack.m_41720_() == Items.f_42585_) {
            this.setFeeding(!this.isFeeding());
        }
        return super.m_6071_(player, hand);
    }

    public int getMultiparts() {
        return 3 + (int)((this.getModelScale() - 1.0f) * 4.0f);
    }

    @Override
    public boolean canBeTargeted() {
        return false;
    }

    public boolean isFeeding() {
        return (Boolean)this.f_19804_.m_135370_(IS_EATING);
    }

    public void setFeeding(boolean bool) {
        this.f_19804_.m_135381_(IS_EATING, (Object)bool);
    }

    public static class EntityWhalePart
    extends PartEntity<EntityBaleenWhale> {
        private final EntityDimensions size;
        public float scale = 1.0f;

        public EntityWhalePart(EntityBaleenWhale parent, float sizeX, float sizeY) {
            super((Entity)parent);
            this.size = EntityDimensions.m_20395_((float)sizeX, (float)sizeY);
            this.m_6210_();
        }

        protected void collideWithNearbyEntities() {
            List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_((double)0.2f, 0.0, (double)0.2f));
            Entity parent = this.getParent();
            if (parent != null) {
                entities.stream().filter(entity -> entity != parent && (!(entity instanceof EntityWhalePart) || ((EntityWhalePart)((Object)entity)).getParent() != parent) && entity.m_6094_()).forEach(entity -> entity.m_7334_(parent));
            }
        }

        public InteractionResult mobInteract(Player player, InteractionHand hand) {
            return this.getParent() == null ? InteractionResult.PASS : ((EntityBaleenWhale)this.getParent()).m_6071_(player, hand);
        }

        public void m_7334_(Entity entityIn) {
            entityIn.m_7334_((Entity)this);
        }

        public boolean m_5829_() {
            return true;
        }

        public boolean m_6469_(DamageSource source, float amount) {
            return !this.m_6673_(source) && ((EntityBaleenWhale)this.getParent()).attackEntityPartFrom(this, source, amount);
        }

        protected void m_8097_() {
        }

        protected void m_7378_(CompoundTag compound) {
        }

        protected void m_7380_(CompoundTag compound) {
        }

        public boolean m_7306_(Entity entityIn) {
            return this == entityIn || this.getParent() == entityIn;
        }

        public Packet<ClientGamePacketListener> m_5654_() {
            throw new UnsupportedOperationException();
        }

        public EntityDimensions getSize(Pose poseIn) {
            return this.size.m_20388_(this.scale);
        }
    }
}

