/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.fish;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.MeleeAttackCircle;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.target.HuntWoundedTarget;
import untamedwilds.entity.ai.target.SmartHurtByTargetGoal;
import untamedwilds.entity.ai.unique.SharkSwimmingGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.init.ModItems;
import untamedwilds.util.EntityUtils;

public class EntityShark
extends ComplexMobAquatic
implements ISpecies,
IAnimatedEntity,
INeedsPostUpdate,
INewSkins {
    private static final EntityDataAccessor<Boolean> SHORT_FINS = SynchedEntityData.m_135353_(EntityShark.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static Animation ATTACK_THRASH;
    private int animationTick;
    private Animation currentAnimation;
    public int posPointer = -1;
    public final double[][] positions = new double[64][3];

    public EntityShark(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        ATTACK_THRASH = Animation.create((int)15);
        this.turn_speed = 0.3f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHORT_FINS, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22282_, 1.4).m_22268_(Attributes.f_22279_, 0.8).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22276_, 50.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackCircle((PathfinderMob)this, 2.3, false, 2.0f));
        this.f_21345_.m_25352_(3, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new SharkSwimmingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new SmartHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new HuntWoundedTarget<LivingEntity>(this, LivingEntity.class, true));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (!this.m_9236_().f_46443_) {
            this.setAngry(this.m_5448_() != null);
            if (this.f_19797_ % 1000 == 0 && this.wantsToBreed() && !this.isMale()) {
                this.m_146762_(this.getPregnancyTime());
            }
            if (this.m_9236_().m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
        }
        if (!this.m_21525_() && !this.m_6162_()) {
            if (this.posPointer < 0) {
                for (int i = 0; i < this.positions.length; ++i) {
                    this.positions[i][0] = this.m_146908_();
                    this.positions[i][1] = this.m_20186_();
                }
            }
            ++this.posPointer;
            if (this.posPointer == this.positions.length) {
                this.posPointer = 0;
            }
            this.positions[this.posPointer][0] = this.m_146908_();
            this.positions[this.posPointer][1] = this.m_146909_();
        }
    }

    public double getMovementOffsets(int offset, float partialTicks, int value) {
        if (this.m_21224_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.posPointer - offset & 0x3F;
        int j = this.posPointer - offset - 1 & 0x3F;
        double d0 = this.positions[i][value];
        double d1 = this.positions[j][value] - d0;
        return d0 + d1 * (double)partialTicks;
    }

    @Override
    protected void handleOutOfWaterBehavior() {
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_ && this.f_19796_.m_188503_(60) == 1) {
            List entitiesHit = this.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_(), (LivingEntity)this, this.m_20191_().m_82400_((double)1.2f));
            for (LivingEntity entityHit : entitiesHit) {
                if (entityHit.equals((Object)this) || !this.m_142582_((Entity)entityHit)) continue;
                this.m_7327_((Entity)entityHit);
            }
            this.setAnimation(ATTACK_THRASH);
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 4.0f - 2.0f) * 0.1f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 4.0f - 2.0f) * 0.1f)));
            this.m_6853_(false);
            this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.m_9236_().m_45976_(EntityShark.class, this.m_20191_().m_82377_(12.0, 8.0, 12.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.m_146762_(this.getPregnancyTime());
                ((EntityShark)list.get(0)).m_146762_(this.getPregnancyTime());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return this.create_offspring(new EntityShark((EntityType<? extends ComplexMob>)((EntityType)ModEntity.SHARK.get()), this.m_9236_()));
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_11760_;
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.m_6162_()) {
            if (this.m_217043_().m_188503_(3) == 0) {
                this.m_5552_(new ItemStack((ItemLike)ModItems.MATERIAL_SHARK_TOOTH.get()), 0.2f);
            }
            this.setAnimation(ATTACK_THRASH);
        }
        return flag;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ATTACK_THRASH};
    }

    public boolean isBottomDweller() {
        return EntityShark.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "bottomDweller") == 1;
    }

    @Override
    public void updateAttributes() {
        this.m_21051_(Attributes.f_22281_).m_22100_((double)EntityShark.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.m_21051_(Attributes.f_22276_).m_22100_((double)EntityShark.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.m_21153_(this.m_21233_());
        this.setShortFins(EntityShark.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "shortFins") == 1);
    }

    public boolean hasShortFins() {
        return (Boolean)this.f_19804_.m_135370_(SHORT_FINS);
    }

    private void setShortFins(boolean short_fins) {
        this.f_19804_.m_135381_(SHORT_FINS, (Object)short_fins);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasShortFins", this.hasShortFins());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setShortFins(compound.m_128471_("hasShortFins"));
    }
}

