/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ai.control.movement.SmartSwimmingMoveControl;
import untamedwilds.util.EntityUtils;

public abstract class ComplexMobTerrestrial
extends ComplexMob
implements IAnimatedEntity {
    public int sitProgress;
    public int ticksToSit;
    public int sleepProgress;
    public int forceSleep;
    protected int tiredCounter = 0;
    protected int buoyancy = 1;
    private static final EntityDataAccessor<Integer> HUNGER = SynchedEntityData.m_135353_(ComplexMobTerrestrial.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int animationTick;
    private Animation currentAnimation;
    public float turn_speed = 0.2f;
    protected float swimSpeedMult = 1.0f;

    public ComplexMobTerrestrial(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new SmartSwimmingMoveControl((Mob)this, 85, 10, 1.0f, 1.0f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 30);
        this.ticksToSit = 40;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new AmphibiousPathNavigation(this, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HUNGER, (Object)79);
    }

    @Override
    public void m_8107_() {
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (!this.m_9236_().f_46443_) {
            if (this.forceSleep > 0) {
                --this.forceSleep;
            } else if (this.forceSleep < 0) {
                ++this.forceSleep;
            }
            if (!this.m_21573_().m_26571_() && (this.isSitting() || this.m_5803_())) {
                this.setSitting(false);
                this.setSleeping(false);
            }
            if (!this.m_5803_() && this.forceSleep > 0) {
                this.setSleeping(true);
            }
            if (this.f_19797_ % 200 == 0 && !this.isActive() && this.m_21573_().m_26571_()) {
                ++this.tiredCounter;
                if (this.m_20238_(this.getHomeAsVec()) <= 6.0) {
                    this.setSleeping(true);
                    this.tiredCounter = 0;
                } else if (this.tiredCounter >= 3) {
                    this.setHome(BlockPos.f_121853_);
                    this.tiredCounter = 0;
                }
                this.f_21342_.m_6849_((double)this.getHome().m_123341_(), (double)this.getHome().m_123342_(), (double)this.getHome().m_123343_(), 1.0);
            }
        }
        if (this.isSitting() && this.sitProgress < this.ticksToSit) {
            ++this.sitProgress;
        } else if (!this.isSitting() && this.sitProgress > 0) {
            --this.sitProgress;
        }
        if (this.m_5803_() && this.sleepProgress < 40) {
            ++this.sleepProgress;
        } else if (!this.m_5803_() && this.sleepProgress > 0) {
            --this.sleepProgress;
        }
        super.m_8107_();
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && !this.m_9236_().m_5776_()) {
            ItemStack itemstack = player.m_21120_(hand);
            if (!this.m_6162_() && this.m_6898_(itemstack) && !this.f_20890_) {
                if (!this.m_9236_().f_46443_ && !player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                if (((Boolean)ConfigGamerules.playerBreeding.get()).booleanValue() && this.f_146733_ == 0) {
                    this.m_27595_(player);
                    EntityUtils.spawnParticlesOnEntity(this.m_9236_(), (LivingEntity)this, ParticleTypes.f_123750_, 7, 1);
                }
                this.setAnimation(this.getAnimationEat());
                this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6071_(player, hand);
    }

    protected ActivityType getActivityType() {
        return ComplexMobTerrestrial.getEntityData(this.m_6095_()).getActivityType(this.getVariant());
    }

    public boolean isActive() {
        ActivityType type = this.getActivityType();
        Pair<Integer, Integer> times = type.getTimes();
        if (this.m_21824_() && this.getCommandInt() != 0 || !((Boolean)ConfigGamerules.sleepBehaviour.get()).booleanValue()) {
            return true;
        }
        if (type == ActivityType.CATHEMERAL) {
            return this.f_19797_ % 17000 < 3000;
        }
        long time = this.m_9236_().m_46468_();
        if (!((Integer)times.getFirst()).equals(times.getSecond())) {
            if ((Integer)times.getFirst() > (Integer)times.getSecond()) {
                return time > (long)((Integer)times.getFirst()).intValue() || time < (long)((Integer)times.getSecond()).intValue();
            }
            return time > (long)((Integer)times.getFirst()).intValue() && time < (long)((Integer)times.getSecond()).intValue();
        }
        return this.forceSleep >= 0;
    }

    private void setHunger(int hunger) {
        this.f_19804_.m_135381_(HUNGER, (Object)hunger);
    }

    public int getHunger() {
        return (Integer)this.f_19804_.m_135370_(HUNGER);
    }

    public boolean isStarving() {
        return this.getHunger() <= 0;
    }

    public void addHunger(int change) {
        int i = this.getHunger() + change;
        this.setHunger(i > 200 ? 200 : Math.max(i, 0));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isSitting()) {
            this.setSitting(false);
        }
        if (this.m_5803_() && this.forceSleep <= 0) {
            this.setSleeping(false);
            this.forceSleep = -4000;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource p_70645_1_) {
        if (!this.m_9236_().f_46443_ && !((Boolean)ConfigGamerules.hardcoreDeath.get()).booleanValue() && this.getHome() != BlockPos.f_121853_ && this.m_21824_() && this.getHunger() != 0) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 800, 0));
            this.m_21153_(0.5f);
            this.setHunger(0);
            if (!this.m_20984_(this.getHome().m_123341_(), this.getHome().m_123342_(), this.getHome().m_123343_(), true)) {
                super.m_6667_(p_70645_1_);
            }
        } else {
            super.m_6667_(p_70645_1_);
        }
    }

    public void m_7023_(Vec3 p_149181_) {
        if (this.m_6109_() && this.m_20069_() && this.m_20146_() > 40) {
            this.m_19920_(this.m_6113_(), p_149181_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.3));
        } else {
            super.m_7023_(p_149181_);
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[0];
    }

    public Animation getAnimationEat() {
        return NO_ANIMATION;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sleeping", this.m_5803_());
        compound.m_128405_("SleepingTicks", this.forceSleep);
        compound.m_128379_("Sitting", this.isSitting());
        compound.m_128405_("Hunger", this.getHunger());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSleeping(compound.m_128471_("Sleeping"));
        this.forceSleep = compound.m_128451_("SleepingTicks");
        this.setSitting(compound.m_128471_("Sitting"));
        this.setHunger(compound.m_128451_("Hunger"));
    }

    static class AmphibiousPathNavigation
    extends WaterBoundPathNavigation {
        private final ComplexMobTerrestrial entityIn;

        AmphibiousPathNavigation(ComplexMobTerrestrial entityIn, Level worldIn) {
            super((Mob)entityIn, worldIn);
            this.entityIn = entityIn;
        }

        protected boolean m_7632_() {
            return true;
        }

        protected PathFinder m_5532_(int p_149222_) {
            this.f_26508_ = new AmphibiousNodeEvaluator(false);
            return new PathFinder(this.f_26508_, p_149222_);
        }

        public boolean m_6342_(BlockPos destinationIn) {
            BlockPos blockpos = destinationIn.m_7495_();
            return this.f_26495_.m_8055_(blockpos).m_60804_((BlockGetter)this.f_26495_, blockpos);
        }
    }

    public static enum ActivityType {
        DIURNAL("diurnal", 1000, 16000),
        NOCTURNAL("nocturnal", 13000, 4000),
        CREPUSCULAR("crepuscular", 8000, 23000),
        CATHEMERAL("cathemeral", -1, -1),
        INSOMNIAC("insomniac", -1, -1);

        public int wakeUp;
        public int sleep;
        public String name;
        public static final Codec<ActivityType> CODEC;

        private ActivityType(String name, int wakeUp, int sleep) {
            this.wakeUp = wakeUp;
            this.sleep = sleep;
            this.name = name;
        }

        private static DataResult<ActivityType> getByName(String path) {
            return switch (path) {
                case "diurnal" -> DataResult.success((Object)((Object)DIURNAL));
                case "nocturnal" -> DataResult.success((Object)((Object)NOCTURNAL));
                case "crepuscular" -> DataResult.success((Object)((Object)CREPUSCULAR));
                case "cathemeral" -> DataResult.success((Object)((Object)CATHEMERAL));
                default -> DataResult.success((Object)((Object)INSOMNIAC));
            };
        }

        public String toString() {
            return this.name;
        }

        public Pair<Integer, Integer> getTimes() {
            return new Pair((Object)this.wakeUp, (Object)this.sleep);
        }

        static {
            CODEC = Codec.STRING.comapFlatMap(ActivityType::getByName, ActivityType::toString).stable();
        }
    }
}

