/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.client.model;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import untamedwilds.entity.mammal.EntityOpossum;

public class ModelOpossum
extends AdvancedEntityModel<EntityOpossum> {
    public AdvancedModelBox body_main;
    public AdvancedModelBox arm_left_1;
    public AdvancedModelBox arm_right_1;
    public AdvancedModelBox head_head;
    public AdvancedModelBox leg_right_1;
    public AdvancedModelBox leg_left_1;
    public AdvancedModelBox joey_1;
    public AdvancedModelBox joey_2;
    public AdvancedModelBox joey_3;
    public AdvancedModelBox arm_left_2;
    public AdvancedModelBox arm_left_paw;
    public AdvancedModelBox arm_right_2;
    public AdvancedModelBox arm_right_paw;
    public AdvancedModelBox head_ear_left;
    public AdvancedModelBox head_ear_right;
    public AdvancedModelBox head_snout;
    public AdvancedModelBox eye_left;
    public AdvancedModelBox eye_right;
    public AdvancedModelBox head_jaw;
    public AdvancedModelBox whisker_right;
    public AdvancedModelBox whisker_left;
    public AdvancedModelBox leg_right_2;
    public AdvancedModelBox leg_right_paw;
    public AdvancedModelBox leg_left_2;
    public AdvancedModelBox leg_left_paw;
    public AdvancedModelBox tail_1;
    public AdvancedModelBox tail_2;
    private final ModelAnimator animator;

    public ModelOpossum() {
        this.texWidth = 64;
        this.texHeight = 32;
        this.joey_1 = new AdvancedModelBox((AdvancedEntityModel)this, 40, 0);
        this.joey_1.setRotationPoint(0.0f, -5.0f, 0.0f);
        this.joey_1.addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.joey_1, 0.0f, 0.0f, -0.5462881f);
        this.head_jaw = new AdvancedModelBox((AdvancedEntityModel)this, 6, 17);
        this.head_jaw.setRotationPoint(0.0f, 1.01f, -2.0f);
        this.head_jaw.addBox(-1.0f, 0.0f, -4.0f, 2.0f, 1.0f, 4.0f, 0.0f);
        this.arm_left_2 = new AdvancedModelBox((AdvancedEntityModel)this, 30, 23);
        this.arm_left_2.mirror = true;
        this.arm_left_2.setRotationPoint(0.0f, 3.5f, 0.01f);
        this.arm_left_2.addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.arm_left_2, 0.0f, 0.0f, 0.13665928f);
        this.body_main = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.body_main.setRotationPoint(0.0f, 19.0f, -3.8f);
        this.body_main.addBox(-2.5f, -3.3f, -2.0f, 5.0f, 5.0f, 10.0f, 0.0f);
        this.whisker_right = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.whisker_right.setRotationPoint(-0.6f, 0.0f, -3.0f);
        this.whisker_right.addBox(-3.0f, -1.5f, 0.0f, 3.0f, 3.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.whisker_right, 0.0f, -0.22759093f, -0.27314404f);
        this.arm_left_paw = new AdvancedModelBox((AdvancedEntityModel)this, 0, 4);
        this.arm_left_paw.mirror = true;
        this.arm_left_paw.setRotationPoint(0.5f, 3.02f, 1.0f);
        this.arm_left_paw.addBox(-1.5f, 0.0f, -3.0f, 3.0f, 0.0f, 4.0f, 0.0f);
        this.leg_right_2 = new AdvancedModelBox((AdvancedEntityModel)this, 46, 24);
        this.leg_right_2.setRotationPoint(0.0f, 3.1f, 1.2f);
        this.leg_right_2.addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.leg_right_2, 0.27314404f, 0.0f, -0.13962634f);
        this.eye_left = new AdvancedModelBox((AdvancedEntityModel)this, 0, 17);
        this.eye_left.setRotationPoint(0.01f, 0.0f, -3.01f);
        this.eye_left.addBox(0.0f, -1.0f, -1.0f, 2.0f, 1.0f, 1.0f, 0.0f);
        this.tail_2 = new AdvancedModelBox((AdvancedEntityModel)this, 14, 17);
        this.tail_2.setRotationPoint(0.0f, 0.1f, 3.9f);
        this.tail_2.addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 6.0f, 0.0f);
        this.setRotateAngle(this.tail_2, 0.13665928f, 0.0f, 0.0f);
        this.tail_2.scaleX = 0.75f;
        this.arm_right_2 = new AdvancedModelBox((AdvancedEntityModel)this, 30, 23);
        this.arm_right_2.setRotationPoint(0.0f, 3.5f, 0.01f);
        this.arm_right_2.addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.arm_right_2, 0.0f, 0.0f, -0.13665928f);
        this.leg_left_1 = new AdvancedModelBox((AdvancedEntityModel)this, 46, 15);
        this.leg_left_1.mirror = true;
        this.leg_left_1.setRotationPoint(1.5f, -1.3f, 6.8f);
        this.leg_left_1.addBox(-1.5f, -1.0f, -2.0f, 3.0f, 5.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.leg_left_1, -0.27314404f, 0.0f, -0.13962634f);
        this.head_ear_left = new AdvancedModelBox((AdvancedEntityModel)this, 0, 21);
        this.head_ear_left.setRotationPoint(1.3f, -1.3f, -1.5f);
        this.head_ear_left.addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.head_ear_left, -0.091106184f, -0.091106184f, 0.8651597f);
        this.whisker_left = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.whisker_left.mirror = true;
        this.whisker_left.setRotationPoint(0.6f, 0.0f, -3.0f);
        this.whisker_left.addBox(0.0f, -1.5f, 0.0f, 3.0f, 3.0f, 0.0f, 0.0f);
        this.setRotateAngle(this.whisker_left, 0.0f, 0.22759093f, 0.27314404f);
        this.head_head = new AdvancedModelBox((AdvancedEntityModel)this, 2, 22);
        this.head_head.setRotationPoint(0.0f, -1.0f, -1.9f);
        this.head_head.addBox(-2.0f, -2.0f, -4.0f, 4.0f, 4.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.head_head, 0.091106184f, 0.0f, 0.0f);
        this.leg_left_paw = new AdvancedModelBox((AdvancedEntityModel)this, 0, 4);
        this.leg_left_paw.mirror = true;
        this.leg_left_paw.setRotationPoint(0.5f, 3.01f, 1.0f);
        this.leg_left_paw.addBox(-1.5f, 0.0f, -3.0f, 3.0f, 0.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.leg_left_paw, 0.0036651914f, 0.0f, 0.0f);
        this.head_snout = new AdvancedModelBox((AdvancedEntityModel)this, 18, 26);
        this.head_snout.setRotationPoint(0.0f, 1.0f, -2.0f);
        this.head_snout.addBox(-1.0f, -1.0f, -4.0f, 2.0f, 2.0f, 2.0f, 0.0f);
        this.arm_right_1 = new AdvancedModelBox((AdvancedEntityModel)this, 28, 15);
        this.arm_right_1.setRotationPoint(-1.5f, -1.55f, 0.2f);
        this.arm_right_1.addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.arm_right_1, 0.0f, 0.0f, 0.13665928f);
        this.leg_right_1 = new AdvancedModelBox((AdvancedEntityModel)this, 46, 15);
        this.leg_right_1.setRotationPoint(-1.5f, -1.3f, 6.8f);
        this.leg_right_1.addBox(-1.5f, -1.0f, -2.0f, 3.0f, 5.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.leg_right_1, -0.27314404f, 0.0f, 0.13962634f);
        this.leg_right_paw = new AdvancedModelBox((AdvancedEntityModel)this, 0, 4);
        this.leg_right_paw.setRotationPoint(-0.5f, 3.01f, 1.0f);
        this.leg_right_paw.addBox(-1.5f, 0.0f, -3.0f, 3.0f, 0.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.leg_right_paw, 0.0036651914f, 0.0f, 0.0f);
        this.joey_2 = new AdvancedModelBox((AdvancedEntityModel)this, 40, 0);
        this.joey_2.mirror = true;
        this.joey_2.setRotationPoint(0.0f, -5.0f, 3.0f);
        this.joey_2.addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.joey_2, 0.0f, 0.0f, 0.5462881f);
        this.joey_3 = new AdvancedModelBox((AdvancedEntityModel)this, 40, 0);
        this.joey_3.setRotationPoint(0.0f, -5.0f, 6.0f);
        this.joey_3.addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.joey_3, 0.0f, 0.0f, -0.5462881f);
        this.tail_1 = new AdvancedModelBox((AdvancedEntityModel)this, 24, 2);
        this.tail_1.setRotationPoint(0.0f, -2.0f, 7.5f);
        this.tail_1.addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.tail_1, -0.4098033f, 0.0f, 0.0f);
        this.arm_right_paw = new AdvancedModelBox((AdvancedEntityModel)this, 0, 4);
        this.arm_right_paw.setRotationPoint(-0.5f, 3.02f, 1.0f);
        this.arm_right_paw.addBox(-1.5f, 0.0f, -3.0f, 3.0f, 0.0f, 4.0f, 0.0f);
        this.eye_right = new AdvancedModelBox((AdvancedEntityModel)this, 0, 17);
        this.eye_right.mirror = true;
        this.eye_right.setRotationPoint(-0.01f, 0.0f, -3.01f);
        this.eye_right.addBox(-2.0f, -1.0f, -1.0f, 2.0f, 1.0f, 1.0f, 0.0f);
        this.head_ear_right = new AdvancedModelBox((AdvancedEntityModel)this, 0, 21);
        this.head_ear_right.mirror = true;
        this.head_ear_right.setRotationPoint(-1.3f, -1.2f, -1.5f);
        this.head_ear_right.addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.head_ear_right, -0.091106184f, 0.091106184f, -0.8651597f);
        this.arm_left_1 = new AdvancedModelBox((AdvancedEntityModel)this, 28, 15);
        this.arm_left_1.mirror = true;
        this.arm_left_1.setRotationPoint(1.5f, -1.55f, 0.2f);
        this.arm_left_1.addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.arm_left_1, 0.0f, 0.0f, -0.13665928f);
        this.leg_left_2 = new AdvancedModelBox((AdvancedEntityModel)this, 46, 24);
        this.leg_left_2.mirror = true;
        this.leg_left_2.setRotationPoint(0.0f, 3.1f, 1.2f);
        this.leg_left_2.addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.leg_left_2, 0.27314404f, 0.0f, 0.13962634f);
        this.body_main.addChild((BasicModelPart)this.joey_1);
        this.head_head.addChild((BasicModelPart)this.head_jaw);
        this.arm_left_1.addChild((BasicModelPart)this.arm_left_2);
        this.head_snout.addChild((BasicModelPart)this.whisker_right);
        this.arm_left_2.addChild((BasicModelPart)this.arm_left_paw);
        this.leg_right_1.addChild((BasicModelPart)this.leg_right_2);
        this.head_head.addChild((BasicModelPart)this.eye_left);
        this.tail_1.addChild((BasicModelPart)this.tail_2);
        this.arm_right_1.addChild((BasicModelPart)this.arm_right_2);
        this.body_main.addChild((BasicModelPart)this.leg_left_1);
        this.head_head.addChild((BasicModelPart)this.head_ear_left);
        this.head_snout.addChild((BasicModelPart)this.whisker_left);
        this.body_main.addChild((BasicModelPart)this.head_head);
        this.leg_left_2.addChild((BasicModelPart)this.leg_left_paw);
        this.head_head.addChild((BasicModelPart)this.head_snout);
        this.body_main.addChild((BasicModelPart)this.arm_right_1);
        this.body_main.addChild((BasicModelPart)this.leg_right_1);
        this.leg_right_2.addChild((BasicModelPart)this.leg_right_paw);
        this.body_main.addChild((BasicModelPart)this.joey_2);
        this.body_main.addChild((BasicModelPart)this.joey_3);
        this.body_main.addChild((BasicModelPart)this.tail_1);
        this.arm_right_2.addChild((BasicModelPart)this.arm_right_paw);
        this.head_head.addChild((BasicModelPart)this.eye_right);
        this.head_head.addChild((BasicModelPart)this.head_ear_right);
        this.body_main.addChild((BasicModelPart)this.arm_left_1);
        this.leg_left_1.addChild((BasicModelPart)this.leg_left_2);
        this.animator = ModelAnimator.create();
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body_main);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body_main, (Object)this.arm_left_1, (Object)this.arm_right_1, (Object)this.head_head, (Object)this.leg_right_1, (Object)this.leg_left_1, (Object)this.tail_1, (Object)this.joey_1, (Object)this.joey_2, (Object)this.joey_3, (Object)this.arm_left_2, (Object)this.arm_left_paw, (Object[])new AdvancedModelBox[]{this.arm_right_2, this.arm_right_paw, this.head_ear_left, this.head_ear_right, this.head_snout, this.eye_left, this.eye_right, this.head_jaw, this.whisker_right, this.whisker_left, this.leg_right_2, this.leg_right_paw, this.leg_left_2, this.leg_left_paw, this.tail_2});
    }

    private void animate(IAnimatedEntity entityIn) {
        EntityOpossum monitor = (EntityOpossum)entityIn;
        this.animator.update((IAnimatedEntity)monitor);
        this.animator.setAnimation(EntityOpossum.THREAT_BACK_OFF);
        int invert = 1;
        for (int i = 0; i < 4; ++i) {
            this.animator.startKeyframe(6);
            this.animator.move(this.head_snout, 0.0f, -1.0f, 0.0f);
            this.rotate(this.animator, this.head_head, -15.65f, 2.61f * (float)invert, 13.04f * (float)invert);
            this.rotate(this.animator, this.head_jaw, 44.35f, 0.0f, 0.0f);
            invert *= -1;
            this.animator.endKeyframe();
        }
        this.animator.resetKeyframe(6);
        this.animator.setAnimation(EntityOpossum.IDLE_SCRATCH);
        this.animator.startKeyframe(8);
        this.rotate(this.animator, this.body_main, 0.0f, 7.83f, -7.83f);
        this.rotate(this.animator, this.head_head, -23.48f, 20.87f, -39.13f);
        this.rotate(this.animator, this.tail_1, -23.48f, -15.65f, 0.0f);
        this.rotate(this.animator, this.head_ear_right, -28.7f, 5.22f, -49.57f);
        this.animator.move(this.arm_right_1, 0.0f, -0.3f, 0.0f);
        this.rotate(this.animator, this.arm_right_1, 0.0f, 0.0f, 13.04f);
        this.rotate(this.animator, this.leg_left_1, -15.65f, 0.0f, 2.61f);
        this.animator.move(this.leg_right_1, 0.0f, 0.0f, -1.0f);
        this.rotate(this.animator, this.leg_right_1, -60.0f, 18.26f, 8.0f);
        this.animator.move(this.leg_right_paw, 0.0f, -1.0f, -1.0f);
        this.rotate(this.animator, this.leg_right_paw, 88.7f, 0.0f, 0.0f);
        int leg_offset = 1;
        for (int i = 0; i < 6; ++i) {
            this.animator.startKeyframe(4);
            this.rotate(this.animator, this.body_main, 0.0f, 7.83f, -7.83f);
            this.rotate(this.animator, this.head_head, -23.48f, 20.87f - (float)(10 * leg_offset), -39.13f - (float)(10 * leg_offset));
            this.rotate(this.animator, this.tail_1, -23.48f, -15.65f, 0.0f);
            this.rotate(this.animator, this.head_ear_right, -28.7f, 5.22f, -49.57f);
            this.animator.move(this.arm_right_1, 0.0f, -0.3f, 0.0f);
            this.rotate(this.animator, this.arm_right_1, 0.0f, 0.0f, 13.04f);
            this.rotate(this.animator, this.leg_left_1, -15.65f, 0.0f, 2.61f);
            this.animator.move(this.leg_right_1, 0.0f, 0.0f, -1.0f);
            this.rotate(this.animator, this.leg_right_1, -80 - 20 * leg_offset, 18.26f, 8.0f);
            this.animator.move(this.leg_right_paw, 0.0f, -1.0f, -1.0f);
            this.rotate(this.animator, this.leg_right_paw, 88.7f, 0.0f, 0.0f);
            leg_offset *= -1;
            this.animator.endKeyframe();
        }
        this.animator.resetKeyframe(8);
    }

    public void setupAnim(EntityOpossum opossum, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(opossum);
        float globalSpeed = 1.6f;
        float globalDegree = 1.4f;
        limbSwingAmount = Math.min(0.5f, limbSwingAmount);
        if (opossum.m_21525_()) {
            limbSwing = ageInTicks / 4.0f;
            limbSwingAmount = 0.5f;
        }
        if (!opossum.isPlayingDead()) {
            this.body_main.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
            this.head_head.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), 1.0f, 1.0f);
            this.swing(this.whisker_left, globalSpeed, 0.12f * globalDegree, false, 1.0f, 0.0f, ageInTicks / 6.0f, 2.0f);
            this.swing(this.whisker_right, globalSpeed, 0.12f * globalDegree, true, 1.0f, 0.0f, ageInTicks / 6.0f, 2.0f);
            AdvancedModelBox[] bodyParts = new AdvancedModelBox[]{this.tail_1, this.tail_2};
            this.chainSwing(bodyParts, 0.3f * globalSpeed, 0.125f * globalDegree, 1.0, ageInTicks / 6.0f, 1.0f);
        }
        this.joey_1.showModel = opossum.getJoeys() >= 1;
        this.joey_2.showModel = opossum.getJoeys() >= 2;
        boolean bl = this.joey_3.showModel = opossum.getJoeys() >= 3;
        if (!opossum.m_5803_()) {
            this.faceTarget(netHeadYaw, headPitch, 2.0f, new AdvancedModelBox[]{this.head_head});
        }
        if (opossum.m_20069_() && !opossum.m_20096_()) {
            this.setRotateAngle(this.body_main, opossum.m_146909_() * ((float)Math.PI / 180), 0.0f, 0.0f);
        }
        if (opossum.m_20069_()) {
            this.flap(this.arm_left_1, globalSpeed, globalDegree, false, 0.8f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.leg_left_1, globalSpeed, globalDegree * 0.8f, false, 1.6f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.arm_right_1, globalSpeed, globalDegree, false, 2.4f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.leg_right_1, globalSpeed, globalDegree * 0.8f, false, 3.2f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.body_main, globalSpeed / 2.0f, globalDegree * 1.2f, false, 0.0f, 0.1f, limbSwing / 2.0f, limbSwingAmount);
            this.swing(this.body_main, globalSpeed / 2.0f, globalDegree * 1.2f, false, 0.8f, 0.1f, limbSwing / 3.0f, limbSwingAmount);
            this.chainWave(new AdvancedModelBox[]{this.head_head, this.body_main}, globalSpeed * 0.8f, globalDegree, -4.0, limbSwing, limbSwingAmount * 0.2f);
        } else {
            this.bob(this.body_main, 0.5f * globalSpeed, 0.8f, true, limbSwing, limbSwingAmount);
            this.bob(this.arm_right_1, 0.5f * globalSpeed, 0.8f, false, limbSwing, limbSwingAmount);
            this.walk(this.arm_right_1, 0.5f * globalSpeed, globalDegree, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
            this.walk(this.arm_right_2, 0.5f * globalSpeed, 0.6f * globalDegree, true, 0.2f, 0.2f, limbSwing, limbSwingAmount);
            this.bob(this.arm_left_1, 0.5f * globalSpeed, 0.8f, false, limbSwing, limbSwingAmount);
            this.walk(this.arm_left_1, 0.5f * globalSpeed, globalDegree, true, 2.4f, 0.0f, limbSwing, limbSwingAmount);
            this.walk(this.arm_left_2, 0.5f * globalSpeed, 0.6f * globalDegree, true, 2.6f, 0.2f, limbSwing, limbSwingAmount);
            this.bob(this.leg_right_1, 0.5f * globalSpeed, 0.8f, false, limbSwing, limbSwingAmount);
            this.walk(this.leg_right_1, 0.5f * globalSpeed, globalDegree, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
            this.walk(this.leg_right_2, 0.5f * globalSpeed, 0.6f * globalDegree, true, 1.2f, 0.2f, limbSwing, limbSwingAmount);
            this.bob(this.leg_left_1, 0.5f * globalSpeed, 0.8f, false, limbSwing, limbSwingAmount);
            this.walk(this.leg_left_1, 0.5f * globalSpeed, globalDegree, true, 3.4f, 0.0f, limbSwing, limbSwingAmount);
            this.walk(this.leg_left_2, 0.5f * globalSpeed, 0.6f * globalDegree, true, 3.6f, 0.2f, limbSwing, limbSwingAmount);
        }
        if (opossum.sitProgress != 0) {
            this.body_main.setScaleY(1.0f + 0.4f * (float)opossum.sitProgress / 20.0f);
            this.progressPosition(this.body_main, opossum.sitProgress, 0.0f, 22.0f, -3.8f, 20.0f);
            this.progressPosition(this.arm_left_1, opossum.sitProgress, 1.5f, -2.55f, 0.2f, 20.0f);
            this.progressPosition(this.arm_left_2, opossum.sitProgress, 0.0f, 1.5f, 0.01f, 20.0f);
            this.progressPosition(this.arm_right_1, opossum.sitProgress, -1.5f, -2.55f, 0.2f, 20.0f);
            this.progressPosition(this.arm_right_2, opossum.sitProgress, 0.0f, 1.5f, 0.01f, 20.0f);
            this.progressPosition(this.leg_left_1, opossum.sitProgress, 1.5f, -2.3f, 6.8f, 20.0f);
            this.progressPosition(this.leg_left_2, opossum.sitProgress, 0.0f, 1.0f, 1.2f, 20.0f);
            this.progressPosition(this.leg_right_1, opossum.sitProgress, -1.5f, -2.3f, 6.8f, 20.0f);
            this.progressPosition(this.leg_right_2, opossum.sitProgress, 0.0f, 1.0f, 1.2f, 20.0f);
        }
        if (opossum.sleepProgress != 0) {
            this.progressRotation(this.body_main, opossum.sleepProgress, 0.0f, 0.0f, (float)Math.toRadians(-80.65f), 40.0f);
            this.progressPosition(this.body_main, opossum.sleepProgress, -1.0f, 22.0f, -1.8f, 40.0f);
            this.progressRotation(this.head_head, opossum.sleepProgress, (float)Math.toRadians(20.87f), 0.0f, (float)Math.toRadians(-18.26f), 40.0f);
            if (opossum.isPlayingDead()) {
                this.progressRotation(this.head_jaw, opossum.sleepProgress, (float)Math.toRadians(46.96f), 0.0f, (float)Math.toRadians(23.48f), 40.0f);
            }
            this.progressRotation(this.arm_left_1, opossum.sleepProgress, 0.0f, (float)Math.toRadians(7.83f), (float)Math.toRadians(10.43f), 40.0f);
            this.progressRotation(this.leg_left_1, opossum.sleepProgress, (float)Math.toRadians(-36.52f), (float)Math.toRadians(2.61f), (float)Math.toRadians(5.22f), 40.0f);
            this.progressRotation(this.tail_1, opossum.sleepProgress, (float)Math.toRadians(-65.22f), 0.0f, 0.0f, 40.0f);
            this.progressRotation(this.tail_2, opossum.sleepProgress, (float)Math.toRadians(-44.35f), 0.0f, 0.0f, 40.0f);
        }
    }
}

