/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.client.model;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.util.Mth;
import untamedwilds.entity.amphibian.EntityGiantSalamander;

public class ModelGiantSalamander
extends AdvancedEntityModel<EntityGiantSalamander> {
    public AdvancedModelBox body_main;
    public AdvancedModelBox body_torso;
    public AdvancedModelBox tail_1;
    public AdvancedModelBox leg_left_1;
    public AdvancedModelBox leg_right_1;
    public AdvancedModelBox arm_left_1;
    public AdvancedModelBox arm_right_1;
    public AdvancedModelBox head_main;
    public AdvancedModelBox head_jaw;
    public AdvancedModelBox head_face;
    public AdvancedModelBox tail_2;
    private final ModelAnimator animator;

    public ModelGiantSalamander() {
        this.texWidth = 64;
        this.texHeight = 32;
        this.arm_right_1 = new AdvancedModelBox((AdvancedEntityModel)this, 24, 0);
        this.arm_right_1.mirror = true;
        this.arm_right_1.setRotationPoint(-2.0f, 0.2f, -3.0f);
        this.arm_right_1.addBox(-1.5f, -1.0f, -4.0f, 3.0f, 2.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.arm_right_1, 0.22759093f, 1.1838568f, 0.0f);
        this.arm_left_1 = new AdvancedModelBox((AdvancedEntityModel)this, 24, 0);
        this.arm_left_1.setRotationPoint(2.0f, 0.2f, -3.0f);
        this.arm_left_1.addBox(-1.5f, -1.0f, -4.0f, 3.0f, 2.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.arm_left_1, 0.22759093f, -1.0471976f, 0.0f);
        this.tail_2 = new AdvancedModelBox((AdvancedEntityModel)this, 42, 8);
        this.tail_2.setRotationPoint(0.0f, 0.0f, 4.0f);
        this.tail_2.addBox(-1.0f, -2.0f, 0.0f, 2.0f, 4.0f, 7.0f, 0.0f);
        this.body_main = new AdvancedModelBox((AdvancedEntityModel)this, 0, 10);
        this.body_main.setRotationPoint(0.0f, 22.3f, 0.0f);
        this.body_main.addBox(-2.5f, -1.5f, 0.0f, 5.0f, 3.0f, 7.0f, 0.0f);
        this.leg_left_1 = new AdvancedModelBox((AdvancedEntityModel)this, 24, 8);
        this.leg_left_1.setRotationPoint(1.5f, 0.2f, 5.0f);
        this.leg_left_1.addBox(-1.5f, -1.0f, -4.0f, 3.0f, 2.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.leg_left_1, 0.22759093f, -2.0943952f, 0.0f);
        this.tail_1 = new AdvancedModelBox((AdvancedEntityModel)this, 42, 0);
        this.tail_1.setRotationPoint(0.0f, 0.01f, 7.0f);
        this.tail_1.addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 4.0f, 0.0f);
        this.head_main = new AdvancedModelBox((AdvancedEntityModel)this, 0, 20);
        this.head_main.setRotationPoint(0.0f, -0.4f, -6.0f);
        this.head_main.addBox(-3.0f, -1.5f, -2.5f, 6.0f, 3.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.head_main, 0.13665928f, 0.0f, 0.0f);
        this.body_torso = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.body_torso.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.body_torso.addBox(-2.5f, -1.5f, -7.0f, 5.0f, 3.0f, 7.0f, 0.0f);
        this.leg_right_1 = new AdvancedModelBox((AdvancedEntityModel)this, 24, 8);
        this.leg_right_1.mirror = true;
        this.leg_right_1.setRotationPoint(-1.5f, 0.2f, 5.0f);
        this.leg_right_1.addBox(-1.5f, -1.0f, -4.0f, 3.0f, 2.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.leg_right_1, 0.22759093f, 2.0943952f, 0.0f);
        this.head_jaw = new AdvancedModelBox((AdvancedEntityModel)this, 18, 25);
        this.head_jaw.setRotationPoint(0.0f, 0.5f, -2.5f);
        this.head_jaw.addBox(-3.0f, 0.0f, -3.0f, 6.0f, 1.0f, 3.0f, 0.0f);
        this.head_face = new AdvancedModelBox((AdvancedEntityModel)this, 18, 20);
        this.head_face.setRotationPoint(0.0f, -0.5f, -1.5f);
        this.head_face.addBox(-3.0f, -1.0f, -4.0f, 6.0f, 2.0f, 3.0f, 0.0f);
        this.body_torso.addChild((BasicModelPart)this.arm_right_1);
        this.body_torso.addChild((BasicModelPart)this.arm_left_1);
        this.tail_1.addChild((BasicModelPart)this.tail_2);
        this.body_main.addChild((BasicModelPart)this.leg_left_1);
        this.body_main.addChild((BasicModelPart)this.tail_1);
        this.body_torso.addChild((BasicModelPart)this.head_main);
        this.body_main.addChild((BasicModelPart)this.body_torso);
        this.body_main.addChild((BasicModelPart)this.leg_right_1);
        this.head_main.addChild((BasicModelPart)this.head_jaw);
        this.head_main.addChild((BasicModelPart)this.head_face);
        this.animator = ModelAnimator.create();
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body_main);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body_main, (Object)this.body_torso, (Object)this.arm_left_1, (Object)this.arm_right_1, (Object)this.leg_left_1, (Object)this.leg_right_1, (Object)this.tail_1, (Object)this.tail_2, (Object)this.head_main, (Object)this.head_face, (Object)this.head_jaw);
    }

    private void animate(IAnimatedEntity entityIn) {
        this.animator.update(entityIn);
        this.animator.setAnimation(EntityGiantSalamander.ATTACK_SWALLOW);
        this.animator.startKeyframe(5);
        this.rotate(this.animator, this.head_main, -5.22f, 15.65f, -20.87f);
        this.rotate(this.animator, this.head_jaw, 57.39f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_face, -44.35f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.rotate(this.animator, this.head_main, -5.22f, -5.22f, 10.43f);
        this.rotate(this.animator, this.head_jaw, 57.39f, 0.0f, 0.0f);
        this.rotate(this.animator, this.head_face, -44.35f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
    }

    public void setupAnim(EntityGiantSalamander salamander, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(salamander);
        float globalSpeed = 0.8f;
        float globalDegree = 1.0f;
        limbSwingAmount = Math.min(0.6f, limbSwingAmount);
        this.body_main.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
        this.body_torso.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
        this.head_face.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
        this.head_jaw.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
        this.head_main.setScale((float)(1.0 + Math.sin(ageInTicks / 20.0f) * (double)0.06f), (float)(1.0 + Math.sin(ageInTicks / 16.0f) * (double)0.06f), 1.0f);
        if (!salamander.m_5803_()) {
            this.faceTarget(netHeadYaw, headPitch, 2.0f, new AdvancedModelBox[]{this.head_main});
        }
        if (salamander.m_20069_() && !salamander.m_20096_()) {
            this.setRotateAngle(this.body_main, salamander.m_146909_() * ((float)Math.PI / 180), 0.0f, 0.0f);
        }
        this.body_torso.rotateAngleY = Mth.m_14189_((float)0.05f, (float)this.body_torso.rotateAngleY, (float)salamander.offset);
        this.tail_1.rotateAngleY = Mth.m_14189_((float)0.05f, (float)this.tail_1.rotateAngleY, (float)(-1.0f * salamander.offset));
        this.tail_2.rotateAngleY = Mth.m_14189_((float)0.05f, (float)this.tail_2.rotateAngleY, (float)(-2.0f * salamander.offset));
        AdvancedModelBox[] bodyParts = new AdvancedModelBox[]{this.head_main, this.body_torso, this.body_main, this.tail_1, this.tail_2};
        this.chainSwing(bodyParts, globalSpeed * 1.4f, globalDegree * 1.2f, -4.0, limbSwing, limbSwingAmount * 0.3f);
        float onGround = Math.min(0.8f, limbSwingAmount * (float)(salamander.m_20096_() ? 2 : 1));
        if (salamander.m_20069_()) {
            this.flap(this.arm_left_1, globalSpeed, globalDegree, false, 0.8f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.leg_left_1, globalSpeed, globalDegree * 0.8f, false, 1.6f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.arm_right_1, globalSpeed, globalDegree, false, 2.4f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.leg_right_1, globalSpeed, globalDegree * 0.8f, false, 3.2f, 1.0f, limbSwing, limbSwingAmount);
            this.flap(this.body_main, globalSpeed / 2.0f, globalDegree * 1.2f, false, 0.0f, 0.1f, limbSwing / 2.0f, limbSwingAmount);
            this.swing(this.body_main, globalSpeed / 2.0f, globalDegree * 1.2f, false, 0.8f, 0.1f, limbSwing / 3.0f, limbSwingAmount);
            this.chainWave(new AdvancedModelBox[]{this.head_main, this.body_torso, this.body_main}, globalSpeed * 0.8f, globalDegree, -4.0, limbSwing, limbSwingAmount * 0.2f);
        } else {
            this.swing(this.arm_left_1, globalSpeed, globalDegree * 2.0f, false, 0.8f, 1.0f, limbSwing, onGround);
            this.swing(this.leg_left_1, globalSpeed, globalDegree * 1.8f, false, 1.6f, 1.0f, limbSwing, onGround);
            this.swing(this.arm_right_1, globalSpeed, globalDegree * 2.0f, false, 2.4f, 1.0f, limbSwing, onGround);
            this.swing(this.leg_right_1, globalSpeed, globalDegree * 1.8f, false, 3.2f, 1.0f, limbSwing, onGround);
        }
        if (salamander.swimProgress > 0) {
            this.progressRotation(this.arm_right_1, salamander.swimProgress, (float)Math.toRadians(-20.87f), (float)Math.toRadians(172.1f), (float)Math.toRadians(-78.26), 20.0f);
            this.progressRotation(this.arm_left_1, salamander.swimProgress, (float)Math.toRadians(-20.87f), (float)Math.toRadians(-172.1f), (float)Math.toRadians(78.26), 20.0f);
            this.progressRotation(this.leg_right_1, salamander.swimProgress, (float)Math.toRadians(-15.65), (float)Math.toRadians(174.7), (float)Math.toRadians(-88.7), 20.0f);
            this.progressRotation(this.leg_left_1, salamander.swimProgress, (float)Math.toRadians(-15.65), (float)Math.toRadians(-174.7), (float)Math.toRadians(88.7), 20.0f);
        }
    }
}

