/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block.blockentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import untamedwilds.UntamedWilds;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModTags;
import untamedwilds.util.EntityUtils;

public class CageBlockEntity
extends BlockEntity {
    private CompoundTag data;
    private boolean locked;

    public CageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlock.TILE_ENTITY_CAGE.get(), pos, state);
    }

    public static boolean isBlacklisted(Entity entity) {
        return entity.m_6095_().m_204039_(ModTags.EntityTags.CAGE_BLACKLIST);
    }

    public boolean cageEntity(Mob entity) {
        if (!(this.isLocked() || CageBlockEntity.isBlacklisted((Entity)entity) || !((Boolean)ConfigGamerules.easyMobCapturing.get()).booleanValue() && entity.m_5448_() != null)) {
            this.setTagCompound(EntityUtils.writeEntityToNBT((LivingEntity)entity));
            this.setLocked(true);
            entity.m_146870_();
            this.m_6596_();
            return true;
        }
        return false;
    }

    public boolean spawnCagedCreature(ServerLevel worldIn, BlockPos pos, boolean offsetHitbox) {
        EntityType<?> entity;
        if (!worldIn.f_46443_ && this.isLocked() && (entity = EntityUtils.getEntityTypeFromTag(this.getTagCompound(), null)) != null && worldIn.m_45772_(entity.m_20585_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() - (offsetHitbox ? entity.m_20679_() + 1.2f : 0.0f)), (double)((float)pos.m_123343_() + 0.5f)))) {
            Entity caged_entity;
            if (worldIn.m_8791_(this.data.m_128469_("EntityTag").m_128342_("UUID")) != null) {
                UntamedWilds.LOGGER.info("UUID is already present in the Level; Randomizing UUID for the new mob");
                this.data.m_128469_("EntityTag").m_128362_("UUID", Mth.m_216261_((RandomSource)worldIn.f_46441_));
            }
            if ((caged_entity = EntityType.m_20645_((CompoundTag)this.data.m_128469_("EntityTag"), (Level)worldIn, input -> input)) != null) {
                caged_entity.m_7678_((double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_() - (offsetHitbox ? (double)caged_entity.m_20206_() + 1.2 : 0.8), (double)((float)pos.m_123343_() + 0.5f), Mth.m_14177_((float)(worldIn.f_46441_.m_188501_() * 360.0f)), 0.0f);
                worldIn.m_47205_(caged_entity);
                this.setTagCompound(null);
                this.setLocked(true);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public CompoundTag getTagCompound() {
        return this.data;
    }

    private void setTagCompound(@Nullable CompoundTag nbt) {
        this.data = nbt;
    }

    public boolean hasTagCompound() {
        return this.data != null;
    }

    public boolean isLocked() {
        return this.locked;
    }

    private void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.setTagCompound(compound.m_6426_());
        this.setLocked(compound.m_128471_("closed"));
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("closed", this.isLocked());
        if (this.getTagCompound() != null) {
            compound.m_128365_("EntityTag", (Tag)this.getTagCompound().m_128469_("EntityTag"));
        }
    }
}

