/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.mixins;

import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.reg.ModItems;
import com.ordana.spelunkery.reg.ModTags;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LayeredCauldronBlock.class})
public class WaterCauldronBlockMixin
extends AbstractCauldronBlock {
    @Shadow
    @Final
    public static IntegerProperty f_153514_;

    public WaterCauldronBlockMixin(BlockBehaviour.Properties properties, Map<Item, CauldronInteraction> map) {
        super(properties, map);
    }

    @Inject(method={"entityInside"}, at={@At(value="HEAD")})
    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, CallbackInfo ci) {
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            if (this.m_151979_(state, pos, entity) && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ItemStack itemStack = item.m_32055_();
                if (state.m_60713_(Blocks.f_152476_)) {
                    Slime slime;
                    if (itemStack.m_150930_(ModItems.SALT.get()) && serverLevel.m_8055_(pos.m_7495_()).m_204336_(ModTags.CAN_BOIL_WATER)) {
                        int count = itemStack.m_41613_();
                        ItemStack newStack = new ItemStack((ItemLike)ModItems.ROCK_SALT.get());
                        newStack.m_41764_(count);
                        item.m_32045_(newStack);
                        LayeredCauldronBlock.m_153559_((BlockState)state, (Level)serverLevel, (BlockPos)pos);
                    }
                    if (itemStack.m_150930_(Items.f_42204_) && CommonConfigs.SLIME_CAULDRONS.get().booleanValue() && (Integer)state.m_61143_((Property)f_153514_) == 3 && (slime = (Slime)EntityType.f_20526_.m_20615_((Level)serverLevel)) != null) {
                        try {
                            ServerPlayer player = (ServerPlayer)item.m_19749_();
                            CriteriaTriggers.f_10562_.m_285767_(Objects.requireNonNull(player), pos, itemStack);
                        }
                        catch (ClassCastException | NullPointerException runtimeException) {
                            // empty catch block
                        }
                        item.m_142687_(Entity.RemovalReason.DISCARDED);
                        slime.m_6027_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                        serverLevel.m_7967_((Entity)slime);
                        serverLevel.m_46597_(pos, Blocks.f_50256_.m_49966_());
                    }
                }
            }
        }
    }

    @Shadow
    public boolean m_142596_(BlockState state) {
        return false;
    }
}

