/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.utils.LevelHelper;
import com.ordana.spelunkery.utils.TranslationUtils;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PortalFluidBottleItem
extends HoneyBottleItem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int tickCounter = 0;
    public static final FoodProperties PORTAL_FLUID = new FoodProperties.Builder().m_38760_(0).m_38758_(0.0f).m_38765_().m_38767_();

    public PortalFluidBottleItem(Item.Properties properties) {
        super(properties);
    }

    @PlatformOnly(value={"forge"})
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public int setTickCounter(int tick) {
        this.tickCounter = tick;
        return this.tickCounter;
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level levelIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, levelIn, entityIn, itemSlot, isSelected);
        ++this.tickCounter;
        if (this.tickCounter >= 200) {
            this.setBoolean(stack, !this.getBoolean(stack));
            this.setTickCounter(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            CompoundTag compoundTag = stack.m_41784_();
            if (this.getBoolean(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.rhymes_with_tears_0").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_PURPLE)));
            } else {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.spelunkery.rhymes_with_tears_1", (Object[])new Object[]{this.getBoolean(stack)}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_PURPLE)));
            }
            if (compoundTag.m_128441_("anchorPos") && CommonConfigs.PORTAL_FLUID_DRINKING.get().booleanValue()) {
                BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("anchorPos"));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.spelunkery.portal_fluid_pos", (Object[])new Object[]{blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.LIGHT_PURPLE)));
            }
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.f_90816_.m_84873_())) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.portal_fluid_1").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.portal_fluid_2").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                if (CommonConfigs.CRYING_OBSIDIAN_PORTAL_FLUID.get().booleanValue() && CommonConfigs.RESPAWN_ANCHOR_PORTAL_FLUID.get().booleanValue()) {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.portal_fluid_3c").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                } else if (CommonConfigs.CRYING_OBSIDIAN_PORTAL_FLUID.get().booleanValue()) {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.portal_fluid_3a").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                } else if (CommonConfigs.RESPAWN_ANCHOR_PORTAL_FLUID.get().booleanValue()) {
                    tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.portal_fluid_3b").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                }
            } else {
                tooltip.add((Component)TranslationUtils.CROUCH.component());
            }
        }
    }

    public void setBoolean(@NotNull ItemStack stack, boolean tears) {
        stack.m_41784_().m_128379_("bool", tears);
    }

    public boolean getBoolean(@NotNull ItemStack stack) {
        return stack.m_41784_().m_128471_("bool");
    }

    private static boolean inPortalDimension(@NotNull Level level) {
        return level.m_46472_() == Level.f_46428_ || level.m_46472_() == Level.f_46429_;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Optional optional;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (PortalFluidBottleItem.inPortalDimension(level) && (optional = PortalShape.m_77708_((LevelAccessor)level, (BlockPos)pos.m_121945_(context.m_43719_()), (Direction.Axis)Direction.Axis.X)).isPresent()) {
            ((PortalShape)optional.get()).m_77743_();
            if (CommonConfigs.PORTAL_CREATION_SOUND.get().booleanValue()) {
                level.m_5594_(null, pos, SoundEvents.f_12326_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_42590_.m_7968_());
            player.m_21008_(context.m_43724_(), itemStack2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    public SoundEvent m_6023_() {
        return SoundEvents.f_11970_;
    }

    @NotNull
    public SoundEvent m_6061_() {
        return SoundEvents.f_11970_;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_42590_.m_7968_());
            player.m_21008_(player.m_7655_(), itemStack2);
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (CommonConfigs.PORTAL_FLUID_DRINKING.get().booleanValue()) {
                CriteriaTriggers.f_10592_.m_23682_(serverPlayer, stack);
                serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                CompoundTag compoundTag = stack.m_41784_();
                boolean bl = compoundTag.m_128441_("anchorPos");
                boolean bl2 = compoundTag.m_128441_("anchorDimension");
                PortalFluidBottleItem.getDimension(compoundTag);
                if (bl && bl2) {
                    LevelHelper.teleportToAnchorPosition(serverPlayer, PortalFluidBottleItem.getAnchorPos(compoundTag));
                } else {
                    LevelHelper.teleportToSpawnPosition(serverPlayer);
                }
            }
        }
        return stack;
    }

    public static void addLocationTags(ResourceKey<Level> anchorDimension, BlockPos pos, CompoundTag compoundTag) {
        if (!compoundTag.m_128441_("anchorPos")) {
            compoundTag.m_128365_("anchorPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        }
        DataResult var10000 = Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, anchorDimension);
        Logger var10001 = LOGGER;
        Objects.requireNonNull(var10001);
        var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(tag -> compoundTag.m_128365_("anchorDimension", tag));
    }

    private static Optional<ResourceKey<Level>> getDimension(CompoundTag compoundTag) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_("anchorDimension")).result();
    }

    public static GlobalPos getAnchorPos(CompoundTag compoundTag) {
        Optional<ResourceKey<Level>> optional;
        boolean bl = compoundTag.m_128441_("anchorPos");
        boolean bl2 = compoundTag.m_128441_("anchorDimension");
        if (bl && bl2 && (optional = PortalFluidBottleItem.getDimension(compoundTag)).isPresent()) {
            BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("anchorPos"));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)blockPos);
        }
        return null;
    }
}

