/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.blaze3d.platform.InputConstants;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModItems;
import com.ordana.spelunkery.reg.ModTags;
import com.ordana.spelunkery.utils.TranslationUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HammerAndChiselItem
extends Item
implements Vanishable {
    public static final Supplier<BiMap<Block, Block>> CHISELED_BLOCKS = Suppliers.memoize(() -> {
        List<String> botaniaChiselables = List.of("livingrock_bricks", "dark_quartz", "mana_quartz", "blaze_quartz", "lavender_quartz", "red_quartz", "elf_quartz", "sunny_quartz", "metamorphic_forest_bricks", "metamorphic_plains_bricks", "metamorphic_mountain_bricks", "metamorphic_fungal_bricks", "metamorphic_swamp_bricks", "metamorphic_desert_bricks", "metamorphic_taiga_bricks", "metamorphic_mesa_bricks");
        List<String> malumChiselables = List.of("tainted_rock", "twisted_rock");
        List<String> quarkChiselables = List.of("granite_bricks", "diorite_bricks", "andesite_bricks", "calcite_bricks", "dripstone_bricks", "tuff_bricks", "limestone_bricks", "jasper_bricks", "shale_bricks", "myalite_bricks", "soul_sandstone_bricks");
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Blocks.f_50222_, (Object)Blocks.f_50225_).put((Object)Blocks.f_50176_, (Object)Blocks.f_50179_).put((Object)Blocks.f_152555_, (Object)Blocks.f_152593_).put((Object)Blocks.f_50197_, (Object)Blocks.f_50712_).put((Object)Blocks.f_50333_, (Object)Blocks.f_50282_).put((Object)Blocks.f_50064_, (Object)Blocks.f_50063_).put((Object)Blocks.f_50396_, (Object)Blocks.f_50395_).put((Object)Blocks.f_50734_, (Object)Blocks.f_50737_);
        HammerAndChiselItem.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "minecraft:prismarine_bricks", "immersive_weathering:chiseled_prismarine_bricks");
        HammerAndChiselItem.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "oreganized:glance_bricks", "oreganized:chiseled_glance");
        HammerAndChiselItem.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "sullysmod:polished_jade_bricks", "sullysmod:polished_chiseled_jade");
        for (String chiselable : botaniaChiselables) {
            HammerAndChiselItem.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "botania:" + chiselable, "botania:chiseled_" + chiselable);
        }
        for (String chiselable : malumChiselables) {
            HammerAndChiselItem.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "malum:" + chiselable, "malum:chiseled_" + chiselable);
        }
        for (String chiselable : quarkChiselables) {
            HammerAndChiselItem.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:" + chiselable, "quark:chiseled_" + chiselable);
        }
        return builder.build();
    });

    public HammerAndChiselItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            if (stack.m_150930_(ModItems.FLINT_HAMMER_AND_CHISEL.get())) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.flint_hammer_and_chisel").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_PURPLE)));
            }
            if (stack.m_150930_(ModItems.OBSIDIAN_HAMMER_AND_CHISEL.get())) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.obsidian_hammer_and_chisel").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_PURPLE)));
            }
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.f_90816_.m_84873_())) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.hammer_and_chisel_1").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.hammer_and_chisel_2").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.hammer_and_chisel_3").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)TranslationUtils.HAMMER_AND_CHISEL_4.component());
            } else {
                tooltip.add((Component)TranslationUtils.CROUCH.component());
            }
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        player.m_6672_(usedHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public boolean m_6832_(ItemStack stack, @NotNull ItemStack repairCandidate) {
        return stack.m_150930_(ModItems.OBSIDIAN_HAMMER_AND_CHISEL.get()) && repairCandidate.m_150930_(Items.f_41999_) || stack.m_150930_(ModItems.FLINT_HAMMER_AND_CHISEL.get()) && repairCandidate.m_150930_(Items.f_42484_);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        float f = (float)(stack.m_41779_() - remainingUseDuration) / 20.0f;
        if (f < 1.0f || !(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        HitResult hit = Utils.rayTrace((LivingEntity)player, (Level)level, (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (hit instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hit;
            BlockPos pos = blockHit.m_82425_();
            Direction dir = blockHit.m_82434_();
            BlockState state = level.m_8055_(pos);
            Optional<BlockState> chiseled = HammerAndChiselItem.getChiseled(state);
            if (chiseled.isPresent() && player.m_36341_()) {
                level.m_5594_(null, pos, SoundEvents.f_11667_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5594_(null, pos, state.m_60734_().m_49962_(state).m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (!serverPlayer.m_7500_()) {
                        stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(serverPlayer.m_7655_()));
                    }
                    level.m_46597_(pos, chiseled.get());
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                }
            } else if (!state.m_204336_(ModTags.CHISELABLE) || state.m_204336_(ModTags.CHISEL_IMMUNE) || state.m_60713_(ModBlocks.DIAMOND_GRINDSTONE.get()) || stack.m_150930_(ModItems.FLINT_HAMMER_AND_CHISEL.get()) && (state.m_204336_(BlockTags.f_144285_) || state.m_204336_(BlockTags.f_144284_))) {
                ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123762_, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                level.m_5594_(null, pos, SoundEvents.f_12347_, SoundSource.BLOCKS, 0.5f, 0.0f);
            } else if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!player.m_7500_()) {
                    stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(player.m_7655_()));
                }
                level.m_46953_(pos, false, (Entity)player);
                Block.m_152435_((Level)level, (BlockPos)pos, (Direction)dir, (ItemStack)state.m_60734_().m_7397_((BlockGetter)level, pos, state));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
            }
            livingEntity.m_21253_();
        }
    }

    public static void addOptional(ImmutableBiMap.Builder<Block, Block> map, String moddedId, String moddedId2) {
        Optional o1 = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(moddedId));
        Optional o2 = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(moddedId2));
        if (o1.isPresent() && o2.isPresent()) {
            map.put((Object)((Block)o1.get()), (Object)((Block)o2.get()));
        }
    }

    public static Optional<BlockState> getChiseled(BlockState state) {
        return Optional.ofNullable((Block)CHISELED_BLOCKS.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }
}

