/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.reg.ModGameEvents;
import com.ordana.spelunkery.utils.TranslationUtils;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AmethystTuningForkItem
extends Item
implements IFirstPersonAnimationProvider,
IThirdPersonAnimationProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_LODESTONE_POS = "LodestonePos";
    public static final String TAG_LODESTONE_DIMENSION = "LodestoneDimension";
    public static final String TAG_LODESTONE_TRACKED = "LodestoneTracked";
    public static boolean tolling;
    private int tickCounter = 0;
    private final CompassWobble wobble = new CompassWobble();

    public AmethystTuningForkItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.f_90816_.m_84873_())) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.spelunkery.tuning_fork_1", (Object[])new Object[]{this.getTollRange()}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.tuning_fork_2").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
            } else {
                tooltip.add((Component)TranslationUtils.CROUCH.component());
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag compoundTag = stack.m_41784_();
        boolean hasTag = compoundTag.m_128441_("amethystPos");
        if (level.m_46472_() != Level.f_46428_) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (player.m_36341_()) {
            if (hasTag) {
                compoundTag.m_128473_("amethystPos");
                compoundTag.m_128473_("amethystDimension");
            }
            tolling = false;
        } else if (!hasTag) {
            level.m_142346_((Entity)player, ModGameEvents.FORK_TONE_EVENT.get(), player.m_20183_());
            player.m_36335_().m_41524_((Item)this, 20);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_145090_.m_163865_(serverPlayer, stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public int getTollRange() {
        return CommonConfigs.TUNING_FORK_RANGE.get();
    }

    public void setPlayerX(ItemStack stack, int amount) {
        stack.m_41784_().m_128405_("ex", amount);
    }

    public int getPlayerX(ItemStack stack) {
        return stack.m_41784_().m_128451_("ex");
    }

    public void setPlayerZ(ItemStack stack, int amount) {
        stack.m_41784_().m_128405_("zed", amount);
    }

    public int getPlayerZ(ItemStack stack) {
        return stack.m_41784_().m_128451_("zed");
    }

    @PlatformOnly(value={"forge"})
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    private static Optional<ResourceKey<Level>> getDimension(CompoundTag compoundTag) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_("amethystDimension")).result();
    }

    public int setTickCounter(int tick) {
        this.tickCounter = tick;
        return this.tickCounter;
    }

    public static void addAmethystTags(ResourceKey<Level> lodestoneDimension, BlockPos pos, CompoundTag compoundTag) {
        if (!compoundTag.m_128441_("amethystPos")) {
            compoundTag.m_128365_("amethystPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        }
        tolling = true;
        DataResult var10000 = Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, lodestoneDimension);
        Logger var10001 = LOGGER;
        Objects.requireNonNull(var10001);
        var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(tag -> compoundTag.m_128365_("amethystDimension", tag));
    }

    public static boolean isAmethystNearby(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41783_();
        return compoundTag != null && compoundTag.m_128441_("amethystPos");
    }

    public static double distanceToAmethyst(Vec3i playerPos, BlockPos amethystPos) {
        return amethystPos.m_123331_(playerPos);
    }

    @Nullable
    public static GlobalPos getAmethystPos(CompoundTag compoundTag) {
        Optional<ResourceKey<Level>> optional;
        boolean bl = compoundTag.m_128441_("amethystPos");
        boolean bl2 = compoundTag.m_128441_("amethystDimension");
        if (bl && bl2 && (optional = AmethystTuningForkItem.getDimension(compoundTag)).isPresent()) {
            BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("amethystPos"));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)blockPos);
        }
        return null;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack itemStack, HumanoidModel<T> model, T entity, HumanoidArm humanoidArm) {
        if (entity.m_21212_() > 0 && entity.m_21211_().m_41720_() == this && entity.m_21252_() < 50) {
            model.f_102812_.f_104204_ = MthUtils.wrapRad((float)(0.1f + model.f_102808_.f_104204_));
            model.f_102812_.f_104203_ = MthUtils.wrapRad((float)(-1.5707964f + model.f_102808_.f_104203_));
            return true;
        }
        return false;
    }

    public <T extends LivingEntity> boolean poseRightArm(ItemStack itemStack, HumanoidModel<T> model, T entity, HumanoidArm humanoidArm) {
        if (entity.m_21212_() > 0 && entity.m_21211_().m_41720_() == this && entity.m_21252_() < 50) {
            model.f_102811_.f_104204_ = MthUtils.wrapRad((float)(-0.1f + model.f_102808_.f_104204_));
            model.f_102811_.f_104203_ = MthUtils.wrapRad((float)(-1.5707964f + model.f_102808_.f_104203_));
            return true;
        }
        return false;
    }

    public void animateItemFirstPerson(LivingEntity entity, ItemStack stack, InteractionHand hand, PoseStack poseStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        Level level;
        if (tolling && entity.m_7655_() == hand && (level = entity.m_9236_()) instanceof ClientLevel) {
            ClientLevel level2 = (ClientLevel)level;
            BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)stack.m_41784_().m_128469_("amethystPos"));
            long time = level2.m_46467_();
            float value = (float)Math.cos((float)time + partialTicks) * 100.0f;
            float modifier = this.getModifierAngle((Entity)entity, time, blockPos) * 360.0f;
            double distance = StrictMath.cbrt(AmethystTuningForkItem.distanceToAmethyst((Vec3i)entity.m_20183_(), blockPos));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-80.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(0.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)((double)value / distance) + modifier));
        }
    }

    public float getModifierAngle(Entity entity, long l, BlockPos blockPos) {
        double d = this.getAngleFromEntityToPos(entity, blockPos);
        double e = this.getWrappedVisualRotationY(entity);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.wobble.shouldUpdate(l)) {
                this.wobble.update(l, 0.5 - (e - 0.25));
            }
            double f = d + this.wobble.rotation;
            return Mth.m_14091_((float)((float)f), (float)1.0f);
        }
        double f = 0.5 - (e - 0.25 - d);
        return Mth.m_14091_((float)((float)f), (float)1.0f);
    }

    private float getAngleFromEntityToPos(Entity entity, BlockPos blockPos) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)blockPos);
        return (float)Math.atan2(vec3.m_7094_() - entity.m_20189_(), vec3.m_7096_() - entity.m_20185_()) / ((float)Math.PI * 2);
    }

    private double getWrappedVisualRotationY(Entity entity) {
        return Mth.m_14109_((double)(entity.m_213816_() / 360.0f), (double)1.0);
    }

    static class CompassWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        CompassWobble() {
        }

        boolean shouldUpdate(long l) {
            return this.lastUpdateTick != l;
        }

        void update(long l, double d) {
            this.lastUpdateTick = l;
            double e = d - this.rotation;
            e = Mth.m_14109_((double)(e + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += e * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.m_14109_((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

