/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.fluids;

import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModFluids;
import java.util.Random;
import net.mehvahdjukaar.moonlight.api.client.ModFluidRenderProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PortalFluidRenderer
extends ModFluidRenderProperties {
    private final ResourceLocation overlay;
    private final ResourceLocation renderOverlay;
    private final Vec3 fogColor;
    static ResourceLocation portalFluidLargeSW = Spelunkery.res("block/portal_fluid_large_sw");
    static ResourceLocation portalFluidLargeSE = Spelunkery.res("block/portal_fluid_large_se");
    static ResourceLocation portalFluidLargeNW = Spelunkery.res("block/portal_fluid_large_nw");
    static ResourceLocation portalFluidLargeNE = Spelunkery.res("block/portal_fluid_large_ne");
    static ResourceLocation portalFluidN = Spelunkery.res("block/portal_fluid_n");
    static ResourceLocation portalFluidE = Spelunkery.res("block/portal_fluid_e");
    static ResourceLocation portalFluidS = Spelunkery.res("block/portal_fluid_s");
    static ResourceLocation portalFluidW = Spelunkery.res("block/portal_fluid_w");
    static ResourceLocation portalFluidSW = Spelunkery.res("block/portal_fluid_sw");
    static ResourceLocation portalFluidSE = Spelunkery.res("block/portal_fluid_se");
    static ResourceLocation portalFluidNW = Spelunkery.res("block/portal_fluid_nw");
    static ResourceLocation portalFluidNE = Spelunkery.res("block/portal_fluid_ne");
    static ResourceLocation portalFluidNS = Spelunkery.res("block/portal_fluid_ns");
    static ResourceLocation portalFluidEW = Spelunkery.res("block/portal_fluid_ew");
    static ResourceLocation portalFluidWNE = Spelunkery.res("block/portal_fluid_wne");
    static ResourceLocation portalFluidNES = Spelunkery.res("block/portal_fluid_nes");
    static ResourceLocation portalFluidESW = Spelunkery.res("block/portal_fluid_esw");
    static ResourceLocation portalFluidSWN = Spelunkery.res("block/portal_fluid_swn");
    static ResourceLocation portalFluidNESW = Spelunkery.res("block/portal_fluid_nesw");
    static ResourceLocation portalFluidNONE = Spelunkery.res("block/portal_fluid_none");
    static ResourceLocation portalFluidUncommon = Spelunkery.res("block/portal_fluid_uncommon");
    static ResourceLocation portalFluidRare = Spelunkery.res("block/portal_fluid_rare");
    static ResourceLocation portalFluidSnence = Spelunkery.res("block/portal_fluid_snence");
    static ResourceLocation portalFluidMaple = Spelunkery.res("block/portal_fluid_maple");
    TextureAtlasSprite[] portalFluidSpriteLargeSW = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteLargeSE = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteLargeNW = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteLargeNE = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteN = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteE = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteS = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteW = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteSW = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteSE = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteNW = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteNE = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteNS = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteEW = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteWNE = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteNES = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteESW = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteSWN = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteNESW = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteNONE = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteUncommon = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteRare = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteSnence = new TextureAtlasSprite[3];
    TextureAtlasSprite[] portalFluidSpriteMaple = new TextureAtlasSprite[3];

    public PortalFluidRenderer(ResourceLocation still, ResourceLocation flowing, int tint, ResourceLocation overlay, ResourceLocation renderOverlay, Vec3 fogColor) {
        super(still, flowing, tint);
        this.overlay = overlay;
        this.renderOverlay = renderOverlay;
        this.fogColor = fogColor;
    }

    private boolean isPortalFluid(FluidState state) {
        return state.m_192917_((Fluid)ModFluids.PORTAL_FLUID.get()) || state.m_192917_((Fluid)ModFluids.FLOWING_PORTAL_FLUID.get());
    }

    private boolean isRandomPos(BlockPos pos, int rarity) {
        Random random = new Random((long)((double)Mth.m_14057_((Vec3i)pos) * ClientConfigs.PORTAL_FLUID_SEED.get()));
        return random.nextInt(rarity) == 0;
    }

    private boolean areAllNeighborsFluid(BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        return level != null && this.isPortalFluid(level.m_6425_(pos.m_121945_(Direction.NORTH))) && this.isPortalFluid(level.m_6425_(pos.m_121945_(Direction.EAST))) && this.isPortalFluid(level.m_6425_(pos.m_121945_(Direction.SOUTH))) && this.isPortalFluid(level.m_6425_(pos.m_121945_(Direction.WEST)));
    }

    private boolean isNonFluidAdjacent(BlockPos pos, Direction dir) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        return level != null && !this.isPortalFluid(level.m_6425_(pos.m_121945_(dir)));
    }

    private BlockState getBelowBlock(BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        return level.m_8055_(pos.m_7495_());
    }

    public ResourceLocation getStillTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        ResourceLocation texture = portalFluidNONE;
        if (this.isRandomPos(pos, 10)) {
            texture = portalFluidUncommon;
        }
        if (this.isRandomPos(pos, 20)) {
            texture = portalFluidRare;
        }
        if (this.isNonFluidAdjacent(pos, Direction.NORTH) && this.isNonFluidAdjacent(pos, Direction.SOUTH) && this.isNonFluidAdjacent(pos, Direction.EAST) && this.isNonFluidAdjacent(pos, Direction.WEST)) {
            return portalFluidNESW;
        }
        if (this.getBelowBlock(pos).m_60713_(Blocks.f_50719_)) {
            return portalFluidMaple;
        }
        if (this.getBelowBlock(pos).m_60713_(ModBlocks.RAW_MAGNETITE_BLOCK.get())) {
            return portalFluidSnence;
        }
        if (this.isNonFluidAdjacent(pos, Direction.NORTH)) {
            texture = portalFluidN;
            if (this.isNonFluidAdjacent(pos, Direction.EAST)) {
                texture = portalFluidNE;
                if (this.isNonFluidAdjacent(pos, Direction.WEST)) {
                    return portalFluidWNE;
                }
            }
            if (this.isNonFluidAdjacent(pos, Direction.WEST)) {
                texture = portalFluidNW;
                if (this.isNonFluidAdjacent(pos, Direction.SOUTH)) {
                    return portalFluidSWN;
                }
            }
            if (this.isNonFluidAdjacent(pos, Direction.SOUTH)) {
                texture = portalFluidNS;
                if (this.isNonFluidAdjacent(pos, Direction.EAST)) {
                    return portalFluidNES;
                }
            }
        } else if (this.isNonFluidAdjacent(pos, Direction.EAST)) {
            texture = portalFluidE;
            if (this.isNonFluidAdjacent(pos, Direction.SOUTH)) {
                texture = portalFluidSE;
                if (this.isNonFluidAdjacent(pos, Direction.WEST)) {
                    return portalFluidESW;
                }
            } else if (this.isNonFluidAdjacent(pos, Direction.WEST)) {
                return portalFluidEW;
            }
        } else if (this.isNonFluidAdjacent(pos, Direction.SOUTH)) {
            texture = portalFluidS;
            if (this.isNonFluidAdjacent(pos, Direction.WEST)) {
                return portalFluidSW;
            }
        } else if (this.isNonFluidAdjacent(pos, Direction.WEST)) {
            return portalFluidW;
        }
        if (this.areAllNeighborsFluid(pos) && this.areAllNeighborsFluid(pos.m_122012_()) && this.areAllNeighborsFluid(pos.m_122024_()) && this.areAllNeighborsFluid(pos.m_122024_().m_122012_())) {
            boolean origin = this.isRandomPos(pos, 200);
            boolean south = this.isRandomPos(pos.m_122019_(), 200);
            boolean east = this.isRandomPos(pos.m_122029_(), 200);
            boolean southEast = this.isRandomPos(pos.m_122019_().m_122029_(), 200);
            if (origin) {
                return portalFluidLargeSE;
            }
            if (south) {
                return portalFluidLargeNW;
            }
            if (east) {
                return portalFluidLargeSW;
            }
            if (southEast) {
                return portalFluidLargeNE;
            }
        }
        return texture;
    }

    public void reloadTextures(TextureAtlas textureAtlas) {
        this.portalFluidSpriteLargeSW[0] = textureAtlas.m_118316_(portalFluidLargeSW);
        this.portalFluidSpriteLargeSE[0] = textureAtlas.m_118316_(portalFluidLargeSE);
        this.portalFluidSpriteLargeNW[0] = textureAtlas.m_118316_(portalFluidLargeNW);
        this.portalFluidSpriteLargeNE[0] = textureAtlas.m_118316_(portalFluidLargeNE);
        this.portalFluidSpriteN[0] = textureAtlas.m_118316_(portalFluidN);
        this.portalFluidSpriteE[0] = textureAtlas.m_118316_(portalFluidE);
        this.portalFluidSpriteS[0] = textureAtlas.m_118316_(portalFluidS);
        this.portalFluidSpriteW[0] = textureAtlas.m_118316_(portalFluidW);
        this.portalFluidSpriteSW[0] = textureAtlas.m_118316_(portalFluidSW);
        this.portalFluidSpriteSE[0] = textureAtlas.m_118316_(portalFluidSE);
        this.portalFluidSpriteNW[0] = textureAtlas.m_118316_(portalFluidNW);
        this.portalFluidSpriteNE[0] = textureAtlas.m_118316_(portalFluidNE);
        this.portalFluidSpriteNS[0] = textureAtlas.m_118316_(portalFluidNS);
        this.portalFluidSpriteEW[0] = textureAtlas.m_118316_(portalFluidEW);
        this.portalFluidSpriteWNE[0] = textureAtlas.m_118316_(portalFluidWNE);
        this.portalFluidSpriteNES[0] = textureAtlas.m_118316_(portalFluidNES);
        this.portalFluidSpriteESW[0] = textureAtlas.m_118316_(portalFluidESW);
        this.portalFluidSpriteSWN[0] = textureAtlas.m_118316_(portalFluidSWN);
        this.portalFluidSpriteNESW[0] = textureAtlas.m_118316_(portalFluidNESW);
        this.portalFluidSpriteNONE[0] = textureAtlas.m_118316_(portalFluidNONE);
        this.portalFluidSpriteUncommon[0] = textureAtlas.m_118316_(portalFluidUncommon);
        this.portalFluidSpriteRare[0] = textureAtlas.m_118316_(portalFluidRare);
        this.portalFluidSpriteSnence[0] = textureAtlas.m_118316_(portalFluidSnence);
        this.portalFluidSpriteMaple[0] = textureAtlas.m_118316_(portalFluidMaple);
        this.portalFluidSpriteLargeSW[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteLargeSE[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteLargeNW[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteLargeNE[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteN[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteE[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteS[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteW[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteSW[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteSE[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteNW[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteNE[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteNS[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteEW[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteWNE[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteNES[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteESW[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteSWN[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteNESW[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteNONE[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteUncommon[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteRare[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteSnence[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        this.portalFluidSpriteMaple[1] = textureAtlas.m_118316_(this.getFlowingTexture());
        ResourceLocation overlayTexture = this.getOverlayTexture();
        if (overlayTexture != null) {
            this.portalFluidSpriteLargeSW[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteLargeSE[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteLargeNW[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteLargeNE[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteN[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteE[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteS[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteW[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteSW[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteSE[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteNW[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteNE[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteNS[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteEW[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteWNE[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteNES[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteESW[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteSWN[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteNESW[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteNONE[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteUncommon[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteRare[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteSnence[2] = textureAtlas.m_118316_(overlayTexture);
            this.portalFluidSpriteMaple[2] = textureAtlas.m_118316_(overlayTexture);
        }
    }

    public TextureAtlasSprite[] getFluidSprites(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, FluidState state) {
        if (pos == null) {
            return this.portalFluidSpriteNONE;
        }
        TextureAtlasSprite[] texture = this.portalFluidSpriteNONE;
        if (this.isRandomPos(pos, 10)) {
            texture = this.portalFluidSpriteUncommon;
        }
        if (this.isRandomPos(pos, 20)) {
            texture = this.portalFluidSpriteRare;
        }
        if (this.isNonFluidAdjacent(pos, Direction.NORTH) && this.isNonFluidAdjacent(pos, Direction.SOUTH) && this.isNonFluidAdjacent(pos, Direction.EAST) && this.isNonFluidAdjacent(pos, Direction.WEST)) {
            return this.portalFluidSpriteNESW;
        }
        if (this.getBelowBlock(pos).m_60713_(Blocks.f_50719_)) {
            return this.portalFluidSpriteMaple;
        }
        if (this.getBelowBlock(pos).m_60713_(ModBlocks.RAW_MAGNETITE_BLOCK.get())) {
            return this.portalFluidSpriteSnence;
        }
        if (this.isNonFluidAdjacent(pos, Direction.NORTH)) {
            texture = this.portalFluidSpriteN;
            if (this.isNonFluidAdjacent(pos, Direction.EAST)) {
                texture = this.portalFluidSpriteNE;
                if (this.isNonFluidAdjacent(pos, Direction.WEST)) {
                    return this.portalFluidSpriteWNE;
                }
            }
            if (this.isNonFluidAdjacent(pos, Direction.WEST)) {
                texture = this.portalFluidSpriteNW;
                if (this.isNonFluidAdjacent(pos, Direction.SOUTH)) {
                    return this.portalFluidSpriteSWN;
                }
            }
            if (this.isNonFluidAdjacent(pos, Direction.SOUTH)) {
                texture = this.portalFluidSpriteNS;
                if (this.isNonFluidAdjacent(pos, Direction.EAST)) {
                    return this.portalFluidSpriteNES;
                }
            }
        } else if (this.isNonFluidAdjacent(pos, Direction.EAST)) {
            texture = this.portalFluidSpriteE;
            if (this.isNonFluidAdjacent(pos, Direction.SOUTH)) {
                texture = this.portalFluidSpriteSE;
                if (this.isNonFluidAdjacent(pos, Direction.WEST)) {
                    return this.portalFluidSpriteESW;
                }
            } else if (this.isNonFluidAdjacent(pos, Direction.WEST)) {
                return this.portalFluidSpriteEW;
            }
        } else if (this.isNonFluidAdjacent(pos, Direction.SOUTH)) {
            texture = this.portalFluidSpriteS;
            if (this.isNonFluidAdjacent(pos, Direction.WEST)) {
                return this.portalFluidSpriteSW;
            }
        } else if (this.isNonFluidAdjacent(pos, Direction.WEST)) {
            return this.portalFluidSpriteW;
        }
        if (this.areAllNeighborsFluid(pos) && this.areAllNeighborsFluid(pos.m_122012_()) && this.areAllNeighborsFluid(pos.m_122024_()) && this.areAllNeighborsFluid(pos.m_122024_().m_122012_())) {
            boolean origin = this.isRandomPos(pos, 200);
            boolean south = this.isRandomPos(pos.m_122019_(), 200);
            boolean east = this.isRandomPos(pos.m_122029_(), 200);
            boolean southEast = this.isRandomPos(pos.m_122019_().m_122029_(), 200);
            if (origin) {
                return this.portalFluidSpriteLargeSE;
            }
            if (south) {
                return this.portalFluidSpriteLargeNW;
            }
            if (east) {
                return this.portalFluidSpriteLargeSW;
            }
            if (southEast) {
                return this.portalFluidSpriteLargeNE;
            }
        }
        return texture;
    }

    @Nullable
    public ResourceLocation getOverlayTexture() {
        return this.overlay;
    }

    public ResourceLocation getOverlayTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        return this.getOverlayTexture();
    }

    public ResourceLocation getRenderOverlayTexture() {
        return this.renderOverlay;
    }

    public ResourceLocation getRenderOverlayTexture(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        return this.getRenderOverlayTexture();
    }

    public Vec3 modifyFogColor() {
        return this.fogColor;
    }

    public Vec3 modifyFogColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        return this.modifyFogColor();
    }
}

