/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.events;

import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.blocks.PortalFluidCauldronBlock;
import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.items.PortalFluidBottleItem;
import com.ordana.spelunkery.reg.ModBlockProperties;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModItems;
import com.ordana.spelunkery.reg.ModSoundEvents;
import com.ordana.spelunkery.reg.ModTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CryingObsidianBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ModEvents {
    private static final List<InteractionEvent> EVENTS = new ArrayList<InteractionEvent>();

    public static InteractionResult onBlockCLicked(ItemStack stack, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.m_41619_()) {
            return InteractionResult.PASS;
        }
        Item i = stack.m_41720_();
        BlockPos pos = hitResult.m_82425_();
        BlockState state = level.m_8055_(pos);
        for (InteractionEvent event : EVENTS) {
            InteractionResult result = event.run(i, stack, pos, state, player, level, hand, hitResult);
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult portalCauldronLogic(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (item == Items.f_42590_) {
            if (state.m_60734_() instanceof PortalFluidCauldronBlock) {
                level.m_5594_(player, pos, (SoundEvent)ModSoundEvents.PORTAL_FLUID_BOTTLE_FILL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)ModItems.PORTAL_FLUID_BOTTLE.get().m_7968_());
                    player.m_21008_(hand, itemStack2);
                    if ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) > 1) {
                        level.m_46597_(pos, (BlockState)ModBlocks.PORTAL_CAULDRON.get().m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) - 1)));
                    } else {
                        level.m_46597_(pos, Blocks.f_50256_.m_49966_());
                    }
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        } else if (item == Items.f_42446_ && state.m_60734_() instanceof PortalFluidCauldronBlock && (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3) {
            level.m_5594_(player, pos, (SoundEvent)ModSoundEvents.PORTAL_FLUID_BUCKET_FILL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)ModItems.PORTAL_FLUID_BUCKET.get().m_7968_());
                player.m_21008_(hand, itemStack2);
                level.m_46597_(pos, Blocks.f_50256_.m_49966_());
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult saltBoiling(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (item == ModItems.SALT.get() && state.m_60713_(Blocks.f_152476_) && level.m_8055_(pos.m_7495_()).m_204336_(ModTags.CAN_BOIL_WATER)) {
            level.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5594_(player, pos, SoundEvents.f_11917_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)ModItems.ROCK_SALT.get().m_7968_());
                player.m_21008_(hand, itemStack2);
                if ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) > 1) {
                    level.m_46597_(pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) - 1)));
                } else {
                    level.m_46597_(pos, Blocks.f_50256_.m_49966_());
                }
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult obsidianDraining(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (item == ModItems.PORTAL_FLUID_BOTTLE.get()) {
            if (state.m_60713_(Blocks.f_50256_) || state.m_60734_() instanceof PortalFluidCauldronBlock && (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) < 3) {
                level.m_5594_(player, pos, (SoundEvent)ModSoundEvents.PORTAL_FLUID_BOTTLE_EMPTY.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_42590_.m_7968_());
                    player.m_21008_(hand, itemStack2);
                    if (state.m_60713_(Blocks.f_50256_)) {
                        level.m_46597_(pos, (BlockState)ModBlocks.PORTAL_CAULDRON.get().m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(1)));
                    } else {
                        level.m_46597_(pos, (BlockState)ModBlocks.PORTAL_CAULDRON.get().m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) + 1)));
                    }
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }
        if (item == Items.f_42590_) {
            if (state.m_60734_() instanceof CryingObsidianBlock && CommonConfigs.CRYING_OBSIDIAN_PORTAL_FLUID.get().booleanValue()) {
                level.m_5594_(player, pos, (SoundEvent)ModSoundEvents.PORTAL_FLUID_BOTTLE_FILL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123787_, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)ModItems.PORTAL_FLUID_BOTTLE.get().m_7968_());
                    player.m_21008_(hand, itemStack2);
                    level.m_46597_(pos, Blocks.f_50080_.m_49966_());
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (state.m_60734_() instanceof RespawnAnchorBlock && (Integer)state.m_61143_((Property)RespawnAnchorBlock.f_55833_) > 0 && CommonConfigs.RESPAWN_ANCHOR_PORTAL_FLUID.get().booleanValue()) {
                level.m_5594_(player, pos, (SoundEvent)ModSoundEvents.PORTAL_FLUID_BOTTLE_FILL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123787_, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ItemStack itemStack2 = new ItemStack((ItemLike)ModItems.PORTAL_FLUID_BOTTLE.get());
                    PortalFluidBottleItem.addLocationTags((ResourceKey<Level>)level.m_46472_(), pos, itemStack2.m_41784_());
                    if (!player.m_150109_().m_36054_(itemStack2)) {
                        player.m_36176_(itemStack2, false);
                    }
                    stack.m_41774_(1);
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)RespawnAnchorBlock.f_55833_, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)RespawnAnchorBlock.f_55833_) - 1)));
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult anvilRepairing(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.m_204117_(ModTags.ANVIL_REPAIR_ITEM) && state.m_204336_(BlockTags.f_13033_) && !state.m_60713_(Blocks.f_50322_)) {
            level.m_5594_(player, pos, SoundEvents.f_11667_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5594_(player, pos, SoundEvents.f_11669_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (state.m_60713_(Blocks.f_50323_)) {
                    level.m_46597_(pos, Blocks.f_50322_.m_49966_().m_60734_().m_152465_(state));
                } else if (state.m_60713_(Blocks.f_50324_)) {
                    level.m_46597_(pos, Blocks.f_50323_.m_49966_().m_60734_().m_152465_(state));
                }
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static InteractionResult disenchant(Item item, ItemStack stack, BlockPos pos, BlockState state, Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        boolean depleted;
        boolean bl = depleted = state.m_60713_(ModBlocks.DIAMOND_GRINDSTONE.get()) && (Integer)state.m_61143_((Property)ModBlockProperties.DEPLETION) == 3 || state.m_60713_(Blocks.f_50623_);
        if (!player.m_6047_()) {
            return InteractionResult.PASS;
        }
        if (!state.m_60713_(Blocks.f_50623_) && !state.m_60713_(ModBlocks.DIAMOND_GRINDSTONE.get())) {
            return InteractionResult.PASS;
        }
        if (stack.m_41793_()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)Vec3.m_82512_((Vec3i)pos), (int)ModEvents.getExperienceFromItem(stack, depleted));
            }
            player.m_21008_(hand, ModEvents.removeEnchants(stack, stack.m_41773_(), depleted));
            return InteractionResult.SUCCESS;
        }
        if (stack.m_204117_(ModTags.GRINDSTONE_REPAIR_ITEM) && state.m_60713_(ModBlocks.DIAMOND_GRINDSTONE.get()) && (Integer)state.m_61143_((Property)ModBlockProperties.DEPLETION) > 0) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ModBlockProperties.DEPLETION, (Comparable)Integer.valueOf(0)));
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult useGrindstone(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, boolean diamondGrindstone) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41720_() == Items.f_41852_) {
            player.m_5893_(state.m_60750_(level, pos));
            return InteractionResult.SUCCESS;
        }
        boolean success = false;
        boolean depleted = true;
        if (diamondGrindstone) {
            depleted = (Integer)state.m_61143_((Property)ModBlockProperties.DEPLETION) == 3;
        }
        String itemName = Utils.getID((Item)itemStack.m_41720_()).m_135815_();
        if (!level.m_5776_()) {
            LootParams.Builder builder;
            ResourceLocation tablePath = Spelunkery.res("gameplay/" + (diamondGrindstone && !depleted ? "diamond_" : "") + "grindstone_polishing/" + itemName);
            LootTable lootTable = level.m_7654_().m_278653_().m_278676_(tablePath);
            ObjectArrayList lootItem = lootTable.m_287195_((builder = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81461_, (Object)level.m_8055_(pos)).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_)).m_287235_(LootContextParamSets.f_81421_));
            if (lootItem.isEmpty()) {
                tablePath = Spelunkery.res("gameplay/grindstone_polishing/" + itemName);
                LootTable lootTable2 = level.m_7654_().m_278653_().m_278676_(tablePath);
                lootItem = lootTable2.m_287195_(builder.m_287235_(LootContextParamSets.f_81421_));
            }
            if (lootItem.isEmpty()) {
                player.m_5893_(state.m_60750_(level, pos));
                player.m_36220_(Stats.f_12952_);
                return InteractionResult.SUCCESS;
            }
            int deplChance = 0;
            for (ItemStack stack : lootItem) {
                if (stack.m_150930_(Items.f_42612_)) {
                    ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)level), (Vec3)Vec3.m_82512_((Vec3i)pos), (int)1);
                    continue;
                }
                if (stack.m_150930_(Items.f_41829_)) {
                    ++deplChance;
                    continue;
                }
                if (player.m_150109_().m_36054_(stack)) continue;
                player.m_36176_(stack, false);
            }
            success = true;
            if (tablePath.m_135815_().contains("diamond")) {
                Integer depl = CommonConfigs.DIAMOND_GRINDSTONE_DEPLETE_CHANCE.get();
                for (int i = 0; i < deplChance; ++i) {
                    int chance;
                    int n = chance = depl == 0 ? 0 : level.f_46441_.m_188503_(CommonConfigs.DIAMOND_GRINDSTONE_DEPLETE_CHANCE.get().intValue());
                    if (chance <= 0 || !diamondGrindstone || chance != 1 || depleted) continue;
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)ModBlockProperties.DEPLETION, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)ModBlockProperties.DEPLETION) + 1)));
                }
            }
        }
        if (level.m_5776_()) {
            if (itemStack.m_204117_(ModTags.GRINDABLE) || itemStack.m_204117_(ModTags.DIAMOND_GRINDABLE)) {
                ParticleUtil.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), (UniformInt)UniformInt.m_146622_((int)3, (int)5), (float)-0.05f, (float)0.05f, (boolean)false);
            }
            player.m_6674_(hand);
        }
        if (success) {
            if (!player.m_150110_().f_35937_ && !level.m_5776_()) {
                itemStack.m_41774_(1);
            }
            level.m_5594_(null, pos, SoundEvents.f_11998_, SoundSource.BLOCKS, 0.5f, 0.0f);
            player.m_6672_(hand);
            player.m_21253_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private static int getExperienceFromItem(ItemStack stack, boolean depleted) {
        int i = 0;
        Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Map.Entry enchantmentIntegerEntry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)enchantmentIntegerEntry.getKey();
            Integer integer = (Integer)enchantmentIntegerEntry.getValue();
            if (enchantment.m_6589_() && depleted) continue;
            i += enchantment.m_6183_(integer.intValue());
        }
        return i;
    }

    private static ItemStack removeEnchants(ItemStack stack, int damage, boolean depleted) {
        ItemStack itemStack = stack.m_41777_();
        itemStack.m_41749_("Enchantments");
        itemStack.m_41749_("StoredEnchantments");
        if (damage > 0) {
            itemStack.m_41721_(damage);
        } else {
            itemStack.m_41749_("Damage");
        }
        itemStack.m_41764_(1);
        Map<Enchantment, Integer> map = EnchantmentHelper.m_44831_((ItemStack)stack).entrySet().stream().filter(entry -> (depleted || !((Enchantment)entry.getKey()).m_6589_()) && ((Enchantment)entry.getKey()).m_6589_()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.m_44865_(map, (ItemStack)itemStack);
        itemStack.m_41742_(0);
        if (itemStack.m_150930_(Items.f_42690_) && map.size() == 0) {
            itemStack = new ItemStack((ItemLike)Items.f_42517_);
            if (stack.m_41788_()) {
                itemStack.m_41714_(stack.m_41786_());
            }
        }
        return itemStack;
    }

    static {
        EVENTS.add(ModEvents::obsidianDraining);
        EVENTS.add(ModEvents::portalCauldronLogic);
        EVENTS.add(ModEvents::saltBoiling);
        EVENTS.add(ModEvents::anvilRepairing);
        EVENTS.add(ModEvents::disenchant);
    }

    @FunctionalInterface
    public static interface InteractionEvent {
        public InteractionResult run(Item var1, ItemStack var2, BlockPos var3, BlockState var4, Player var5, Level var6, InteractionHand var7, BlockHitResult var8);
    }
}

