/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ordana.spelunkery.SpelunkeryClient;
import com.ordana.spelunkery.items.ParachuteItem;
import com.ordana.spelunkery.reg.ModItems;
import com.ordana.spelunkery.utils.IParachuteEntity;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ParachuteLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
    private final ParachuteMode parachuteMode = ParachuteMode.VISIBLE;

    public ParachuteLayer(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(livingEntity instanceof IParachuteEntity)) {
            return;
        }
        ParachuteMode mode = this.parachuteMode;
        ItemStack myParachute = ((IParachuteEntity)livingEntity).getParachute();
        if (mode == ParachuteMode.HIDDEN || !ParachuteItem.getActive(myParachute)) {
            return;
        }
        if (!myParachute.m_41619_()) {
            float x;
            poseStack.m_85836_();
            poseStack.m_252781_(RotHlpr.X180);
            BakedModel model = ClientHelper.getModel((ModelManager)Minecraft.m_91087_().m_91304_(), (ResourceLocation)SpelunkeryClient.PARACHUTE_3D_MODEL);
            float ticks = (float)((IParachuteEntity)livingEntity).getParachuteTicks() + partialTick;
            int timeToOpen = 15;
            float scaleH = x = Math.min(1.0f, ticks / (float)timeToOpen);
            float scaleW = x * x;
            poseStack.m_85837_(0.0, 0.5 + (double)(scaleH / 2.0f), 0.0);
            poseStack.m_85841_(scaleW, scaleH, scaleW);
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
            this.itemRenderer.m_115143_(ModItems.PARACHUTE.get().m_7968_(), ItemDisplayContext.HEAD, false, poseStack, buffer, packedLight, OverlayTexture.f_118083_, model);
            poseStack.m_85849_();
        }
    }

    public static enum ParachuteMode {
        HIDDEN,
        VISIBLE;

    }
}

