/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.AbstractCaveGenerationStructurePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class DinoBowlStructurePiece
extends AbstractCaveGenerationStructurePiece {
    public DinoBowlStructurePiece(BlockPos chunkCorner, BlockPos holeCenter, int bowlHeight, int bowlRadius) {
        super((StructurePieceType)ACStructurePieceRegistry.DINO_BOWL.get(), chunkCorner, holeCenter, bowlHeight, bowlRadius);
    }

    public DinoBowlStructurePiece(CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.DINO_BOWL.get(), tag);
    }

    public DinoBowlStructurePiece(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        this(tag);
    }

    public void m_213694_(WorldGenLevel level, StructureManager featureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        int cornerX = this.chunkCorner.m_123341_();
        int cornerY = this.chunkCorner.m_123342_();
        int cornerZ = this.chunkCorner.m_123343_();
        boolean flag = false;
        BlockPos.MutableBlockPos carve = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos carveAbove = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos carveBelow = new BlockPos.MutableBlockPos();
        carve.m_122178_(cornerX, cornerY, cornerZ);
        carveAbove.m_122178_(cornerX, cornerY, cornerZ);
        carveBelow.m_122178_(cornerX, cornerY, cornerZ);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                MutableBoolean doFloor = new MutableBoolean(false);
                for (int y = 15; y >= 0; --y) {
                    carve.m_122178_(cornerX + x, Mth.m_14045_((int)(cornerY + y), (int)level.m_141937_(), (int)level.m_151558_()), cornerZ + z);
                    if (!this.inCircle((BlockPos)carve) || this.checkedGetBlock(level, (BlockPos)carve).m_60713_(Blocks.f_50752_)) continue;
                    flag = true;
                    this.checkedSetBlock(level, (BlockPos)carve, Blocks.f_50627_.m_49966_());
                    this.surroundCornerOfLiquid(level, (Vec3i)carve);
                    carveBelow.m_122178_(carve.m_123341_(), carve.m_123342_() - 1, carve.m_123343_());
                    doFloor.setTrue();
                }
                if (!doFloor.isTrue()) continue;
                BlockState floor = this.checkedGetBlock(level, (BlockPos)carveBelow);
                if (!floor.m_60795_() && !floor.m_204336_(ACTagRegistry.VOLCANO_BLOCKS)) {
                    this.decorateFloor(level, random, carveBelow.m_7949_());
                }
                doFloor.setFalse();
            }
        }
        if (flag) {
            this.replaceBiomes(level, ACBiomeRegistry.PRIMORDIAL_CAVES, 32);
        }
    }

    private void surroundCornerOfLiquid(WorldGenLevel level, Vec3i center) {
        BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.values()) {
            offset.m_122190_(center);
            offset.m_122173_(dir);
            BlockState state = this.checkedGetBlock(level, (BlockPos)offset);
            if (state.m_60819_().m_76178_()) continue;
            this.checkedSetBlock(level, (BlockPos)offset, Blocks.f_50062_.m_49966_());
        }
    }

    private boolean inCircle(BlockPos carve) {
        double targetRadius;
        float wallNoise = (ACMath.sampleNoise3D(carve.m_123341_(), (int)((float)carve.m_123342_() * 0.1f), carve.m_123343_(), 40.0f) + 1.0f) * 0.5f;
        double yDist = ACMath.smin(1.0f - (float)Math.abs(this.holeCenter.m_123342_() - carve.m_123342_()) / ((float)this.height * 0.5f), 1.0f, 0.3f);
        double distToCenter = carve.m_203202_((double)this.holeCenter.m_123341_(), (double)carve.m_123342_(), (double)this.holeCenter.m_123343_());
        return distToCenter < (targetRadius = yDist * (double)((float)this.radius * wallNoise) * (double)this.radius);
    }

    private void decorateFloor(WorldGenLevel level, RandomSource rand, BlockPos carveBelow) {
        BlockState grass = Blocks.f_50440_.m_49966_();
        BlockState dirt = Blocks.f_50493_.m_49966_();
        this.checkedSetBlock(level, carveBelow, grass);
        for (int i = 0; i < 1 + rand.m_188503_(2); ++i) {
            carveBelow = carveBelow.m_7495_();
            this.checkedSetBlock(level, carveBelow, dirt);
        }
    }
}

