/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure;

import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.ACStructureRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ForlornBridgeStructurePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class ForlornBridgeStructure
extends Structure {
    public static int BRIDGE_SECTION_LENGTH = 6;
    public static int BRIDGE_SECTION_WIDTH = 4;
    public static final Codec<ForlornBridgeStructure> CODEC = ForlornBridgeStructure.m_226607_(settings -> new ForlornBridgeStructure((Structure.StructureSettings)settings));

    protected ForlornBridgeStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        return this.atYCaveBiomePoint(context, Heightmap.Types.OCEAN_FLOOR_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, context));
    }

    protected Optional<Structure.GenerationStub> atYCaveBiomePoint(Structure.GenerationContext context, Heightmap.Types heightMap, Consumer<StructurePiecesBuilder> builderConsumer) {
        ChunkPos chunkpos = context.f_226628_();
        int i = chunkpos.m_151390_();
        int j = chunkpos.m_151393_();
        int k = -10;
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, k, j), builderConsumer));
    }

    public void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        int i = context.f_226628_().m_45604_();
        int j = context.f_226628_().m_45605_();
        int k = context.f_226622_().m_6337_();
        BlockPos xzCoords = new BlockPos(i, -10, j);
        int biomeUp = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.UP, xzCoords, 32);
        int biomeDown = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), Direction.DOWN, xzCoords, 32);
        BlockPos center = xzCoords.m_6625_(biomeDown).m_6630_(worldgenrandom.m_188503_(Math.max(biomeUp, 10)));
        Direction bridgeDirection = (Direction)Util.m_214670_((Object[])ACMath.HORIZONTAL_DIRECTIONS, (RandomSource)worldgenrandom);
        int biomeForwards = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), bridgeDirection, center, 32 + worldgenrandom.m_188503_(6) * 16);
        int biomeBackwards = this.biomeContinuesInDirectionFor(context.f_226623_(), context.f_226624_(), bridgeDirection.m_122424_(), center, 32 + worldgenrandom.m_188503_(6) * 16);
        int maxSections = (int)Math.ceil((biomeBackwards + biomeForwards) / BRIDGE_SECTION_LENGTH);
        for (int section = 0; section <= maxSections; ++section) {
            BlockPos at = center.m_5484_(bridgeDirection, section * BRIDGE_SECTION_LENGTH - BRIDGE_SECTION_LENGTH / 2 - biomeBackwards);
            builder.m_142679_((StructurePiece)new ForlornBridgeStructurePiece(at, section, maxSections, bridgeDirection));
        }
    }

    private static Holder<Biome> getBiomeHolder(BiomeSource biomeSource, RandomState randomState, BlockPos pos) {
        return biomeSource.m_203407_(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175400_((int)pos.m_123343_()), randomState.m_224579_());
    }

    protected int biomeContinuesInDirectionFor(BiomeSource biomeSource, RandomState randomState, Direction direction, BlockPos start, int cutoff) {
        BlockPos check;
        Holder<Biome> biomeHolder;
        int i;
        for (i = 0; i < cutoff && (biomeHolder = ForlornBridgeStructure.getBiomeHolder(biomeSource, randomState, check = start.m_5484_(direction, i))).m_203565_(ACBiomeRegistry.FORLORN_HOLLOWS); i += 16) {
        }
        return Math.min(i, cutoff);
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ACStructureRegistry.FORLORN_BRIDGE.get();
    }
}

