/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalRandomlySwimGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.VerticalSwimmingMoveControl;
import com.github.alexmodguy.alexscaves.server.entity.living.GossamerWormPartEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class GossamerWormEntity
extends WaterAnimal
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(GossamerWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final GossamerWormPartEntity tail1Part;
    public final GossamerWormPartEntity tail2Part;
    public final GossamerWormPartEntity tail3Part;
    public final GossamerWormPartEntity tail4Part;
    public final GossamerWormPartEntity tail5Part;
    private final GossamerWormPartEntity[] allParts;
    private float fishPitch = 0.0f;
    private float prevFishPitch = 0.0f;
    private float fakeYRot = 0.0f;
    private float[][] trailTransformations = new float[128][2];
    private int trailPointer = -1;
    private float squishProgress;
    private float prevSquishProgress;
    private BlockPos hurtPos = null;
    private int fleeFor = 0;

    public GossamerWormEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.tail1Part = new GossamerWormPartEntity(this, (Entity)this, 1.1f, 0.5f);
        this.tail2Part = new GossamerWormPartEntity(this, (Entity)this.tail1Part, 1.1f, 0.5f);
        this.tail3Part = new GossamerWormPartEntity(this, (Entity)this.tail2Part, 1.0f, 0.5f);
        this.tail4Part = new GossamerWormPartEntity(this, (Entity)this.tail3Part, 0.8f, 0.5f);
        this.tail5Part = new GossamerWormPartEntity(this, (Entity)this.tail4Part, 0.6f, 0.5f);
        this.allParts = new GossamerWormPartEntity[]{this.tail1Part, this.tail2Part, this.tail3Part, this.tail4Part, this.tail5Part};
        this.f_21342_ = new VerticalSwimmingMoveControl((Mob)this, 0.8f, 4.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.fakeYRot = this.m_146908_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AvoidHurtGoal());
        this.f_21345_.m_25352_(1, (Goal)new AnimalRandomlySwimGoal((Mob)this, 3, 12, 20, 1.0));
    }

    protected void m_5625_(float f) {
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.5f * dimensions.f_20378_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22276_, 10.0);
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        super.m_142687_(removalReason);
        if (this.allParts != null) {
            for (GossamerWormPartEntity part : this.allParts) {
                part.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    public void m_8119_() {
        boolean grounded;
        this.prevFishPitch = this.fishPitch;
        this.prevSquishProgress = this.squishProgress;
        super.m_8119_();
        this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)this.f_20883_, (float)this.m_21529_());
        this.fakeYRot = Mth.m_14148_((float)this.fakeYRot, (float)this.f_20883_, (float)10.0f);
        this.tickMultipart();
        float targetPitch = this.m_20072_() ? Mth.m_14036_((float)((float)this.m_20184_().f_82480_ * 25.0f), (float)-1.4f, (float)1.4f) * -57.295776f : 0.0f;
        this.fishPitch = Mth.m_14148_((float)this.fishPitch, (float)targetPitch, (float)1.0f);
        if (this.fleeFor > 0) {
            --this.fleeFor;
            if (this.fleeFor == 0) {
                this.hurtPos = null;
            }
        }
        boolean bl = grounded = !this.m_20072_();
        if (grounded && this.squishProgress < 5.0f) {
            this.squishProgress += 1.0f;
        }
        if (!grounded && this.squishProgress > 0.0f) {
            this.squishProgress -= 1.0f;
        }
        if (grounded && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f), 0.25, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f)));
        }
    }

    private void tickMultipart() {
        if (this.trailPointer == -1) {
            this.fakeYRot = this.f_20883_;
            for (int i = 0; i < this.trailTransformations.length; ++i) {
                this.trailTransformations[i][0] = this.fishPitch;
                this.trailTransformations[i][1] = this.fakeYRot;
            }
        }
        if (++this.trailPointer == this.trailTransformations.length) {
            this.trailPointer = 0;
        }
        this.trailTransformations[this.trailPointer][0] = this.fishPitch;
        this.trailTransformations[this.trailPointer][1] = this.fakeYRot;
        Vec3[] avector3d = new Vec3[this.allParts.length];
        for (int j = 0; j < this.allParts.length; ++j) {
            avector3d[j] = new Vec3(this.allParts[j].m_20185_(), this.allParts[j].m_20186_(), this.allParts[j].m_20189_());
        }
        this.tail1Part.setToTransformation(new Vec3(0.0, 0.0, -1.0), this.getTrailTransformation(5, 0, 1.0f), this.getTrailTransformation(5, 1, 1.0f));
        this.tail2Part.setToTransformation(new Vec3(0.0, 0.0, (double)-0.9f), this.getTrailTransformation(10, 0, 1.0f), this.getTrailTransformation(10, 1, 1.0f));
        this.tail3Part.setToTransformation(new Vec3(0.0, 0.0, (double)-0.8f), this.getTrailTransformation(15, 0, 1.0f), this.getTrailTransformation(15, 1, 1.0f));
        this.tail4Part.setToTransformation(new Vec3(0.0, 0.0, (double)-0.7f), this.getTrailTransformation(20, 0, 1.0f), this.getTrailTransformation(20, 1, 1.0f));
        this.tail5Part.setToTransformation(new Vec3(0.0, 0.0, (double)-0.6f), this.getTrailTransformation(25, 0, 1.0f), this.getTrailTransformation(25, 1, 1.0f));
        for (int l = 0; l < this.allParts.length; ++l) {
            this.allParts[l].f_19854_ = avector3d[l].f_82479_;
            this.allParts[l].f_19855_ = avector3d[l].f_82480_;
            this.allParts[l].f_19856_ = avector3d[l].f_82481_;
            this.allParts[l].f_19790_ = avector3d[l].f_82479_;
            this.allParts[l].f_19791_ = avector3d[l].f_82480_;
            this.allParts[l].f_19792_ = avector3d[l].f_82481_;
        }
    }

    public float getSquishProgress(float partialTicks) {
        return (this.prevSquishProgress + (this.squishProgress - this.prevSquishProgress) * partialTicks) * 0.2f;
    }

    public int m_21529_() {
        return 4;
    }

    protected static float lerpRotation(float p_37274_, float p_37275_) {
        while (p_37275_ - p_37274_ < -180.0f) {
            p_37274_ -= 360.0f;
        }
        while (p_37275_ - p_37274_ >= 180.0f) {
            p_37274_ += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)p_37274_, (float)p_37275_);
    }

    public float getFishPitch(float partialTick) {
        return this.prevFishPitch + (this.fishPitch - this.prevFishPitch) * partialTick;
    }

    public float getTrailTransformation(int pointer, int index, float partialTick) {
        if (this.m_213877_()) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x7F;
        int j = this.trailPointer - pointer - 1 & 0x7F;
        float d0 = this.trailTransformations[j][index];
        float d1 = this.trailTransformations[i][index] - d0;
        return d0 + d1 * partialTick;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20072_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            Vec3 delta = this.m_20184_();
            this.m_6478_(MoverType.SELF, delta);
            this.m_20256_(delta.m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float damageValue) {
        boolean sup = super.m_6469_(damageSource, damageValue);
        if (sup) {
            this.fleeFor = 40 + this.f_19796_.m_188503_(40);
            this.hurtPos = this.m_20183_();
        }
        return sup;
    }

    public static boolean checkGossamerWormSpawnRules(EntityType<? extends LivingEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return level.m_6425_(pos).m_205070_(FluidTags.f_13131_) && pos.m_123342_() < level.m_5736_() - 25 && randomSource.m_188503_(3) == 0;
    }

    private void doInitialPosing(LevelAccessor world) {
        BlockPos down = this.m_20183_();
        while (!world.m_6425_(down).m_76178_() && down.m_123342_() > world.m_141937_()) {
            down = down.m_7495_();
        }
        float f = this.m_20183_().m_123342_() - down.m_123342_();
        this.m_6034_((float)down.m_123341_() + 0.5f, (float)down.m_123342_() + f * (this.f_19796_.m_188501_() * 0.33f + 0.33f), (float)down.m_123343_() + 0.5f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.NATURAL) {
            this.doInitialPosing((LevelAccessor)worldIn);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public int m_5792_() {
        return 1;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.allParts;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        CompoundTag platTag = new CompoundTag();
        this.m_7380_(platTag);
        CompoundTag compound = bucket.m_41784_();
        compound.m_128365_("FishBucketTag", (Tag)platTag);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double dist) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean sit) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)sit);
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        if (compound.m_128441_("FishBucketTag")) {
            this.m_7378_(compound.m_128469_("FishBucketTag"));
        }
        this.m_20301_(2000);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ACItemRegistry.GOSSAMER_WORM_BUCKET.get());
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.GOSSAMER_WORM_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.GOSSAMER_WORM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.GOSSAMER_WORM_DEATH.get();
    }

    class AvoidHurtGoal
    extends Goal {
        private Vec3 fleeTarget = null;

        protected AvoidHurtGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return GossamerWormEntity.this.hurtPos != null && GossamerWormEntity.this.fleeFor > 0;
        }

        public void m_8056_() {
            this.fleeTarget = null;
        }

        public void m_8037_() {
            if ((this.fleeTarget == null || GossamerWormEntity.this.m_20238_(this.fleeTarget) < 6.0) && GossamerWormEntity.this.hurtPos != null) {
                this.fleeTarget = DefaultRandomPos.m_148407_((PathfinderMob)GossamerWormEntity.this, (int)16, (int)7, (Vec3)Vec3.m_82512_((Vec3i)GossamerWormEntity.this.hurtPos));
            }
            if (this.fleeTarget != null) {
                GossamerWormEntity.this.m_21573_().m_26519_(this.fleeTarget.f_82479_, this.fleeTarget.f_82480_, this.fleeTarget.f_82481_, (double)1.6f);
            }
        }
    }
}

