/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.PewenBranchBlock;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalBreedEggsGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalLayEggGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AtlatitanMeleeGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AtlatitanNibbleTreesGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.LookForwardsGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.SauropodBaseEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.KeybindUsingMount;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.message.MountedEntityKeyMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AtlatitanEntity
extends SauropodBaseEntity
implements KeybindUsingMount {
    private static final EntityDataAccessor<Optional<BlockPos>> EATING_POS = SynchedEntityData.m_135353_(AtlatitanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<BlockState>> LAST_EATEN_BLOCK = SynchedEntityData.m_135353_(AtlatitanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268618_);
    private static final EntityDataAccessor<Integer> RIDEABLE_FOR = SynchedEntityData.m_135353_(AtlatitanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> METER_AMOUNT = SynchedEntityData.m_135353_(AtlatitanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public AtlatitanEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AtlatitanMeleeGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AnimalBreedEggsGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new AnimalLayEggGoal((Animal)this, 100, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACBlockRegistry.TREE_STAR.get()}), false));
        this.f_21345_.m_25352_(5, (Goal)new AtlatitanNibbleTreesGoal(this, 30));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 50){

            protected Vec3 m_7037_() {
                return DefaultRandomPos.m_148403_((PathfinderMob)this.f_25725_, (int)30, (int)7);
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 30.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 10.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookForwardsGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AtlatitanEntity.class}));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EATING_POS, Optional.empty());
        this.f_19804_.m_135372_(LAST_EATEN_BLOCK, Optional.empty());
        this.f_19804_.m_135372_(RIDEABLE_FOR, (Object)0);
        this.f_19804_.m_135372_(METER_AMOUNT, (Object)Float.valueOf(1.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.325).m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 8.0);
    }

    @Override
    protected void onStep() {
        if (!this.m_6162_()) {
            if (this.screenShakeAmount <= 1.0f) {
                this.m_5496_((SoundEvent)ACSoundRegistry.ATLATITAN_STEP.get(), 2.0f, 1.0f);
            }
            if (this.screenShakeAmount <= 1.0f) {
                this.screenShakeAmount = 1.0f;
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            Player player;
            BlockState lastEatenBlock;
            if (this.getAnimation() == ANIMATION_EAT_LEAVES && this.getAnimationTick() > 35 && this.getAnimationTick() < 90 && (lastEatenBlock = this.getLastEatenBlock()) != null) {
                Vec3 crumbPos = this.headPart.m_20182_().m_82520_((double)((this.f_19796_.m_188501_() - 0.5f) * 2.0f * this.m_6134_()), (double)((0.5f + (this.f_19796_.m_188501_() - 0.5f) * 0.2f) * this.m_6134_()), (double)((this.f_19796_.m_188501_() - 0.5f) * 2.0f * this.m_6134_()));
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, lastEatenBlock), crumbPos.f_82479_, crumbPos.f_82480_, crumbPos.f_82481_, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1);
            }
            if (this.getRideableFor() > 0 && this.m_9236_().f_46441_.m_188503_(2) == 0 && !this.isDancing()) {
                Vec3 particlePos = this.headPart.m_20182_().m_82520_((double)((this.f_19796_.m_188501_() - 0.5f) * 2.0f * this.m_6134_()), (double)(this.f_19796_.m_188501_() * 2.0f * this.m_6134_()), (double)((this.f_19796_.m_188501_() - 0.5f) * 2.0f * this.m_6134_())).m_82549_(this.m_20184_());
                this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.HAPPINESS.get(), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1);
            }
            if ((player = AlexsCaves.PROXY.getClientSidePlayer()) != null && player.m_20365_((Entity)this) && AlexsCaves.PROXY.isKeyDown(2) && this.getMeterAmount() >= 1.0f) {
                AlexsCaves.sendMSGToServer(new MountedEntityKeyMessage(this.m_19879_(), player.m_19879_(), 2));
            }
        } else {
            Vec3 armPos;
            if (this.getAnimation() == ANIMATION_STOMP && this.getAnimationTick() == 30) {
                this.m_5496_((SoundEvent)ACSoundRegistry.ATLATITAN_STOMP.get(), 3.0f, 1.0f);
                if (this.screenShakeAmount < 4.0f) {
                    this.screenShakeAmount = 4.0f;
                }
                this.crushBlocksInRing(15, this.m_146903_(), this.m_146907_(), 1.0f);
                if (this.m_20160_() && !this.m_9236_().f_46443_) {
                    for (Entity passenger : this.m_20197_()) {
                        ACAdvancementTriggerRegistry.ATLATITAN_STOMP.triggerForEntity(passenger);
                    }
                }
            }
            if (this.getRideableFor() > 0) {
                this.setRideableFor(this.getRideableFor() - 1);
            }
            if (this.f_19797_ % 100 == 0 && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(2.0f);
            }
            if (this.getAnimation() == ANIMATION_RIGHT_KICK && this.getAnimationTick() == 8) {
                armPos = this.m_20182_().m_82549_(this.rotateOffsetVec(new Vec3(-2.0, 0.0, 2.5), 0.0f, this.f_20883_));
                this.hurtEntitiesAround(armPos, 5.0f, (float)this.m_21133_(Attributes.f_22281_) * 0.8f, 1.0f, false, false);
            }
            if (this.getAnimation() == ANIMATION_LEFT_KICK && this.getAnimationTick() == 8) {
                armPos = this.m_20182_().m_82549_(this.rotateOffsetVec(new Vec3(2.0, 0.0, 2.5), 0.0f, this.f_20883_));
                this.hurtEntitiesAround(armPos, 5.0f, (float)this.m_21133_(Attributes.f_22281_) * 0.8f, 1.0f, false, false);
            }
            if ((this.getAnimation() == ANIMATION_LEFT_WHIP || this.getAnimation() == ANIMATION_RIGHT_WHIP) && this.getAnimationTick() > 20 && this.getAnimationTick() < 30) {
                this.hurtEntitiesAround(this.tailPart2.m_20182_(), 12.0f, (float)this.m_21133_(Attributes.f_22281_), 1.0f, false, false);
            }
        }
        if (this.m_20160_()) {
            if (this.getMeterAmount() < 1.0f) {
                this.setMeterAmount(Math.min(this.getMeterAmount() + 0.0025f, 1.0f));
            }
        } else {
            this.setMeterAmount(0.0f);
        }
    }

    public BlockPos getEatingPos() {
        return ((Optional)this.f_19804_.m_135370_(EATING_POS)).orElse(null);
    }

    public void setEatingPos(BlockPos eatingPos) {
        this.f_19804_.m_135381_(EATING_POS, Optional.ofNullable(eatingPos));
    }

    public BlockState getLastEatenBlock() {
        return ((Optional)this.f_19804_.m_135370_(LAST_EATEN_BLOCK)).orElse(null);
    }

    public void setLastEatenBlock(BlockState eatingPos) {
        this.f_19804_.m_135381_(LAST_EATEN_BLOCK, Optional.ofNullable(eatingPos));
    }

    public void setRideableFor(int time) {
        this.f_19804_.m_135381_(RIDEABLE_FOR, (Object)time);
    }

    public int getRideableFor() {
        return (Integer)this.f_19804_.m_135370_(RIDEABLE_FOR);
    }

    @Override
    public boolean onFeedMixture(ItemStack itemStack, Player player) {
        if (itemStack.m_150930_((Item)ACItemRegistry.SERENE_SALAD.get())) {
            this.setRideableFor(12000);
            return true;
        }
        return false;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(((Block)ACBlockRegistry.TREE_STAR.get()).m_5456_());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setRideableFor(compound.m_128451_("RideableTime"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("RideableTime", this.getRideableFor());
    }

    @Override
    public void onKeyPacket(Entity keyPresser, int type) {
        if (keyPresser.m_20365_((Entity)this) && type == 2 && this.getMeterAmount() >= 1.0f && (this.getAnimation() == NO_ANIMATION || this.getAnimation() == null)) {
            this.f_20883_ = keyPresser.m_6080_();
            this.m_146922_(keyPresser.m_6080_());
            this.setAnimation(ANIMATION_STOMP);
            this.setMeterAmount(0.0f);
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult prev = super.m_6071_(player, hand);
        ItemStack itemstack = player.m_21120_(hand);
        if (!prev.m_19077_() && itemstack.m_150930_((Item)ACItemRegistry.SERENE_SALAD.get()) && !this.m_6162_()) {
            if (!itemstack.getCraftingRemainingItem().m_41619_()) {
                this.m_19983_(itemstack.getCraftingRemainingItem().m_41777_());
            }
            this.m_142075_(player, hand, itemstack);
            return InteractionResult.SUCCESS;
        }
        if (!prev.m_19077_() && this.getRideableFor() > 0 && !this.m_6162_() && this.m_7310_((Entity)player)) {
            player.m_20329_((Entity)this);
        }
        return prev;
    }

    @Override
    public float getTargetNeckXRot() {
        BlockPos eatingPos;
        if (this.getAnimation() == ANIMATION_EAT_LEAVES && this.getAnimationTick() <= 35 && (eatingPos = this.getEatingPos()) != null) {
            float peckDist = (float)Mth.m_14008_((double)((double)((float)eatingPos.m_123342_() + 0.5f) - this.m_20186_()), (double)-6.0, (double)12.0) - 6.0f;
            return peckDist * 1.2f / 6.0f * -90.0f;
        }
        return super.getTargetNeckXRot();
    }

    public BlockPos getStandAtTreePos(BlockPos target) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)target).m_82546_(this.m_20182_());
        float f = -((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 180.0f / (float)Math.PI;
        BlockState state = this.m_9236_().m_8055_(target);
        Direction dir = Direction.m_122364_((double)f);
        if (state.m_60713_((Block)ACBlockRegistry.PEWEN_BRANCH.get())) {
            dir = Direction.m_122364_((double)((Integer)state.m_61143_((Property)PewenBranchBlock.ROTATION) * 45));
        }
        if (this.m_9236_().m_8055_(target.m_7495_()).m_60795_()) {
            target = target.m_121945_(dir);
        }
        return target.m_5484_(dir.m_122424_(), (int)Math.floor(13.0f * this.m_6134_())).m_175288_((int)this.m_20186_());
    }

    public boolean lockTreePosition(BlockPos target) {
        Vec3 vec31;
        Vec3 vec3 = Vec3.m_82512_((Vec3i)target).m_82546_(this.m_20182_());
        float f = -((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 180.0f / (float)Math.PI;
        int headDistToBody = (int)Math.floor(14.0f * this.m_6134_());
        BlockState state = this.m_9236_().m_8055_(target);
        Direction dir = Direction.m_122364_((double)f);
        if (state.m_60713_((Block)ACBlockRegistry.PEWEN_BRANCH.get())) {
            dir = Direction.m_122364_((double)((Integer)state.m_61143_((Property)PewenBranchBlock.ROTATION) * 45));
        }
        float targetRot = Mth.m_14148_((float)this.m_146908_(), (float)dir.m_122435_(), (float)20.0f);
        this.m_146922_(targetRot);
        this.m_5616_(targetRot);
        this.f_20883_ = Mth.m_14148_((float)this.f_20883_, (float)targetRot, (float)10.0f);
        this.m_21563_().m_24946_((double)target.m_123341_(), (double)target.m_123342_(), (double)target.m_123343_());
        if (this.m_9236_().m_8055_(target.m_7495_()).m_60795_()) {
            target = target.m_121945_(dir);
        }
        if ((vec31 = Vec3.m_82512_((Vec3i)target.m_5484_(dir.m_122424_(), headDistToBody - 1))).m_82531_(this.m_20185_(), vec31.f_82480_, this.m_20189_()) > 1.0) {
            this.m_21566_().m_6849_(vec31.f_82479_, this.m_20186_(), vec31.f_82481_, 1.0);
        }
        return this.m_20275_(vec31.f_82479_, this.m_20186_(), vec31.f_82481_) < (double)headDistToBody && Mth.m_14145_((float)this.f_20883_, (float)dir.m_122435_()) < 7.0f;
    }

    protected Vec3 m_274312_(Player player, Vec3 deltaIn) {
        float f = player.f_20902_ < 0.0f ? 0.5f : 1.0f;
        return new Vec3((double)(player.f_20900_ * 0.35f), 0.0, (double)(player.f_20902_ * 0.8f * f));
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        if (player.f_20902_ != 0.0f || player.f_20900_ != 0.0f) {
            this.m_19915_(player.m_146908_(), player.m_146909_() * 0.25f);
            this.m_6710_(null);
            this.f_19804_.m_135381_(WALKING, (Object)true);
        } else {
            this.f_19804_.m_135381_(WALKING, (Object)false);
        }
    }

    protected float m_245547_(Player rider) {
        float threshold;
        float f;
        float f1 = 0.0f;
        if (this.areLegsMoving() && (f = this.getLegSlamAmount(2.0f, 0.66f)) >= (threshold = 0.65f)) {
            f1 = (f - threshold) / (1.0f - threshold);
        }
        return (float)this.m_21133_(Attributes.f_22279_) * f1;
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20365_(passenger) && passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            if (!this.m_146899_()) {
                float seatY = 0.5f;
                float seatZ = 0.5f;
                if (this.getAnimation() == ANIMATION_STOMP) {
                    float animationIntensity = ACMath.cullAnimationTick(this.getAnimationTick(), 1.0f, ANIMATION_STOMP, 1.0f, 0, 30);
                    seatY += animationIntensity * 1.5f;
                    seatZ += animationIntensity * -4.5f;
                }
                Vec3 seatOffset = new Vec3(0.0, (double)seatY, (double)seatZ).m_82524_((float)Math.toRadians(-this.f_20883_));
                passenger.m_5618_(this.f_20883_);
                passenger.f_19789_ = 0.0f;
                this.clampRotation(living, 105.0f);
                moveFunction.m_20372_(passenger, this.m_20185_() + seatOffset.f_82479_, this.m_20186_() + seatOffset.f_82480_ + this.m_6048_() - (double)this.getLegSolverBodyOffset(), this.m_20189_() + seatOffset.f_82481_);
                return;
            }
        }
        super.m_19956_(passenger, moveFunction);
    }

    public Vec3 m_7688_(LivingEntity p_20123_) {
        return new Vec3(this.m_20185_(), this.m_20191_().f_82289_, this.m_20189_());
    }

    public int m_213860_() {
        return 30;
    }

    @Override
    public boolean hasRidingMeter() {
        return true;
    }

    @Override
    public float getMeterAmount() {
        return ((Float)this.f_19804_.m_135370_(METER_AMOUNT)).floatValue();
    }

    public void setMeterAmount(float roarPower) {
        this.f_19804_.m_135381_(METER_AMOUNT, (Object)Float.valueOf(roarPower));
    }

    @Override
    public BlockState createEggBlockState() {
        return ((Block)ACBlockRegistry.ATLATITAN_EGG.get()).m_49966_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)ACEntityRegistry.ATLATITAN.get()).m_20615_((Level)level);
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.15f : 1.0f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.ATLATITAN_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.ATLATITAN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.ATLATITAN_DEATH.get();
    }
}

