/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.block.poi.ACPOIRegistry;
import com.github.alexmodguy.alexscaves.server.message.SundropRainbowMessage;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SundropBlock
extends DirectionalBlock {
    public SundropBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.YELLOW).m_60913_(2.0f, 5.0f).m_60918_(ACSoundTypes.SQUISHY_CANDY).m_60953_(i -> 15).m_60991_((state, level, pos) -> true).m_60977_().m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.UP));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{f_52588_});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)context.m_43719_());
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (randomSource.m_188503_(2) == 0 && AlexsCaves.PROXY.checkIfParticleAt((SimpleParticleType)ACParticleRegistry.SUNDROP.get(), blockPos)) {
            level.m_7106_((ParticleOptions)ACParticleRegistry.SUNDROP.get(), (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public void m_142072_(Level level, BlockState blockState, BlockPos blockPos, Entity entity, float fallAmount) {
        if (entity.m_20162_()) {
            super.m_142072_(level, blockState, blockPos, entity, fallAmount);
        } else {
            entity.m_142535_(fallAmount, 0.0f, level.m_269111_().m_268989_());
        }
    }

    public void m_5548_(BlockGetter getter, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(getter, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vec3 = entity.m_20184_();
        if (vec3.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * d0, vec3.f_82481_);
        }
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos posIn, RandomSource randomSource) {
        int range;
        PoiManager pointofinterestmanager;
        Optional<BlockPos> rainbowTarget;
        if (randomSource.m_188503_(2) != 0 && serverLevel.m_46805_(posIn) && (rainbowTarget = Optional.ofNullable((pointofinterestmanager = serverLevel.m_8904_()).m_217951_(poiTypeHolder -> poiTypeHolder.m_203565_(ACPOIRegistry.SUNDROP.getKey()), arg_0 -> this.lambda$randomTick$3(serverLevel, posIn, range = 30, arg_0), PoiManager.Occupancy.ANY, posIn, range, randomSource).orElse(null))).isPresent() && serverLevel.m_46805_(rainbowTarget.get())) {
            BlockPos target = rainbowTarget.get();
            AlexsCaves.sendMSGToAll(new SundropRainbowMessage(posIn.m_123341_(), posIn.m_123342_(), posIn.m_123343_(), target.m_123341_(), target.m_123342_(), target.m_123343_()));
        }
    }

    private boolean canSendRainbowTo(ServerLevel serverLevel, BlockPos from, BlockPos to, int range) {
        if (from.equals((Object)to) || !serverLevel.m_46805_(to)) {
            return false;
        }
        int distance = (int)Math.sqrt(from.m_123331_((Vec3i)to));
        return distance < range;
    }

    public void m_141947_(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        super.m_141947_(level, blockPos, blockState, entity);
    }

    private /* synthetic */ boolean lambda$randomTick$3(ServerLevel serverLevel, BlockPos posIn, int range, BlockPos blockPos) {
        return this.canSendRainbowTo(serverLevel, posIn, blockPos, range);
    }
}

