/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.render.entity.TremorzillaRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class TremorzillaLightningParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final int tremorzillaId;
    private final Vec3 inMouthOffset;
    private final Vec3 inMouthOrigin;
    private final Vec3 beamPosOffset;

    protected TremorzillaLightningParticle(ClientLevel level, double x, double y, double z, int tremorzillaId, SpriteSet sprites) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_172258_ = 0.96f;
        this.f_107226_ = 0.0f;
        this.f_172259_ = true;
        this.sprites = sprites;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107663_ *= 2.0f + this.f_107223_.m_188501_() * 2.0f;
        this.f_107225_ = 2;
        this.m_108339_(sprites);
        this.f_107219_ = true;
        this.tremorzillaId = tremorzillaId;
        this.inMouthOffset = new Vec3(this.f_107223_.m_188499_() ? (double)0.8f : (double)-0.8f, (double)(this.f_107223_.m_188501_() * 0.8f), (double)(this.f_107223_.m_188501_() * 0.8f - 0.2f));
        this.beamPosOffset = new Vec3((double)(this.f_107223_.m_188501_() - 0.5f), (double)(this.f_107223_.m_188501_() - 0.5f), (double)(this.f_107223_.m_188501_() - 0.5f)).m_82490_(6.0);
        Vec3 vec3 = this.getInMouthPos(1.0f);
        this.f_107212_ = vec3.f_82479_;
        this.f_107213_ = vec3.f_82480_;
        this.f_107214_ = vec3.f_82481_;
        this.inMouthOrigin = vec3;
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107204_ = this.f_107231_ = (float)Math.toRadians((float)this.f_107223_.m_188503_(3) * 90.0f);
    }

    public void m_5989_() {
        Entity entity;
        super.m_5989_();
        this.m_108339_(this.sprites);
        if (this.tremorzillaId != -1 && (entity = this.f_107208_.m_6815_(this.tremorzillaId)) instanceof TremorzillaEntity) {
            TremorzillaEntity entity2 = (TremorzillaEntity)entity;
            Vec3 beamPos = entity2.getClientBeamEndPosition(1.0f);
            Vec3 inMouthPos = this.getInMouthPos(1.0f);
            if (entity2.getBeamProgress(1.0f) > 0.0f && beamPos != null) {
                Vec3 dist = beamPos.m_82549_(this.beamPosOffset).m_82546_(inMouthPos);
                int distInTicks = (int)Math.ceil(beamPos.m_82553_() * (double)0.005f);
                this.f_107225_ = Math.max(this.f_107225_, distInTicks);
                float f = Mth.m_14036_((float)((float)this.f_107224_ / (float)this.f_107225_), (float)0.0f, (float)1.0f);
                Vec3 setPosVec = inMouthPos.m_82549_(dist.m_82490_((double)f));
                this.m_107264_(setPosVec.f_82479_, setPosVec.f_82480_, setPosVec.f_82481_);
            } else {
                this.m_107274_();
            }
        }
    }

    public Vec3 getInMouthPos(float partialTick) {
        Entity entity;
        if (this.tremorzillaId != -1 && (entity = this.f_107208_.m_6815_(this.tremorzillaId)) instanceof TremorzillaEntity) {
            TremorzillaEntity entity2 = (TremorzillaEntity)entity;
            Vec3 mouthPos = TremorzillaRenderer.getMouthPositionFor(this.tremorzillaId);
            if (mouthPos != null) {
                Vec3 translate = mouthPos.m_82549_(this.inMouthOffset).m_82524_((float)(Math.PI - (double)(entity2.f_20883_ * ((float)Math.PI / 180))));
                return new Vec3(entity2.m_20185_() + translate.f_82479_, entity2.m_20186_() + translate.f_82480_, entity2.m_20189_() + translate.f_82481_);
            }
        }
        return Vec3.f_82478_;
    }

    public int m_6355_(float partialTicks) {
        return 240;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107432_;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            TremorzillaLightningParticle particle = new TremorzillaLightningParticle(worldIn, x, y, z, (int)xSpeed, this.spriteSet);
            return particle;
        }
    }
}

